<?php

include "db.class.php";
include "html.class.php";
$html = new html();
$db = new db();

$latest_sensor_res = $db->exec_query('sensors_data', ['*'], '', '', '', '', 1, "ORDER BY record_id DESC LIMIT 1");
$sensor_data = $latest_sensor_res->fetch_assoc();
?>
<style>
    body {
        margin: 0px;
        color: black;
        background-color: white;
        display: flex;
        flex-direction: column;
        align-items: stretch;
        font-family: Arial, Helvetica, sans-serif;
        touch-action: manipulation;

    }

    .header_div {
        position: relative;
        width: 100%;
        height: fit-content;
        background-color: darkgray;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-around;
        padding: 10px;
        flex-wrap: wrap;
        align-content: center;
    }

    h2 {
        color: black;
        font-size: 4vw;
    }

    .graphs {
        width: 100%;
        background-color: white;
        color: black;
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 10px;
    }

    canvas {
        width: 100%;
        height: 25px;
        /* half the original height */
        margin: 10px 0;
    }

    .blocks {
        display: flex;
        flex-direction: column;
        align-content: space-around;
        flex-wrap: nowrap;
        align-items: center;
        width: 40%;
    }

    .live_data {
        width: 100%;
        display: none;
        /* height: 80%; */
        margin-bottom: 29vw;
        position: relative;
    }

    .graph_data {
        width: 100%;
        display: none;
        /* height: 80%; */
        margin-bottom: 29vw;
        position: relative;
    }

    .footer {
        width: 100%;
        height: fit-content;
        background-color: darkgray;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-around;
        padding: 10px;
        flex-wrap: wrap;
        align-content: center;
        position: fixed;
        bottom: 0;
    }

    .button {
        background-color: #4CAF50;
        border: none;
        color: white;
        padding: 10vw 10vw;
        text-align: center;
        text-decoration: none;
        display: flex;
        font-size: 3vw;
        margin: 0.2vw 0.2vw;
        height: 5vw;
        cursor: pointer;
        align-content: center;
        justify-content: center;
        align-items: center;
        border-radius: 2vw;
        transition: all 0.2s ease-in-out;
    }

    .button:active {
        background-color: #3e8e41;
        box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.2);
        transform: translateY(2px);
    }

    .graph_dates_bar {
        display: flex;
        flex-direction: row;
        row-gap: 4vw;
        background: grey;
        width: 100%;
        column-gap: 2vw;
        padding: 3vw;
        justify-content: space-evenly;
        flex-wrap: wrap;
        align-content: center;
        align-items: flex-start;

    }

    .inputs {
        padding: 2vw;
        font-size: 3vw;
    }

    input[type='checkbox'] {
        width: 10%;
        /* min-width: 10000px; */
    }
</style>
<html>

<head>
</head>

<body>
    <div class="live_data" id="live_data">
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Onsite Data</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item">
                    <h2>Water</h2>
                    <?php echo $html->generateCircularProgressBar(0, 1000, ($sensor_data['pulses'] * 2.2 / 1000), "L", 2); ?>
                </div>
                <div class="item">
                    <h2>Temp</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['temp'], "C", 2); ?>
                </div>
                <div class="item">
                    <h2>Humid</h2>
                    <?php echo $html->generateCircularProgressBar(0, 100, $sensor_data['humidity'], "%"); ?>
                </div>
                <div class="item">
                    <h2>Soil Moist.</h2>
                    <?php echo $html->generateCircularProgressBar(0, 1000, $sensor_data['moisture_1'], ""); ?>
                </div>
                <!-- <div class="item">
                    <h2>UV</h2>
                    <?php //echo $html->generateCircularProgressBar(0, 11, $sensor_data['weather_uv'], ""); ?>
                </div> -->
                <!-- <div class="item">
                    <h2>Pressure</h2>
                    <?php //echo $html->generateCircularProgressBar(950, 1040, $sensor_data['weather_pressure'], ""); ?>
                </div> -->
            </div>
        </div>
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Weather Data</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item">
                    <h2>WEATHER</h2>
                    <span style='color:blue; font-size: 4vw;'><?php echo $sensor_data['weather_type']; ?></span>
                </div>
                <div class="item">
                    <h2>Rain: <?php echo $sensor_data['chanceofrain']; ?></h2>
                </div>
                <div class="item">
                    <h2>Temp</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['weather_temp'], "C", 2); ?>
                </div>
                <div class="item">
                    <h2>Feels Like</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['weather_feels_like'], "C"); ?>
                </div>
                <div class="item">
                    <h2>Preasure</h2>
                    <?php echo $html->generateCircularProgressBar(900, 1100, $sensor_data['weather_pressure'], ""); ?>
                </div>
                <div class="item">
                    <h2>Humidity</h2>
                    <?php echo $html->generateCircularProgressBar(0, 100, $sensor_data['weather_humidity'], ""); ?>
                </div>
                <div class="item">
                    <h2>UV</h2>
                    <?php echo $html->generateCircularProgressBar(0, 11, $sensor_data['weather_uv'], ""); ?>
                </div>
            </div>
        </div>
        <style>
            .mobile_friendly {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                flex-direction: row;
            }

            .item {
                width: calc(50% - 0.5vw);
                background-color: white;
                margin: 0.5vw;
                padding: 1vw;
                display: flex;
                width: 40%;
                flex-direction: column;
                border: 3px solid #61ab64;
                align-items: center;
                color: black;
                justify-content: center;
                /* background-color: white; */
                border-radius: 2vw;
            }

            .item h1 {
                font-size: 6vw;
            }

            .item h2 {
                font-size: 4vw;
            }

            .item span {
                font-size: 1.5vw;
            }

            .item canvas {
                width: 100%;
                height: 100%;
            }

            .item .progress {
                width: 100%;
                height: 100%;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
            }

            .item .progress span {
                font-size: 1.5vw;
            }
        </style>
    </div>
    <div class="graph_data" id="graph_data">
        <div class="graph_dates_bar">
            <div style='width:100%;'>
                <input type="datetime-local" class="inputs" style='width:49vw;height:5vh;border-radius:1vw;'
                    id="from_date" />
                <input type="datetime-local" class="inputs" style='width:49vw;height:5vh;border-radius:1vw;'
                    id="to_date" />
            </div>
            <div
                style='width:100%;font-size:4vw;display:flex;flex-wrap: wrap;flex-direction: row;justify-content: space-around;align-content: space-around;'>
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="literesCheckbox"
                    id="literesLabel">Literes</label>
                <input hidden type="checkbox" id="literesCheckbox" name="literesCheckbox"
                    onclick="toggleLabelBackground('literesLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="tempCheckbox"
                    id="tempLabel">Temp</label>
                <input hidden type="checkbox" id="tempCheckbox" name="tempCheckbox"
                    onclick="toggleLabelBackground('tempLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="humidityCheckbox"
                    id="humidityLabel">Humidity</label>
                <input hidden type="checkbox" id="humidityCheckbox" name="humidityCheckbox"
                    onclick="toggleLabelBackground('humidityLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="pressureCheckbox"
                    id="pressureLabel">Pressure</label>
                <input hidden type="checkbox" id="pressureCheckbox" name="pressureCheckbox"
                    onclick="toggleLabelBackground('pressureLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="uvCheckbox"
                    id="uvLabel">UV</label>
                <input hidden type="checkbox" id="uvCheckbox" name="uvCheckbox"
                    onclick="toggleLabelBackground('uvLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="tempWeatherCheckbox"
                    id="tempWeatherLabel">Temp Weather</label>
                <input hidden type="checkbox" id="tempWeatherCheckbox" name="tempWeatherCheckbox"
                    onclick="toggleLabelBackground('tempWeatherLabel')">
                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="humidityWeatherCheckbox"
                    id="humidityWeatherLabel">Humidity Weather</label>
                <input hidden type="checkbox" id="humidityWeatherCheckbox" name="humidityWeatherCheckbox"
                    onclick="toggleLabelBackground('humidityWeatherLabel')">

                <label style="border:1px solid black;padding:1vw;border-radius:1vw;" for="rainCheckbox"
                    id="rainCheckboxlabel">Rain</label>
                <input hidden type="checkbox" id="rainCheckbox" name="rainCheckbox"
                    onclick="toggleLabelBackground('rainCheckboxlabel')">



                <script>
                    function toggleLabelBackground(labelId) {
                        var label = document.getElementById(labelId);
                        label.style.backgroundColor = label.style.backgroundColor === 'rgb(76, 175, 80)' ? '#808080' : '#4CAF50';
                    }
                </script>
            </div>
            <div style='width:100%;'>
                <input type="submit" style='background-color:#4CAF50;border-radius:1vw;width:100%;' class="inputs"
                    value="SEARCH" onclick="searchGraphs()" />
            </div>
            <script>
                function searchGraphs() {
                    var fromDate = document.getElementById('from_date').value;
                    var toDate = document.getElementById('to_date').value;
                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "graph_ajax.php", true);
                    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                    xhr.send("from_date=" + fromDate + "&to_date=" + toDate);

                    var loadingOverlay = document.createElement('div');
                    loadingOverlay.style.position = 'fixed';
                    loadingOverlay.style.top = '0';
                    loadingOverlay.style.left = '0';
                    loadingOverlay.style.width = '100%';
                    loadingOverlay.style.height = '100%';
                    loadingOverlay.style.background = 'rgba(0, 0, 0, 0.5)';
                    loadingOverlay.style.display = 'flex';
                    loadingOverlay.style.justifyContent = 'center';
                    loadingOverlay.style.alignItems = 'center';
                    loadingOverlay.innerHTML = '<div style="background-color: white; border-radius: 5px; padding: 5px 10px; font-size: 5vw; text-align: center;">Loading...</div>'
                    document.body.appendChild(loadingOverlay);

                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4 && xhr.status == 200) {
                            loadingOverlay.remove();

                            var oldCanvas = document.getElementById('graphChart');
                            if (oldCanvas) {
                                oldCanvas.remove();
                            }
                            var newCanvas = document.createElement('canvas');
                            newCanvas.id = 'graphChart';
                            document.querySelector('.graphs').appendChild(newCanvas);
                            ctx = newCanvas.getContext('2d');

                            var response = JSON.parse(xhr.responseText);
                            console.log(xhr.responseText);
                            var literes = response.literes;
                            var temp = response.temp;
                            var humidity = response.humidity;
                            var pressure = response.pressure;
                            var uv = response.uv;
                            var tempWeather = response.temp_weather;
                            var humidityWeather = response.humidity_weather;
                            var rain =response.rain;
                            var selectedGraphs = [];

                            if (document.getElementById('literesCheckbox').checked) {
                                selectedGraphs.push('literes');
                            }
                            if (document.getElementById('tempCheckbox').checked) {
                                selectedGraphs.push('temp');
                            }
                            if (document.getElementById('humidityCheckbox').checked) {
                                selectedGraphs.push('humidity');
                            }
                            if (document.getElementById('pressureCheckbox').checked) {
                                selectedGraphs.push('pressure');
                            }
                            if (document.getElementById('uvCheckbox').checked) {
                                selectedGraphs.push('uv');
                            }
                            if (document.getElementById('tempWeatherCheckbox').checked) {
                                selectedGraphs.push('temp_weather');
                            }
                            if (document.getElementById('humidityWeatherCheckbox').checked) {
                                selectedGraphs.push('humidity_weather');
                            }

                            if (document.getElementById('rainCheckbox').checked) {
                                selectedGraphs.push('rain');
                            }
                            var data = {
                                labels: [],
                                datasets: []
                            };

                            selectedGraphs.forEach((graph, index) => {
                                var color = `hsl(${index * 50}, 70%, 50%)`;
                                var date = [];
                                var dataGraph = [];
                                response[graph].forEach(entry => {
                                    date.push(entry[0]);
                                    dataGraph.push(entry[1]);
                                });
                                data.labels = date;
                                data.datasets.push({
                                    label: graph,
                                    data: dataGraph,
                                    backgroundColor: color,
                                    borderColor: color,
                                    borderWidth: 1
                                });
                            });
                            ctx = document.getElementById('graphChart').getContext('2d');
                            new Chart(ctx, {
                                type: 'line',
                                data: data,
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    },
                                    plugins: {
                                        zoom: {
                                            pan: {
                                                enabled: true,
                                                mode: 'x'
                                            },
                                            zoom: {
                                                wheel: {
                                                    enabled: true
                                                },
                                                pinch: {
                                                    enabled: true
                                                },
                                                mode: 'x'
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            </script>
        </div>
        <div class='graphs' style="width:100vw; height: 100vh; overflow-x:scroll;">
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <canvas id="graphChart" style="width: 10000px; height: 100vh;"></canvas>
        </div>
    </div>
    <div class="action" id="action">
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Create Action</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item" style="width: 100%;">
                    <input type="number" id="liters" placeholder="Liters"
                        style="width: 100%; height: 15vw; font-size: 3vw; padding: 1vw; margin: 1vw 0; border-radius: 2vw; border: 1px solid black;">

                    <input type="submit" id="liters_submit" onclick="liters_submit()" value="Submit"
                        style="width: 100%; height: 15vw; font-size: 3vw; background-color: #4CAF50; color: white; padding: 1vw; margin: 1vw 0; border: none; border-radius: 2vw; cursor: pointer; transition: all 0.2s ease-in-out;">
                    <!-- js and ajax -->
                </div>
            </div>

        </div>

        <div class='header_div'>
            <div class="mobile_friendly">
                <?php

                echo "<table style='width:100vw; border-collapse: collapse; font-size:3vw;'>";
                echo "<tr style='background-color: #f2f2f2;'>";
                echo "<th style='padding: 8px; border: 1px solid #ddd;'>Liters</th>";
                echo "<th style='padding: 8px; border: 1px solid #ddd;'>Date</th>";
                echo "</tr>";

                $last_20_operations_res = $db->exec_query('operations', ['*'], '', '', '', '', "1", "ORDER BY record_id DESC LIMIT 15");
                while ($data = $last_20_operations_res->fetch_assoc()) {
                    $liters = $data['liters'] * 2.2 / 1000;
                    $date = $data['date_time'];
                    echo "<tr>";
                    echo "<td style='padding: 8px; border: 1px solid #ddd;'>$liters</td>";
                    echo "<td style='padding: 8px; border: 1px solid #ddd;'>$date</td>";
                    echo "</tr>";
                }

                echo "</table>";


                ?>
            </div>

        </div>

    </div>
    <div class="footer">
        <div class="button" onclick="open_live()">
            LIVE
        </div>
        <div class="button" onclick="open_graph()">
            GRAPH
        </div>
        <div class="button" onclick="open_action()">
            ACTION
        </div>

    </div>
</body>

</html>

<script>
    function liters_submit() {
        var liters = document.getElementById("liters").value;

        var xhr = new XMLHttpRequest();
        xhr.open("POST", "liters.php", true);
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhr.send("liters=" + liters);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                document.getElementById("liters").value = '';
                console.log(xhr.responseText);
            }
        }
    }

    function open_live() {
        document.getElementById("live_data").style.display = "block";
        document.getElementById("graph_data").style.display = "none";
        document.getElementById("action").style.display = "none";
    }

    function open_graph() {
        document.getElementById("live_data").style.display = "none";
        document.getElementById("graph_data").style.display = "block";
        document.getElementById("action").style.display = "none";
    }

    function open_action() {
        document.getElementById("action").style.display = "block";
        document.getElementById("live_data").style.display = "none";
        document.getElementById("graph_data").style.display = "none";
    }

</script>