<?php
require("../../classes/autoload.php"); // Make sure FPDF is included

$quote_res = $db->query('quotes', "SELECT * FROM quotes WHERE record_id = '{$_GET['record_id']}'");
$quote = $quote_res->fetch_assoc();

$company_res = $db->query("company_info", "SELECT * FROM company_info WHERE record_id = 1");
$company = $company_res->fetch_assoc();


$client_details_res = $db->query("clients", "SELECT * FROM clients WHERE record_id = '{$quote['client_id']}'");
$client = $client_details_res->fetch_assoc();

$quote_list_res = $db->query("quote_list", "SELECT * FROM quote_list WHERE quote_id = '{$_GET['record_id']}'");
$index = 1;

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);

// Logos
$pdf->Image('../../assets/logo.png', 10, 15, 40);
$pdf->Image('../../assets/logo_2.png', 165, 10, 30);

// Title
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 20, 'QUOTE NO: ' . $quote['quote_number'], 0, 1, 'C');
$pdf->Ln(10);

// Client Details
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(110, 8, $client['name'], 0, 0);
$pdf->Cell(80, 8, $company['name'], 0, 1);
$pdf->SetFont('Arial', '', 9);

$pdf->Cell(110, 8, $client['email'], 0, 0);
$pdf->Cell(80, 8, "Reg: " . $company['reg'] . " | Vat NR: " . $company['vat'], 0, 1);

$pdf->Cell(110, 8, $client['contact_person'], 0, 0);
$pdf->Cell(80, 8, "TEL: " . $company['tel'], 0, 1);

$pdf->Cell(110, 8, $client['contact_number'], 0, 0);
$pdf->Cell(80, 8, "EMAIL: " . $company['email'], 0, 1);
$pdf->MultiCell(100, 8, $client['address']);
$pdf->Ln(6);
$pdf->SetXY(120, 72);
$pdf->MultiCell(70, 8, $company['address_line_1'] . " " . $company['address_line_2'] . " " . $company['address_line_3']);

// $pdf->Ln(5);


// Quote Info
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(26, 6, "DATE: ", 0, 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(50, 6, $quote['date_time_created'], 0, 1);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(26, 6, "ORDER TYPE: ", 0, 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(50, 6, $quote['order_type'], 0, 1);

if ($quote['additional_delivery_details'] != "") {
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(50, 6, "DELIVERY DETAILS", "B", 1);
    $pdf->SetFont('Arial', '', 10);
    $pdf->MultiCell(185, 6, $quote['additional_delivery_details'], 1, 1);
}

$pdf->SetFont('Arial', 'B', 10);
$pdf->MultiCell(185, 8, $quote['subject'], 1, 1);
$pdf->MultiCell(185, 5, "AREA: " . $quote['area'], 1, 1);

// Table Header
$pdf->SetFont('Arial', 'B', 8);
$pdf->SetFillColor(200, 200, 200);
$pdf->Cell(20, 7, 'Code', 1, 0, 'C', true);
$pdf->Cell(60, 7, 'Description', 1, 0, 'C', true);
$pdf->Cell(20, 7, 'U.O.M', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Qty', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Size', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Panels', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Amount', 1, 0, 'C', true);
$pdf->Cell(25, 7, 'Total', 1, 1, 'C', true);

// Table Body
$pdf->SetFont('Arial', '', 5.5);
$subtotal = 0;

function sa_str_to_float($str)
{
    // Remove R, spaces, and UTF-8 garbage like Â
    $str = str_replace(['R', ' ', 'Â'], '', $str);

    // If both , and . exist, assume , is thousand sep, . is decimal
    if (strpos($str, ',') !== false && strpos($str, '.') !== false) {
        $str = str_replace(',', '', $str);
    }
    // If only comma exists, assume it's decimal
    elseif (strpos($str, ',') !== false) {
        $str = str_replace(',', '.', $str);
    }

    return floatval($str);
}

foreach ($quote_list_res as $quote_list) {
    $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = '{$quote_list['stock_id']}'");
    $stock = $stock_res->fetch_assoc();

    // Clean price string
    $price = (float) preg_replace('/[^0-9\.-]/', '', str_replace(['R', '�', 'Â', ','], '', utf8_decode($quote_list['price'])));
    // allow for negative numbers
    if (substr($price, 0, 1) == '-') {
        $price = '-' . ltrim($price, '-');
    }
    $qty = (float) $quote_list['qty']; // make sure qty is float/int

    $total = $price * $qty;
    $subtotal += $total;

    $pdf->Cell(20, 7, $stock['code'], 1);
    $pdf->Cell(60, 7, $stock['name'], 1);
    $pdf->Cell(20, 7, $stock['unit_of_measure'], 1);
    $pdf->Cell(15, 7, $qty, 1, 0, 'C');
    $pdf->Cell(15, 7, $quote_list['size_m'], 1, 0, 'C');
    $pdf->Cell(15, 7, $quote_list['pannels'], 1, 0, 'C');
    $pdf->Cell(15, 7, 'R ' . number_format($price, 2), 1, 0, 'L'); // use cleaned float
    $pdf->Cell(25, 7, 'R ' . number_format($total, 2), 1, 1, 'L');
}
// Totals
$vat = $subtotal * 0.15;
$net_total = $subtotal + $vat;

$pdf->Cell(160, 7, 'Subtotal', 0, 0, 'R');
$pdf->Cell(25, 7, 'R ' . number_format($subtotal, 2), 1, 1, 'L');

$pdf->Cell(160, 7, 'VAT (15%)', 0, 0, 'R');
$pdf->Cell(25, 7, 'R ' . number_format($vat, 2), 1, 1, 'L');

$pdf->Cell(160, 7, 'Net Total', 0, 0, 'R');
$pdf->Cell(25, 7, 'R ' . number_format($net_total, 2), 1, 1, 'L');

// Notes & Terms
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(0, 6, 'NOTES:', 0, 1);
$pdf->SetFont('Arial', '', 7);
$pdf->MultiCell(180, 3, $quote['notes']);

$pdf->Ln(2);
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(0, 6, 'TERMS:', 0, 1);
$pdf->SetFont('Arial', '', 7);
$pdf->MultiCell(180, 3, $quote['terms']);

// Output PDF
$pdf->Output('I', 'quotation.pdf');
