<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

// $html->check_user_type("ADMIN");

// HTML FORM ELEMENTS
// FARMER SECTION FROM APPLICATION FORM

//get today's date and add 2 hours to the time
$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

$date_created = new input();
$date_created->type("hidden");
$date_created->name("date_created");
$date_created->id("date_created");
$date_created->placeholder("DATE CREATED");
$date_created->value($current_date);

$status = new input();
$status->type("hidden");
$status->name("status");
$status->id("status");
$status->placeholder("STATUS");
$status->value("PENDING");

$user_id = new input();
$user_id->type("hidden");
$user_id->name("user_id");
$user_id->id("user_id");
$user_id->value($_SESSION['user_id']);

$product_name_label = new label();
$product_name_label->for("product_name");
$product_name_label->value("PRODUCT NAME");

$product_name = new input();
$product_name->type("text");
$product_name->name("product_name");
$product_name->id("product_name");
$product_name->placeholder("PRODUCT NAME");

$cultivar_label = new label();
$cultivar_label->for("cultivar");
$cultivar_label->value("CULTIVAR");

$cultivar = new input();
$cultivar->type("text");
$cultivar->name("cultivar");
$cultivar->id("cultivar");
$cultivar->placeholder("CULTIVAR");

$supplier_name_label = new label();
$supplier_name_label->for("supplier_name");
$supplier_name_label->value("SUPPLIER NAME");

$supplier_name = new input();
$supplier_name->type("text");
$supplier_name->name("supplier_name");
$supplier_name->id("supplier_name");
$supplier_name->placeholder("SUPPLIER NAME");

$supplier_batch_id_label = new label();
$supplier_batch_id_label->for("supplier_batch_id_label");
$supplier_batch_id_label->value("SUPPLIER BATCH ID");

$supplier_batch_no = new input();
$supplier_batch_no->type("text");
$supplier_batch_no->name("supplier_batch_no");
$supplier_batch_no->id("supplier_batch_no");
$supplier_batch_no->placeholder("SUPPLIER BATCH ID");
$supplier_batch_no->readonly();

$contact_person = new input();
$contact_person->type("text");
$contact_person->name("contact_person");
$contact_person->id("contact_person");
$contact_person->placeholder("CONTACT PERSON");

$contact_person_label = new label();
$contact_person_label->for("contact_person");
$contact_person_label->value("CONTACT PERSON");

$contact_number = new input();
$contact_number->type("text");
$contact_number->name("contact_number");
$contact_number->id("contact_number");
$contact_number->placeholder("CONTACT NUMBER");
$contact_number->onchange("checkno();");

$contact_number_label = new label();
$contact_number_label->for("contact_number");
$contact_number_label->value("CONTACT NUMBER");

$certificate_delivery_email = new input();
$certificate_delivery_email->type("text");
$certificate_delivery_email->name("delivery_certificate_email");
$certificate_delivery_email->id("delivery_certificate_email");
$certificate_delivery_email->placeholder("EMAIL FOR CERTIFICATE DELIVERY");
$certificate_delivery_email->onchange("checkemail();");

$certificate_delivery_email_label = new label();
$certificate_delivery_email_label->for("delivery_certificate_email");
$certificate_delivery_email_label->value("EMAIL FOR CERTIFICATE DELIVERY");

$contact_number_for_delivery = new input();
$contact_number_for_delivery->type("text");
$contact_number_for_delivery->name("delivery_contact_number");
$contact_number_for_delivery->id("delivery_contact_number");
$contact_number_for_delivery->placeholder("CONTACT NUMBER FOR DELIVERY");
$contact_number_for_delivery->onchange("check_no();");

$contact_number_for_delivery_label = new label();
$contact_number_for_delivery_label->for("delivery_contact_number_label");
$contact_number_for_delivery_label->value("CONTACT NUMBER FOR DELIVERY");

$global_gap_no = new input();
$global_gap_no->type("text");
$global_gap_no->name("global_gap_no");
$global_gap_no->id("global_gap_no");
$global_gap_no->placeholder("GLOBAL G.A.P NUMBER");
$global_gap_no->onchange("checkgapno();");

$global_gap_no_label = new label();
$global_gap_no_label->for("global_gap_no_label");
$global_gap_no_label->value("GLOBAL G.A.P NUMBER");

$farm_name = new input();
$farm_name->type("text");
$farm_name->name("farm_name");
$farm_name->id("farm_name");
$farm_name->placeholder("FARM NAME");

$farm_name_label = new label();
$farm_name_label->for("farm_name");
$farm_name_label->value("FARM NAME");

$crop_year = new input();
$crop_year->type("text");
$crop_year->name("crop_year");
$crop_year->id("crop_year");
$crop_year->placeholder("CROP YEAR");

$crop_year_label = new label();
$crop_year_label->for("crop_year");
$crop_year_label->value("CROP YEAR");

$country_of_origin = new input();
$country_of_origin->type("text");
$country_of_origin->name("country_of_origin");
$country_of_origin->id("country_of_origin");
$country_of_origin->placeholder("COUNTRY OF ORIGIN");

$country_of_origin_label = new label();
$country_of_origin_label->for("country_of_origin");
$country_of_origin_label->value("COUNTRY OF ORIGIN");

$vehicle_registration_number = new input();
$vehicle_registration_number->type("text");
$vehicle_registration_number->name("vehicle_registration");
$vehicle_registration_number->id("vehicle_registration");
$vehicle_registration_number->placeholder("VEHICLE REGISTRATION NUMBER");

$vehicle_registration_number_label = new label();
$vehicle_registration_number_label->for("vehicle_registration");
$vehicle_registration_number_label->value("VEHICLE REGISTRATION NUMBER");

$loads_no = new input();
$loads_no->type("number");
$loads_no->name("loads_no");
$loads_no->id("loads_no");
$loads_no->min("1");
$loads_no->max("5");
$loads_no->placeholder("NUMBER OF LOADS");
$loads_no->onchange("loads_number()");

$loads_no_label = new label();
$loads_no_label->for("loads_no");
$loads_no_label->value("NUMBER OF LOADS");

$estimated_total_weight = new input();
$estimated_total_weight->type("hidden");
$estimated_total_weight->name("estimated_total_weight");
$estimated_total_weight->id("estimated_total_weight");
$estimated_total_weight->placeholder("ESTIMATE TOTAL WEIGHT/LOAD");

$estimate_total_weight_label = new label();
$estimate_total_weight_label->for("estimate_total_weight_label");
$estimate_total_weight_label->value("ESTIMATE TOTAL WEIGHT/LOAD");

$estimated_date_for_delivery_start = new input();
$estimated_date_for_delivery_start->type("datetime-local");
$estimated_date_for_delivery_start->name("estimated_delivery_date_start");
$estimated_date_for_delivery_start->id("estimated_delivery_date_start");

$estimated_date_for_delivery_start_label = new label();
$estimated_date_for_delivery_start_label->for("estimated_delivery_date_start_label");
$estimated_date_for_delivery_start_label->value("ESTIMATED DATE FOR DELIVERY FROM");

$estimated_date_for_delivery_end = new input();
$estimated_date_for_delivery_end->type("datetime-local");
$estimated_date_for_delivery_end->name("estimated_delivery_date_end");
$estimated_date_for_delivery_end->id("estimated_delivery_date_end");

$estimated_date_for_delivery_end_label = new label();
$estimated_date_for_delivery_end_label->for("estimated_delivery_date_end_label");
$estimated_date_for_delivery_end_label->value("ESTIMATED DATE FOR DELIVERY TO");

$submit_btn = new button();
$submit_btn->value("ADD");
$submit_btn->onclick("add_request();");

?>

<div class="form_down">
    <h1>FARMER / SUPPLIER SAMPLE REQUEST</h1>
    <?php
    $user_id->add();
    $date_created->add();
    $status->add();
    $product_name_label->add();
    $product_name->add();
    $cultivar_label->add();
    $cultivar->add();
    $supplier_name_label->add();
    $supplier_name->add();
    ?>
    <div style="display: flex; flex-direction: column;">

    </div>

    <div style="display: flex; flex-direction: row;">
        <div style="display: flex; flex-direction: column;">
            <?php
            $contact_person_label->add();
            $contact_person->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $contact_number_label->add();
            $contact_number->add();
            ?>
        </div>
    </div>
    <?php
    $certificate_delivery_email_label->add();
    $certificate_delivery_email->add();
    $contact_number_for_delivery_label->add();
    $contact_number_for_delivery->add();
    $global_gap_no_label->add();
    $global_gap_no->add();

    ?>
    <div style="display: flex; flex-direction: row;">
        <div style="display: flex; flex-direction: column;">
            <?php
            $farm_name_label->add();
            $farm_name->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $crop_year_label->add();
            $crop_year->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $country_of_origin_label->add();
            $country_of_origin->add();
            ?>
        </div>
    </div>
    <?php
    $vehicle_registration_number_label->add();
    $vehicle_registration_number->add();
    $loads_no_label->add();
    $loads_no->add();
    ?>

    <div id="number_of_loads"></div>

    <?php

    $estimated_total_weight->add();
    ?>

    <div style="display: flex; flex-direction: row;width: 80%;justify-content: space-around;">
        <div style="display: flex; flex-direction: column;">
            <?php
            $estimated_date_for_delivery_start_label->add();
            $estimated_date_for_delivery_start->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $estimated_date_for_delivery_end_label->add();
            $estimated_date_for_delivery_end->add();
            ?>
        </div>
    </div>

    <?php
    //create supplier batch no
    $supplier_batch_id_label->add();
    $supplier_batch_no->add();

    $submit_btn->add();
    ?>
</div>

<script>

    function checkno() {
        var number = document.getElementById("contact_number").value;

        //check if the number is valid and change the border color
        if (!/^\+?([0-9]{2})\)?[-. ]?([0-9]{4})[-. ]?([0-9]{4})$/.test(number)) {
            alert("Please enter a valid number");
            document.getElementById("contact_number").style.borderColor = "red";
            return false;
        } else {
            document.getElementById("contact_number").style.borderColor = "green";
            return true;
        }
    }

    function check_no() {
        var delivery_number = document.getElementById("delivery_contact_number").value;

        if (!/^\+?([0-9]{2})\)?[-. ]?([0-9]{4})[-. ]?([0-9]{4})$/.test(delivery_number)) {
            alert("Please enter a valid number");
            document.getElementById("delivery_contact_number").style.borderColor = "red";
            return false;
        } else {
            document.getElementById("delivery_contact_number").style.borderColor = "green";
            return true;
        }
    }

    function checkgapno() {
        var gap_no = document.getElementById("global_gap_no").value;
        // must be 13 digits
        if (gap_no.length != 13) {
            alert("Please enter a valid G.A.P number");
            document.getElementById("global_gap_no").style.borderColor = "red";
            return false;
        } else {
            document.getElementById("global_gap_no").style.borderColor = "green";
            return true;
        }
    }

    function checkemail() {
        var email = document.getElementById("delivery_certificate_email").value;

        //check if the email is valid and change the border color
        if (!/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email)) {
            alert("Please enter a valid email");
            document.getElementById("delivery_certificate_email").style.borderColor = "red";
            return false;
        } else {
            document.getElementById("delivery_certificate_email").style.borderColor = "green";
            return true;
        }
    }

    function loads_number() {
        var loads_no = parseInt(document.getElementById("loads_no").value);
        var loads = document.getElementById("number_of_loads");
        loads.innerHTML = "";

        var heading = document.createElement("h2");
        heading.innerHTML = "ESTIMATED LOAD WEIGHTS";
        loads.appendChild(heading);

        for (var i = 0; i < loads_no; i++) {
            var div = document.createElement("div");
            div.style.display = "flex";
            div.style.flexDirection = "column";
            div.style.alignItems = "center";

            var label = document.createElement("label");
            label.setAttribute("for", "load_weight_" + i);
            label.innerHTML = "ESTIMATED LOAD WEIGHT TOTAL " + (i + 1) + " (Kg)";

            var input = document.createElement("input");
            input.type = "number";
            input.className = "inputs";
            input.name = "load_weight_" + i;
            input.id = "load_weight_" + i;
            input.placeholder = "ESTIMATED LOAD WEIGHT TOTAL " + (i + 1);
            input.onchange = all_weights;

            div.appendChild(label);
            div.appendChild(input);
            loads.appendChild(div);
        }
    }

    function all_weights() {
        var loads_no = parseInt(document.getElementById("loads_no").value);
        var weightList = [];

        for (var i = 0; i < loads_no; i++) {
            var input = document.getElementsByName("load_weight_" + i)[0];
            if (input && input.value) {
                weightList.push(input.value);
            }
        }

        document.getElementById("estimated_total_weight").value = weightList.join(",");
    }
    
    function generateSupplierID() {
        let supplierName = document.getElementById("supplier_name").value.trim();
        let loads = document.getElementById("loads_no").value;

        // Get first 3 uppercase letters from supplier name (ignoring spaces)
        let prefix = supplierName.replace(/\s+/g, '').substring(0, 3).toUpperCase();

        // Get current date in ddmmyy format
        let today = new Date();
        let dd = String(today.getDate()).padStart(2, '0');
        let mm = String(today.getMonth() + 1).padStart(2, '0');
        let yy = String(today.getFullYear()).slice(-2);
        let datePart = dd + mm + yy;

        // Format loads with two digits
        let loadsPart = String(loads).padStart(2, '0');

        if (prefix.length === 3 && loads) {
            document.getElementById("supplier_batch_no").value = `${prefix}-${datePart}-${loadsPart}`;
        }
    }

    // Trigger generation when inputs change
    document.getElementById("supplier_name").addEventListener("input", generateSupplierID);
    document.getElementById("loads_no").addEventListener("input", generateSupplierID);

</script>

<?php

$ajax = new js_ajax();
$ajax->function_name("add_request");
$ajax->submit_btn_id("submit");
$ajax->insert("delivery_request");
$ajax->on_success("REQUEST SUBMITTED SUCCESSFULLY");
// $ajax->redirect("delivery_request.pdf.php?supplier_batch_no=$supplier_batch_id");

?>