<?php

include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$functions = new functions();
$db = new db_safeguard();
$where_data[] = "company_id = {$_SESSION['company_id']}";


if (strlen($_POST['date_from']) > 5 && strlen($_POST['date_to']) > 5) {
    $where_data[] = " date_time_opened BETWEEN '{$_POST['date_from']} 00:00' AND '{$_POST['date_to']} 23:59'";
}

if (isset($_POST['client_id']) && $_POST['client_id'] != "") {
    $where_data[] = " client_id = {$_POST['client_id']}";
}

if (isset($_POST['user_id']) && $_POST['user_id'] != "") {
    $where_data[] = " user_id = {$_POST['user_id']}";
}

if (isset($_POST['tank_id']) && $_POST['tank_id'] != "") {
    $where_data[] = " tank_id = {$_POST['tank_id']}";
}

if (isset($_POST['cash_type']) && $_POST['cash_type'] != "") {
    $where_data[] = " cash_type = {$_POST['cash_type']}";
}


$data = implode(" AND ", $where_data);

// echo $data;

$latest_orders_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE $data  ORDER BY date_time_closed DESC");
?>
<style>
    /* Wrap your table in a container */
    .table-responsive {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        /* smooth scrolling on iOS */
    }

    /* Basic styling for the table (same as before) */
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 14px;
        color: #333;
        background: #fff;
        box-shadow: 0 2px 8px rgb(0 0 0 / 0.1);
        border-radius: 8px;
        overflow: hidden;
        min-width: 700px;
        /* Ensure min width so horizontal scroll triggers */
    }

    table th {
        background: #1e90ff;
        color: white;
        text-align: left;
        padding: 12px 15px;
        font-weight: 600;
        letter-spacing: 0.03em;
        user-select: none;
    }

    table td {
        padding: 12px 15px;
        border-bottom: 1px solid #eaeaea;
    }

    table tr:nth-child(even) {
        background: #f9f9f9;
    }

    table tbody tr:hover {
        background-color: #d0e7ff;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }
</style>
<div class="header">
    <?php $data = str_replace("'", "\'", $data); ?>
    <input type="submit" class="submit_btn" value="PDF"
        onclick="window.open('diesel_orders.pdf.php?where_data=<?php echo $data; ?>','_blank')" />
    <input type="submit" class="submit_btn" value="EXCEL/CSV"
        onclick="window.open('vsv.report.php?where_data=<?php echo $data; ?>','_blank')" />
    <!-- <input type="submit" class="submit_btn" value="OPEN EXCEL"
        onclick="window.open('excel.report.php?where_data=<?php echo $data; ?>','_blank')" /> -->
</div>
<div class="table-responsive">
    <table>
        <tr>
            <th>
                TANK
            </th>
            <th>
                DATE
            </th>
            <th>
                CLIENT
            </th>
            <th>
                AMOUNT (mL)
            </th>
            <th>
                VALUE (R)
            </th>
            <th>
                R/L
            </th>
            <th>
                USER
            </th>
            <th>
                STATUS
            </th>
            <th>
                TYPE
            </th>


        </tr>

        <?php

        while ($latest_orders = $latest_orders_res->fetch_assoc()) {
            ?>

            <tr>
                <td>
                    <input style="  width: 160px;" type='text'  value='<?php echo $functions->get_tank_name($latest_orders['tank_id']); ?>' class="inputs">
                </td>
                <td>
                    <input style="  width: 160px;" type='text' value='<?php echo $latest_orders['date_time_closed']; ?>'
                        class="inputs"
                        onchange="change(this,'date_time_closed','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <select style="  width: 160px;" class="inputs"
                        onchange="change(this,'client_id','<?php echo $latest_orders['record_id']; ?>')">
                        <?php $clients_res = $db->query("clients", "SELECT * FROM clients WHERE company_id = {$_SESSION['company_id']}"); ?>
                        <option value="<?php echo $latest_orders['client_id']; ?>">
                            <?php echo $functions->get_client_name($latest_orders['client_id']); ?>
                        </option>
                        <?php while ($client = $clients_res->fetch_assoc()) { ?>
                            <option value="<?php echo $client['record_id']; ?>"><?php echo $client['client_name']; ?></option>
                        <?php } ?>
                    </select>
                </td>
                <td>
                    <input style="  width: 160px;" type='text'
                        value=' <?php echo number_format($latest_orders['amount'], 2); ?>' class="inputs"
                        onchange="change(this,'amount','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <input style="  width: 160px;" type='text'
                        value=' <?php echo number_format(($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'], 2); ?>'
                        class="inputs">
                </td>
                <td>
                    <input style="  width: 160px;" type='text'
                        value=' <?php echo number_format($latest_orders['fuel_price'], 2); ?>' class="inputs"
                        onchange="change(this,'fuel_price','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <select style="  width: 160px;" class="inputs"
                        onchange="change(this,'user_id','<?php echo $latest_orders['record_id']; ?>')">
                        <?php $users_res = $db->query("users", "SELECT * FROM users WHERE company_id = {$_SESSION['company_id']} AND `status` = 1"); ?>
                        <option value="<?php echo $latest_orders['user_id']; ?>">
                            <?php echo $functions->get_username($latest_orders['user_id']); ?>
                        </option>
                        <?php while ($user = $users_res->fetch_assoc()) { ?>
                            <option value="<?php echo $user['record_id']; ?>"><?php echo $user['username']; ?></option>
                        <?php } ?>
                    </select>
                </td>
                <td>
                    <input style="  width: 160px;" type='text' value='<?php echo $latest_orders['status']; ?>'
                        onchange="change(this,'status','<?php echo $latest_orders['record_id']; ?>')" class="inputs">
                </td>
                <td>
                    <select style="  width: 160px;" class="inputs"
                        onchange="change(this,'cash_type','<?php echo $latest_orders['record_id']; ?>')">
                        <?php if ($latest_orders['cash_type'] == 0) {
                            $type = "N/A";
                            ?>
                            <option value="<?php echo $latest_orders['type']; ?>"><?php echo $type; ?></option>
                            <option value="1">CASH</option>
                            <option value="3">EFT</option>
                            <option value="2">CARD</option>

                            <?php

                        } else if ($latest_orders['cash_type'] == 1) {
                            $type = "CASH";
                            ?>
                                <option value="<?php echo $latest_orders['type']; ?>"><?php echo $type; ?></option>
                                <option value="3">EFT</option>
                                <option value="2">CARD</option>
                                <option value="0">N/A</option>

                            <?php
                        } else if ($latest_orders['cash_type'] == 2) {
                            $type = "CARD";
                            ?>
                                    <option value="<?php echo $latest_orders['type']; ?>"><?php echo $type; ?></option>
                                    <option value="3">EFT</option>
                                    <option value="1">CASH</option>
                                    <option value="0">N/A</option>

                            <?php
                        } else {
                            $type = "EFT";
                            ?>
                                    <option value="<?php echo $latest_orders['type']; ?>"><?php echo $type; ?></option>
                                    <option value="2">CARD</option>
                                    <option value="1">CASH</option>
                                    <option value="0">N/A</option>

                            <?php
                        } ?>
                    </select>
                </td>

            </tr>
            <?php
        }
        ?>

    </table>
</div>

<script>
    function change(input, column_name, record_id) {
        if (confirm("Are you sure you want to change this detail?")) {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    var orig_color = input.style.backgroundColor;
                    if (this.responseText == "1") {
                        input.style.transition = "background-color 1.5s ease";
                        input.style.backgroundColor = "green";
                        setTimeout(function () {
                            input.style.backgroundColor = orig_color;
                        }, 1500);

                    } else {
                        input.style.transition = "background-color 1.5s ease";
                        input.style.backgroundColor = "red";
                        setTimeout(function () {
                            input.style.backgroundColor = orig_color;
                        }, 1500);
                        alert(this.responseText);
                    }
                }
            };
            xmlhttp.open("POST", "change_details.ajax.php", true);
            xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xmlhttp.send("value=" + input.value + "&column_name=" + column_name + "&record_id=" + record_id);
        }
    }
</script>