<?php

include "../root.class.php";
$functions = new functions();
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

function get_day_of_the_week($date)
{
    $date = date('w', strtotime($date));
    switch ($date) {
        case 0:
            return 'Sunday';
        case 1:
            return 'Monday';
        case 2:
            return 'Tuesday';
        case 3:
            return 'Wednesday';
        case 4:
            return 'Thursday';
        case 5:
            return 'Friday';
        case 6:
            return 'Saturday';
    }
}

echo DashboardWidget::includeAssets();

$fuel_movement_res_table = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' )AND company_id = {$_SESSION['company_id']} AND amount > 100 ORDER BY record_id DESC LIMIT 10");
$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {
    $table_data[] = [
        $functions->get_tank_name($fuel_movement['tank_id']),
        $functions->get_client_name($fuel_movement['client_id']),
        number_format(($fuel_movement['amount'] / 1000), 3),
        $fuel_movement['date_time_closed'],
        //$functions->get_username($fuel_movement['user_id']),
        'diesel/slip.pdf.php?record_id=' . $fuel_movement['record_id']
    ];
}

echo "<div class='row' style='column-gap: 0px'>";
echo DashboardWidget::textBlock('TODAY', number_format($functions->total_liters_for_today(), 2) . " L", '1.5em', '22vw', '22vw');
echo DashboardWidget::textBlock('DEPOT COMBINED', number_format($functions->total_liters_for_tank(9) + $functions->total_liters_for_tank(10) + $functions->total_liters_for_tank(13), 2) . " L", '1.5em', '22vw', '22vw');
echo DashboardWidget::textBlock('BAKKIE', number_format($functions->total_liters_for_tank(7), 2) . " L", '1.5em', '22vw', '22vw');
echo "</div>";


$tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE company_id = {$_SESSION['company_id']} ORDER BY record_id DESC");
echo "<div class='row' >";


while ($tank = $tank_res->fetch_assoc()) {

    $tank_level_res = $db->query("tank_level_log", "SELECT * FROM tank_level_log WHERE tank_id = {$tank['record_id']} ORDER BY record_id DESC LIMIT 1");
    $tank_level = $tank_level_res->fetch_assoc();


    // echo DashboardWidget::circleGraph("{$tank['name']} Level", 0, 100, $data['percentage_filled']);
    if ($tank['record_id'] == 12) {

        $data = $functions->calculate_vertical_cylinder_volume($tank['radius_mm'], ($tank['length_mm']) - $tank_level['distance'], $tank['length_mm']);

        echo DashboardWidget::circleGraph("{$tank['name']} New ", 0, round(($data['total_volume_liters'] * 5) / 1000000000, 0), round(($data['fluid_volume_liters'] * 5) / 1000000000, 0));

        // $data = $functions->calculate_vertical_cylinder_volume($tank['radius_mm'] + 53.80, ($tank['radius_mm'] * 2) - $tank_level['distance'] - 40, $tank['length_mm']);
// 
        //    echo DashboardWidget::circleGraph("{$tank['name']} Old ", 0, round(($data['total_volume_liters'] * 5) / 1000000000, 0), round(($data['fluid_volume_liters'] * 5) / 1000000000, 0));


    } else if ($tank['record_id'] == 9) {

    } else if ($tank['record_id'] == 13) {

    } else if ($tank['record_id'] == 10) {
        $data = $functions->calculate_horizontal_cylinder_volume($tank['radius_mm'], ($tank['radius_mm'] * 2) - $tank_level['distance'], $tank['length_mm']);
        echo DashboardWidget::circleGraph("{$tank['name']} Level.", 0, $data['total_volume_liters'], $data['fluid_volume_liters']);
    } else {
        $data = $functions->calculate_horizontal_cylinder_volume($tank['radius_mm'], ($tank['radius_mm'] * 2) - $tank_level['distance'], $tank['length_mm']);
        echo DashboardWidget::circleGraph("{$tank['name']} Level.", 0, $data['total_volume_liters'], $data['fluid_volume_liters']);
    }


}
echo "</div>";

echo DashboardWidget::tableBlock('Latest Activity All Pumps', ['TANK', 'TAG', 'AMOUNT', "DATE"], $table_data, '90vw');

$data_array = [];
$date = date('Y-m-d') . ' 00:00';
$date2 = date('Y-m-d') . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

echo DashboardWidget::columnGraph('All Pumps For 7 Days', $data_array, '90vw');



$lastSixMonths = [];
for ($i = 0; $i <= 5; $i++) {
    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

}
$amounts_arr = [];
foreach ($lastSixMonths as $key => $month) {
    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31'");
    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
}

echo DashboardWidget::columnGraph("All Pumps Monthly", $amounts_arr, '90vw');

?>
<div style="width: 100%;height: 0px; border: 4px solid #000"></div>
<h1><?php echo "DEPOT COMBINED" ; ?></h1>
<div style="width: 100%;height: 0px; border: 4px solid #000"></div>
<?php
$data_array = [];
$date = date('Y-m-d') . ' 00:00';
$date2 = date('Y-m-d') . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)   AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9)  AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

echo DashboardWidget::columnGraph('Depot For 7 Days', $data_array, '90vw');


$lastSixMonths = [];
for ($i = 0; $i <= 5; $i++) {
    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

}
$amounts_arr = [];
foreach ($lastSixMonths as $key => $month) {
    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE company_id = {$_SESSION['company_id']} AND company_id = {$_SESSION['company_id']} AND (tank_id = 10 OR tank_id = 13 OR tank_id = 9) AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31'");
    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
}

echo DashboardWidget::columnGraph("Depot Monthly", $amounts_arr, '90vw');

$sites_res = $db->query("sites", "SELECT * FROM sites WHERE company_id = {$_SESSION['company_id']}");
while ($site = $sites_res->fetch_assoc()) {
    ?>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <h1><?php echo $site['name']; ?></h1>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <?php
    $tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE site_id = {$site['record_id']} ORDER BY record_id DESC");

    while ($tank = $tank_res->fetch_assoc()) {
        $tank_id = $tank['record_id'];

        if ($tank_id == 12) {
            continue;
        }
        ?>
        <div class="column" style="width: 100%">
            <div style="display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: space-evenly;
        align-items: center;">

                <h2><u><?php //echo $tank['name']; ?></u></h2>

                <?php
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) ORDER BY record_id DESC LIMIT 10");

                $data_array = [];

                while ($fuel_movement = $fuel_movement_array_res->fetch_assoc()) {
                    $data_array[] = [$fuel_movement['amount'], $fuel_movement['date_time_closed']];
                }

                echo DashboardWidget::columnGraph("Latest Readings  {$tank['name']}", $data_array, '90vw');

                $data_array = [];
                $date = date('Y-m-d') . ' 00:00';
                $date2 = date('Y-m-d') . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id = $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                echo DashboardWidget::columnGraph("{$tank['name']} for 7 days", $data_array, '90vw');

                $lastSixMonths = [];
                for ($i = 0; $i <= 5; $i++) {
                    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

                }
                $amounts_arr = [];
                foreach ($lastSixMonths as $key => $month) {
                    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31'");
                    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
                }

                // echo DashboardWidget::lineGraph(
                //     'PRODUCTION OVER TIME',
                //     $lastSixMonths,
                //     $amounts_arr,
                //     'Liters'
                // );
        
                echo DashboardWidget::columnGraph("{$tank['name']} monthly", $amounts_arr, '90vw');




                ?>
            </div>


            <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
            <?php
    }


}
?>