<?php include "../../root.class.php";
$html = new html();
$db = new db_safeguard();
$html->add_styles_page();

$date_time = date("Y-m-d H:i", strtotime("+2 Hours"));

if (isset($_GET['record_id'])) {
    $lop_res = $db->query("lop_jobcard", "SELECT * FROM lop_jobcard WHERE record_id = '" . $_GET['record_id'] . "' ");
    $lop = $lop_res->fetch_assoc();
    $lop_record_id = $lop['record_id'];

    $batch_no_res = $db->query("batch_data", "SELECT * FROM batch_data WHERE record_id = $lop_record_id");
    $batch_no = $batch_no_res->fetch_assoc();
} else {

    $lop_res = $db->query("lop_jobcard", "SELECT jobcard_no FROM lop_jobcard ORDER BY record_id DESC LIMIT 1");
    if ($lop_res->num_rows == 0) {
        $jobcard_no = 1;
    } else {
        $lop = $lop_res->fetch_assoc();
        $jobcard_no = $lop['jobcard_no'] + 1;
    }
    $lop_record_id = $db->query("lop_jobcard", "INSERT INTO lop_jobcard (jobcard_no) VALUES ('" . $jobcard_no . "')");
    echo "<script>window.location.href = 'lop_jobcard.php?record_id=" . $lop_record_id . "'</script>";
}


$lop_id = new input();
$lop_id->type("hidden");
$lop_id->name("lop_id");
$lop_id->id("lop_id");
$lop_id->placeholder("LOP JC NO");
$lop_id->value($lop_record_id);

$record_id = new input();
$record_id->type("hidden");
$record_id->name("record_id");
$record_id->id("record_id");
$record_id->placeholder("");
$record_id->value($lop_record_id);


$product_id_label = new label();
$product_id_label->for("product_id_label");
$product_id_label->value("Product Identification");

$product_id = new input();
$product_id->type("text");
$product_id->name("product_id");
$product_id->id("product_id");
$product_id->placeholder("Product ID");
$product_id->style("width: 20%");
$product_id->value($lop['product_no']);

$jobcard_date_opened_label = new label();
$jobcard_date_opened_label->for("date_opened_label");
$jobcard_date_opened_label->value("Date Jobcard Opened");

$jobcard_date_opened = new input();
$jobcard_date_opened->type("datetime-local");
$jobcard_date_opened->name("jobcard_date_opened");
$jobcard_date_opened->id("jobcard_date_opened");
$jobcard_date_opened->value($lop['date_jobcard_opened']);

$checked_by_production_label = new label();
$checked_by_production_label->for("checked_by_label");
$checked_by_production_label->value("Checked By (Production)");

$checked_by_production = new input();
$checked_by_production->type("text");
$checked_by_production->name("production_checked_by");
$checked_by_production->id("production_checked_by");
$checked_by_production->placeholder("Checked By (Production)");
$checked_by_production->style("width: 40%");
$checked_by_production->value($lop['checked_by_production']);

$checked_by_quality_control_label = new label();
$checked_by_quality_control_label->for("checked_by_label");
$checked_by_quality_control_label->value("Checked By (Quality Control)");

$user_id = $_SESSION['user_id'];

$username_res = $db->query("users", "SELECT username FROM users WHERE record_id = $user_id");
$username = $username_res->fetch_assoc();

$checked_by_quality_control = new input();
$checked_by_quality_control->type("text");
$checked_by_quality_control->name("quality_control_checked_by");
$checked_by_quality_control->id("quality_control_checked_by");
$checked_by_quality_control->placeholder("Checked By (Quality Control)");
$checked_by_quality_control->value($lop['checked_by_quality_control']);
$checked_by_quality_control->style("width: 40%");

$room_number_label = new label();
$room_number_label->for("room_number_label");
$room_number_label->value("Room Number");

$room_number = new input();
$room_number->type("text");
$room_number->name("room_number");
$room_number->id("room_number");
$room_number->placeholder("Room Number");
$room_number->value($lop['room_no']);
// $room_number->style("width: 20%");

$trolley_mass_label = new label();
$trolley_mass_label->for("trolley_mass_label");
$trolley_mass_label->value("Mass placed on trolley (Kg)");

$trolley_no_label = new label();
$trolley_no_label->for("trolley_no_label");
$trolley_no_label->value("Number of Trolleys");

$trolley_no = new input();
$trolley_no->type("number");
$trolley_no->name("trolley_no");
$trolley_no->id("trolley_no");
$trolley_no->placeholder("Trolley Number");
$trolley_no->value($lop['number_of_trolleys'] + 0);// $trolley_no->style("width: 20%");

$batch_no_label = new label();
$batch_no_label->for("batch_no_label");
$batch_no_label->value("Batch No");

$batch_no = new select();
$batch_no->name("batch_no");
$batch_no->id("batch_no");
$batch_no->style("width: 20%");
$batch_no->fill_from_db("batch_data", "batch_no", "batch_no");
$batch_no->value_from_db("batch_data", "batch_no", "record_id = $lop_record_id");

// EQUIPMENT SECTION

$equipment_label = new label();
$equipment_label->for("equipment_label");
$equipment_label->value("Equipment");

$equipment_settings_label = new label();
$equipment_settings_label->for("equipment_settings_label");
$equipment_settings_label->value("Equipment Settings & specifications");

$accurate_label = new label();
$accurate_label->for("accurate_label");
$accurate_label->value("Accurate (YES/NO)");

$temperature_settings = new input();
$temperature_settings->type("text");
$temperature_settings->name("temperature_settings");
$temperature_settings->id("temperature_settings");
$temperature_settings->placeholder("C");
$temperature_settings->style("width: 90%");

$temperature_accurate = new select();
$temperature_accurate->name("temperature_accurate");
$temperature_accurate->id("temperature_accurate");
$temperature_accurate->add_option("", "SELECT ACCURATE");
$temperature_accurate->add_option("YES", "YES");
$temperature_accurate->add_option("NO", "NO");
$temperature_accurate->style("width: 90%");

$humidity_settings = new input();
$humidity_settings->type("text");
$humidity_settings->name("humidity_settings");
$humidity_settings->id("humidity_settings");
$humidity_settings->placeholder("List of settings to be verified before start-up");
$humidity_settings->style("width: 90%");

$humidity_accurate = new select();
$humidity_accurate->name("humidity_accurate");
$humidity_accurate->id("humidity_accurate");
$humidity_accurate->add_option("", "SELECT ACCURATE");
$humidity_accurate->add_option("YES", "YES");
$humidity_accurate->add_option("NO", "NO");
$humidity_accurate->style("width: 90%");

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->id("submit_btn");

?>

<form id="lop_jobcard" action="save_lop.php" method="post">
    <div class="form_down">
        <h1>LOP ROOMS JOBCARD</h1>

        <?php
        $record_id->add();
        $jobcard_date_opened_label->add();
        $jobcard_date_opened->add();

        $product_id_label->add();
        $product_id->add();

        $checked_by_quality_control_label->add();
        $checked_by_quality_control->add();

        $checked_by_production_label->add();
        $checked_by_production->add();

        $trolley_mass_label->add();


        ?>

        <input type="number" class="inputs" step="0.01" name="trolley_mass" id="trolley_mass"
            placeholder="Trolley Mass (kg)" style="width: 20%;" value="<?php echo $lop['mass_on_trolley'] + 0; ?>">

        <div style="display: flex; flex-direction: row; width: 70%;">
            <div style="display: flex; flex-direction: column; width: 100%;">
                <?php
                $room_number_label->add();
                $room_number->add();
                ?>
            </div>
            <div style="display: flex; flex-direction: column; width: 100%;">
                <?php
                $trolley_no_label->add();
                $trolley_no->add();
                ?>
            </div>
        </div>

        <?php
        $batch_no_label->add();
        $batch_no->add();
        ?>
        <div style="display: flex; justify-content: center;">
            <button type="button" onclick="halfway_save()" class="submit_btn" style="width: 100%;">SAVE</button>
        </div>

        <style>
            .guidance_popup {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
            }

            .guidance_content {
                /* background-color: #004aad */
                background-color: #528edf;
                margin: 3% auto;
                padding: 20px;
                border-radius: 10px;
                width: 80%;
                height: 85%;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
                position: relative;
                /* overflow-y: scroll; */
            }

            .quality_process_popup {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
            }

            .equipment_popup {
                display: none;
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
            }

            .quality_process_content {
                /* background-color: #004aad */
                background-color: #528edf;
                margin: 2% auto;
                padding: 20px;
                border-radius: 10px;
                width: 90%;
                height: 90%;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
                position: relative;
                overflow-y: scroll;
            }

            .equipment_content {
                /* background-color: #004aad */
                background-color: #528edf;
                margin: 2% auto;
                padding: 20px;
                border-radius: 10px;
                width: 90%;
                height: 90%;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
                position: relative;
                overflow-y: scroll;
            }

            .equipment_close_btn {
                position: absolute;
                top: 10px;
                right: 15px;
                font-weight: bolder;
                font-size: 5vw;
                cursor: pointer;
                color: white;
            }

            .close-btn {
                position: absolute;
                top: 10px;
                right: 15px;
                font-weight: bolder;
                font-size: 5vw;
                cursor: pointer;
                color: white;
            }

            table {
                width: 95%;
                border-collapse: collapse;
            }

            th,
            td {
                padding: 10px;
                border: 3px solid black;
                text-align: left;
                background-color: white;
            }
        </style>

        <br><br>

        <h1>EQUIPMENT CHECK HISTORY</h1>
        <div style="width: 90%; display: flex; justify-content: center;">
            <div class="quality_process_content">
                <?php
                $batch_no_res = $db->query("batch_data", "SELECT * FROM batch_data WHERE record_id = $lop_record_id ORDER BY batch_no DESC LIMIT 1");
                $batch_data = $batch_no_res->fetch_assoc();

                $equipment_res = $db->query("lop_equipment_check_list", "SELECT * FROM lop_equipment_check_list WHERE batch_no = '{$batch_data['batch_no']}' GROUP BY check_no");

                if ($equipment_res->num_rows > 0) {
                    ?>
                    <table>
                        <tr>
                            <th>USER</th>
                            <th>CHECK NO</th>
                            <th>DATE TIME</th>
                            <th></th>
                        </tr>
                        <?php
                        while ($equipment = $equipment_res->fetch_assoc()) {

                            $equipment_data_res = $db->query("equipment_list", "SELECT * FROM equipment_list WHERE record_id = '" . $equipment['equipment_id'] . "'");
                            $equipment_data = $equipment_data_res->fetch_assoc();

                            $user_res = $db->query("users", "SELECT * FROM users WHERE record_id = '" . $equipment['user_id'] . "'");
                            $user = $user_res->fetch_assoc();
                            ?>
                            <tr>
                                <td><?php echo $user['username']; ?></td>
                                <td><?php echo $equipment['check_no']; ?></td>
                                <td><?php echo $equipment['date_time']; ?></td>
                                <td>
                                    <button type="button" class="submit_btn"
                                        onclick="window.location.href='../reports/equipment.pdf.php?record_id=<?php echo $lop_record_id; ?>&check_no=<?php echo $equipment['check_no']; ?>'">
                                        PDF
                                    </button>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </table>
                    <?php
                }
                ?>
                <br>
            </div>
        </div>

        <input type="button" value="CHECK EQUIPMENT" class="submit_btn" onclick="open_equipment()">



        <div id="equipment_popup" class="equipment_popup">
            <div class="equipment_content">
                <span class="equipment_close_btn" onclick="close_equipment()">&times;</span>

                <h1>EQUIPMENT CHECKLIST</h1>
                <br>
                <div id="equipments_table"
                    style="display: flex; flex-direction: column; align-items: center; width: 100%;">
                    <?php

                    $lop_jobcard_res = $db->query("lop_jobcard", "SELECT * FROM lop_jobcard WHERE record_id = '" . $_GET['record_id'] . "' ");
                    $lop_jobcard = $lop_jobcard_res->fetch_assoc();

                    $equipment_res = $db->query("lop_equipment_check_list", "SELECT * FROM lop_equipment_check_list WHERE batch_no = '{$lop_jobcard['batch_no']}' ORDER BY check_no DESC LIMIT 1");

                    if ($equipment_res->num_rows < 0) {
                        $check_no = 1;
                        $batch_no = 1;
                    } else {
                        $batch_row = $equipment_res->fetch_assoc();
                        $check_no_db = is_numeric($batch_row['check_no']) ? (int) $batch_row['check_no'] : 0;

                        $check_no = $check_no_db + 1;
                        // echo $check_no;
                        $batch_no = $batch_row['batch_no'];
                        echo $batch_no;
                    }


                    $lop_res = $db->query("lop_jobcard", "SELECT jobcard_no FROM lop_jobcard ORDER BY record_id DESC LIMIT 1");
                    if ($lop_res->num_rows == 0) {
                        $jobcard_no = 1;
                    } else {
                        $lop = $lop_res->fetch_assoc();
                        $jobcard_no = $lop['jobcard_no'] + 1;
                    }
                    ?>

                    <input type="hidden" name="check_no" value="<?php echo $check_no; ?>">
                    <input type="hidden" name="cracking_id" value="<?php echo $lop_record_id; ?>">
                    <input type="hidden" name="batch_no" value="<?php echo $batch_no; ?>">
                    <table style="width: 100%;">
                        <table>
                            <tr>
                                <td>EQUIPMENT</td>
                                <td>QUESTION</td>
                                <td>ANSWER</td>
                                <td>COMMENT</td>
                            </tr>
                            <?php
                            $index = 0;
                            $equipment_res = $db->query("equipment_list", "SELECT * FROM equipment_list WHERE 1 ORDER BY record_id ASC");
                            while ($equipment = $equipment_res->fetch_assoc()) {
                                $show = 1;
                                ?>
                                <tr>
                                    <input type="text" hidden name="equipment_id[]"
                                        value="<?php echo $equipment["record_id"]; ?>">
                                    <input type="text" hidden name="text_clean_<?php echo $equipment["record_id"]; ?>[]"
                                        value="Equipment appears clean and free from damage">
                                    <td><?php echo $equipment["name"]; ?></td>
                                    <td>Equipment appears clean and free from damage</td>
                                    <td><select name="clean_<?php echo $equipment["record_id"]; ?>[]"
                                            id="clean_<?php echo $equipment["record_id"]; ?>[]"
                                            onchange="equipment_comment('clean_<?php echo $equipment['record_id']; ?>[]','clean_comment_<?php echo $equipment['record_id']; ?>[]');"
                                            class="inputs" style="margin:0;">
                                            <option></option>
                                            <option>YES</option>
                                            <option>NO</option>
                                            <option>N/A</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="clean_comment_<?php echo $equipment["record_id"]; ?>[]"
                                            id="clean_comment_<?php echo $equipment["record_id"]; ?>[]" class="inputs"
                                            style="margin: 0vw; width: 100%;">
                                    </td>
                                </tr>
                                <tr>
                                    <td> <input type="text" hidden
                                            name="text_excessive_<?php echo $equipment["record_id"]; ?>[]"
                                            value="No signs of excessive wear, rust, or corrosion"></td>
                                    <td>No signs of excessive wear, rust, or corrosion</td>
                                    <td><select name="excessive_<?php echo $equipment["record_id"]; ?>[]"
                                            id="excessive_<?php echo $equipment["record_id"]; ?>[]"
                                            onchange="equipment_comment('excessive_<?php echo $equipment['record_id']; ?>[]','excessive_comment_<?php echo $equipment['record_id']; ?>[]');"
                                            class="inputs" style="margin:0;">
                                            <option></option>
                                            <option>YES</option>
                                            <option>NO</option>
                                            <option>N/A</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="excessive_comment_<?php echo $equipment["record_id"]; ?>[]"
                                            id="excessive_comment_<?php echo $equipment["record_id"]; ?>[]" class="inputs"
                                            style="margin: 0vw; width: 100%;">
                                    </td>
                                </tr>
                                <tr>
                                    <td> <input type="text" hidden
                                            name="text_guardsk_<?php echo $equipment["record_id"]; ?>[]"
                                            value="All guards, covers, and shields are securely fitted"></td>
                                    <td>All guards, covers, and shields are securely fitted</td>
                                    <td><select name="guardsk_<?php echo $equipment["record_id"]; ?>[]"
                                            id="guardsk_<?php echo $equipment["record_id"]; ?>[]"
                                            onchange="equipment_comment('guardsk_<?php echo $equipment['record_id']; ?>[]','guardsk_comment_<?php echo $equipment['record_id']; ?>[]');"
                                            class="inputs" style="margin:0;">
                                            <option></option>
                                            <option>YES</option>
                                            <option>NO</option>
                                            <option>N/A</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="guardsk_comment_<?php echo $equipment["record_id"]; ?>[]"
                                            id="guardsk_comment_<?php echo $equipment["record_id"]; ?>[]" class="inputs"
                                            style="margin: 0vw; width: 100%;">
                                    </td>
                                </tr>
                                <tr>
                                    <td><input type="text" hidden
                                            name="text_Moving_<?php echo $equipment["record_id"]; ?>[]"
                                            value="Moving parts operate smoothly without obstruction"></td>
                                    <td>Moving parts operate smoothly without obstruction</td>
                                    <td><select name="Moving_<?php echo $equipment["record_id"]; ?>[]"
                                            id="Moving_<?php echo $equipment["record_id"]; ?>[]"
                                            onchange="equipment_comment('Moving_<?php echo $equipment['record_id']; ?>[]','Moving_comment_<?php echo $equipment['record_id']; ?>[]');"
                                            class="inputs" style="margin:0;">
                                            <option></option>
                                            <option>YES</option>
                                            <option>NO</option>
                                            <option>N/A</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="Moving_comment_<?php echo $equipment["record_id"]; ?>[]"
                                            id="Moving_comment_<?php echo $equipment["record_id"]; ?>[]" class="inputs"
                                            style="margin: 0vw; width: 100%;">
                                    </td>
                                </tr>
                                <tr>
                                    <td><input type="text" hidden name="text_Power_<?php echo $equipment["record_id"]; ?>[]"
                                            value="Power cables and plugs are intact and undamaged"></td>
                                    <td>Power cables and plugs are intact and undamaged</td>
                                    <td><select name="Power_<?php echo $equipment["record_id"]; ?>[]"
                                            id="Power_<?php echo $equipment["record_id"]; ?>[]"
                                            onchange="equipment_comment('Power_<?php echo $equipment['record_id']; ?>[]','Power_comment_<?php echo $equipment['record_id']; ?>[]');"
                                            class="inputs" style="margin:0;">
                                            <option></option>
                                            <option>YES</option>
                                            <option>NO</option>
                                            <option>N/A</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="Power_comment_<?php echo $equipment["record_id"]; ?>[]"
                                            id="Power_comment_<?php echo $equipment["record_id"]; ?>[]" class="inputs"
                                            style="margin: 0vw; width: 100%;">
                                    </td>
                                </tr>
                                <?php
                                $index++;
                            }
                            ?>
                        </table>
                        <br>

                        <input type="button" value="SAVE LIST" class="submit_btn" onclick="save_equipment_check()" <?php if ($show == 0)
                            echo "hidden"; ?>>
                        <script>
                            function save_equipment_check() {
                                var formData = new FormData();
                                document.querySelectorAll("#equipments_table input, #equipments_table select").forEach(function (input) {
                                    if (input.value == '') {
                                        input.style.border = "1px solid red";
                                        input.focus();
                                        return;
                                    } else {
                                        input.style.border = "1px solid green";

                                        formData.append(input.name, input.value);
                                    }
                                });
                                var xhr = new XMLHttpRequest();
                                xhr.open("POST", "equipment.ajax.php", true);
                                xhr.onload = function () {
                                    if (xhr.status === 200) {
                                        if (xhr.responseText == "1") {
                                            alert("Successfully saved equipment check.");
                                            location.reload();
                                        } else {
                                            alert("Failed to save equipment check." + xhr.responseText);
                                            console.log(xhr.responseText);

                                        }
                                    } else {
                                        console.log("Error: " + xhr.statusText);
                                    }
                                };
                                xhr.send(formData);
                            }
                        </script>
                </div>
            </div>
        </div>

        <br><br><br>

        <div id="Operation_procedure_table" style="width: 90%; display: flex; justify-content: center;">
            <table>
                <tr>
                    <th>Standard Operating procedure: </th>
                    <th> Sampling of nuts for evaluation</th>
                </tr>
                <tr>
                    <td>Step 1</td>
                    <td>Take a random sample of cracked nuts per batch daily on the different trolleys</td>
                </tr>
                <tr>
                    <td> Step 2</td>
                    <td>Measure the moisture %</td>
                </tr>
                <tr>
                    <td>Step 3</td>
                    <td>Record the moisture on the job card</td>
                </tr>
                <tr>
                    <td>Step 4</td>
                    <td>Report any deviations</td>
                </tr>
            </table>
        </div>

        <br><br>

        <div id="food_inspection_table" style="width: 95%; display: flex; justify-content: center;">
            <table>
                <?php
                // check 
                $check_res = $db->query("lop_food_safety_inspections", "SELECT * FROM lop_food_safety_inspections WHERE lop_jobcard_no = '$lop_record_id' ORDER BY record_id DESC LIMIT 1");
                if ($check_res->num_rows > 0) {
                    $check = $check_res->fetch_assoc();
                    $comment_res = $db->query("lop_food_comments", "SELECT * FROM lop_food_comments WHERE lop_jobcard_no = '$lop_record_id' ORDER BY record_id DESC LIMIT 1");
                    if ($comment_res->num_rows > 0) {
                        $comment = $comment_res->fetch_assoc();
                    } else {
                        $comment[] = "";
                    }
                } else {
                    $check[] = "";
                }
                ?>
                <tr>
                    <th colspan="3" style="text-align: center;">Food Safety Inspections</th>
                </tr>
                <tr>
                    <th>Food safety Inspection criteria/ points:</th>
                    <th>Select/ complete:</th>
                    <th>Comment:</th>
                </tr>
                <tr>
                    <td>Equipment Clean & sanitized</td>
                    <td>
                        <select name="equipment_cleaned" id="equipment_cleaned" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="equipmentCleaned()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td>
                        <input type="text" name="equipment_cleaned_comment" id="equipment_cleaned_comment"
                            class="inputs" style="margin: 0vw; width: 100%;">
                    </td>
                </tr>
                <script>
                    document.getElementById("equipment_cleaned").value = "<?php echo $check['equipment_cleaned']; ?>";
                    document.getElementById("equipment_cleaned_comment").value = "<?php echo $comment['equipment_cleaned_comment']; ?>";
                </script>
                <tr>
                    <td>LOP room clean?</td>
                    <td>
                        <select name="lop_room_cleaned" id="lop_room_cleaned" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="lopRoomCleaned()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="lop_room_comment" id="lop_room_comment" class="inputs"
                            style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("lop_room_cleaned").value = "<?php echo $check['lop_room_cleaned']; ?>";
                    document.getElementById("lop_room_comment").value = "<?php echo $comment['lop_room_comment']; ?>";
                </script>
                <tr>
                    <td>No pest acitivity noted?</td>
                    <td>
                        <select name="pest_activity_noted" id="pest_activity_noted" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="pestActivityNoted()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="pest_activity_comment" id="pest_activity_comment" class="inputs"
                            style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("pest_activity_noted").value = "<?php echo $check['pest_activity_noted']; ?>";
                    document.getElementById("pest_activity_comment").value = "<?php echo $comment['pest_activity_comment']; ?>";
                </script>
                <tr>
                    <td>No off smells or taints? </td>
                    <td>
                        <select name="smells_taints_signs" id="smells_taints_signs" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="smellsTaintsSigns()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="smells_taints_signs_comment" id="smells_taints_signs_comment"
                            class="inputs" style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("smells_taints_signs").value = "<?php echo $check['smells_taints_signs']; ?>";
                    document.getElementById("smells_taints_signs_comment").value = "<?php echo $comment['smells_taints_signs_comment']; ?>";
                </script>
                <tr>
                    <td>Air/ dust extraction system operational? </td>
                    <td>
                        <select name="air_dust_operational" id="air_dust_operational" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="airDustOperational()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="air_dust_operational_comment" id="air_dust_operational_comment"
                            class="inputs" style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("air_dust_operational").value = "<?php echo $check['air_dust_operational']; ?>";
                    document.getElementById("air_dust_operational_comment").value = "<?php echo $comment['air_dust_operational_comment']; ?>";
                </script>
                <tr>
                    <td>No visual contamination risks in room such as cobwebs, loose silicone, dust, water vapour,
                        visble mould etc.?</td>
                    <td>
                        <select name="visual_contamination_risks" id="visual_contamination_risks" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="visualContaminationRisks()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="visual_contamination_risks_comment"
                            id="visual_contamination_risks_comment" class="inputs" style="margin: 0vw; width: 100%;">
                    </td>
                </tr>
                <script>
                    document.getElementById("visual_contamination_risks").value = "<?php echo $check['visual_contamination_risks']; ?>";
                    document.getElementById("visual_contamination_risks_comment").value = "<?php echo $comment['visual_contamination_risks_comment']; ?>";
                </script>
                <tr>
                    <td>Cheese Crates clean & free from foreign objects?</td>
                    <td>
                        <select name="cheese_crates_clean" id="cheese_crates_clean" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="cheeseCratesClean()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="cheese_crates_clean_comment" id="cheese_crates_clean_comment"
                            class="inputs" style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("cheese_crates_clean").value = "<?php echo $check['cheese_crates_clean']; ?>";
                    document.getElementById("cheese_crates_clean_comment").value = "<?php echo $comment['cheese_crates_clean_comment']; ?>";
                </script>
                <tr>
                    <td>Is there traceability available for each trolley?</td>
                    <td>
                        <select name="trolley_traceability_available" id="trolley_traceability_available" class="inputs"
                            style="margin: 0vw; width: 100%;" onchange="trolleyTraceabilityAvailable()">
                            <option value=""></option>
                            <option value="YES">YES</option>
                            <option value="NO">NO</option>
                        </select>
                    </td>
                    <td><input type="text" name="trolley_traceability_available_comment"
                            id="trolley_traceability_available_comment" class="inputs"
                            style="margin: 0vw; width: 100%;"></td>
                </tr>
                <script>
                    document.getElementById("trolley_traceability_available").value = "<?php echo $check['trolley_traceability_available']; ?>";
                    document.getElementById("trolley_traceability_available_comment").value = "<?php echo $comment['trolley_traceability_available_comment']; ?>";
                </script>
            </table>
        </div>
        <div style="display: flex; justify-content: center;">
            <button type="button" onclick="halfway_save()" class="submit_btn" style="width: 100%;">SAVE</button>
        </div>
        <br><br>

        <h1>QUALITY CONTROL HISTORY</h1>
        <div style="width: 90%; display: flex; justify-content: center;">
            <div class="quality_process_content">
                <?php
                $quality_res = $db->query("lop_quality_process_control", "SELECT * FROM lop_quality_process_control WHERE lop_id = '" . $lop_record_id . "' ORDER BY record_id ASC");
                if ($quality_res->num_rows > 0) {
                    while ($quality = $quality_res->fetch_assoc()) {
                        ?>
                        <table style="width: 100%;">
                            <tr>
                                <th>0%</th>
                                <th>0%</th>
                                <th>
                                    < 1%</th>
                                <th>18 -24°C</th>
                                <th>45 - 55 RH</th>
                                <th></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th>Mouldy Kernel </th>
                                <th>Rancid/off-smell kernel</th>
                                <th>Kernel Moisture %</th>
                                <th>Env. Temperature</th>
                                <th>Env. Humidity</th>
                                <th>Discolouration</th>
                                <th>Person Inspecting</th>
                            </tr>
                            <tr>
                                <td><input type="number" name="mouldy_kernal" id="mouldy_kernal" step="0.01" class="inputs"
                                        style="margin: 0vw;width: 100%;"><?php echo $quality['mouldy_kernal']; ?></td>
                                <td><input type="number" name="rancid_kernal_smell" id="rancid_kernal_smell" step="0.01"
                                        class="inputs" style="margin: 0vw;width: 100%;"><?php echo $quality['rancid_kernal_smell']; ?></td>
                                <td><input type="number" name="kernal_moisture" id="kernal_moisture" step="0.01" class="inputs"
                                        style="margin: 0vw;width: 100%;"><?php echo $quality['kernal_moisture']; ?></td>
                                <td><input type="number" name="env_temperature" id="env_temperature" step="0.01" class="inputs"
                                        style="margin: 0vw;width: 100%;"><?php echo $quality['env_temperature']; ?></td>
                                <td><input type="number" name="env_humidity" id="env_humidity" step="0.01" class="inputs"
                                        style="margin: 0vw;width: 100%;"><?php echo $quality['env_humidity']; ?></td>
                                <td><input type="number" name="discolouration" id="discolouration" step="0.01" class="inputs"
                                        style="margin: 0vw;width: 100%;"> <?php echo $quality['discolouration']; ?></td>
                                <td>
                                    <?php
                                    $person_inspecting = new select();
                                    $person_inspecting->name("person_inspecting");
                                    $person_inspecting->id("person_inspecting");
                                    $person_inspecting->class("inputs");
                                    $person_inspecting->style("margin: 0vw;width: 100%;");
                                    $person_inspecting->fill_from_db("users", "record_id", "username");
                                    $person_inspecting->add();
                                    ?>
                                </td>
                            </tr>
                        </table>
                        <br>
                        <?php
                    }
                }
                ?>
            </div>
        </div>

        <div id="quality_process_control_table" class="quality_process_popup"
            style="width: 100%; justify-content: center; ">
            <div class="quality_process_content">
                <span class="close-btn" onclick="close_quality_control()">&times;</span>
                <?php
                $lop_id->add();
                ?>
                <h2>QUALITY & PROCESS CONTROL TRACK INFORMATION:</h2>
                <div style="width: 100%; display: flex; flex-direction: row; justify-content: space-evenly;">
                    <div style="display: flex; flex-direction: column;">
                        <?php
                        $datetime = new label();
                        $datetime->for("datetime_label");
                        $datetime->value("Date & time");
                        $datetime->add();
                        ?>
                        <br>
                        <input type="datetime-local" name="date_time" id="date_time" class="inputs" style="margin: 0vw;"
                            value="<?php echo $date_time; ?>">
                    </div>
                    <div style="display: flex; flex-direction: column;">
                        <?php
                        $shift_label = new label();
                        $shift_label->for("shift_label");
                        $shift_label->value("Shift (Day / Night)");
                        $shift_label->add();
                        ?>
                        <br>
                        <select name="shift" id="shift" class="inputs" style="margin: 0vw;">
                            <option value=""></option>
                            <option value="D">DAY</option>
                            <option value="N">NIGHT</option>
                        </select>
                    </div>
                    <div style="display: flex; flex-direction: column;">
                        <?php
                        $sample_size_label = new label();
                        $sample_size_label->for("sample_size_label");
                        $sample_size_label->value("Sample Size (Kg)");
                        $sample_size_label->add();
                        ?>
                        <br>
                        <input type="number" name="sample_size" id="sample_size" class="inputs" step="0.01"
                            style="margin: 0vw;">
                    </div>
                </div>

                <h2>SPECIFICATION / GUIDANCE ON ELEVATION</h2>

                <div style="display: flex; flex-direction: column; align-items: center; justify-content: center;">
                    <div style="display: flex; flex-direction: row;">
                        <div style="display: flex; flex-direction: column;">
                            <?php
                            $trolley_number_label = new label();
                            $trolley_number_label->for("trolley_number_label");
                            $trolley_number_label->value("Trolley Number");
                            $trolley_number_label->add();

                            ?>
                            <input type="number" name="trolley_number" id="trolley_number" class="inputs">
                        </div>
                        <div style="display: flex; flex-direction: column;">
                            <?php
                            $trolley_position_label = new label();
                            $trolley_position_label->for("trolley_position_label");
                            $trolley_position_label->value("Trolley Position");
                            $trolley_position_label->add();
                            ?>
                            <input type="text" name="trolley_position" id="trolley_position" class="inputs">
                        </div>
                    </div>
                    <br>
                </div>

                <br><br>

                <table style="width: 100%;">
                    <tr>
                        <th>0%</th>
                        <th>0%</th>
                        <th>
                            < 1%</th>
                        <th>18 -24°C</th>
                        <th>45 - 55 RH</th>
                        <th></th>
                        <th></th>
                    </tr>
                    <tr>
                        <th>Mouldy Kernel </th>
                        <th>Rancid/off-smell kernel</th>
                        <th>Kernel Moisture %</th>
                        <th>Env. Temperature</th>
                        <th>Env. Humidity</th>
                        <th>Discolouration</th>
                        <th>Person Inspecting</th>
                    </tr>
                    <tr>
                        <td><input type="number" name="mouldy_kernal" id="mouldy_kernal" step="0.01" class="inputs"
                                style="margin: 0vw;width: 100%;"></td>
                        <td><input type="number" name="rancid_kernal_smell" id="rancid_kernal_smell" step="0.01"
                                class="inputs" style="margin: 0vw;width: 100%;"></td>
                        <td><input type="number" name="kernal_moisture" id="kernal_moisture" step="0.01" class="inputs"
                                style="margin: 0vw;width: 100%;"></td>
                        <td><input type="number" name="env_temperature" id="env_temperature" step="0.01" class="inputs"
                                style="margin: 0vw;width: 100%;"></td>
                        <td><input type="number" name="env_humidity" id="env_humidity" step="0.01" class="inputs"
                                style="margin: 0vw;width: 100%;"></td>
                        <td><input type="number" name="discolouration" id="discolouration" step="0.01" class="inputs"
                                style="margin: 0vw;width: 100%;"></td>
                        <td>
                            <?php
                            $person_inspecting = new select();
                            $person_inspecting->name("person_inspecting");
                            $person_inspecting->id("person_inspecting");
                            $person_inspecting->class("inputs");
                            $person_inspecting->style("margin: 0vw;width: 100%;");
                            $person_inspecting->fill_from_db("users", "record_id", "username");
                            $person_inspecting->add();
                            ?>
                        </td>
                    </tr>
                </table>
                <br><br>
                <div style="display: flex; flex-direction: row; width: 100%; justify-content: center;">
                    <!-- <button type="button" id="save_btn" class="submit_btn">SIGN</button> -->
                    <button type="button" id="clear_signature" onclick="signaturePad.clear();"
                        class="submit_btn">CLEAR</button>
                </div>
                <h2>SIGNATURE</h2>
                <canvas id="qa_signature_pad" class="signature-pad" width=400 height=200
                    style='background-color:white;border-radius:20px;'></canvas><br>

                <script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>
                <script>
                    function dataURLToBlob(dataURL) {
                        var binary = atob(dataURL.split(',')[1]);
                        var array = [];
                        for (var i = 0; i < binary.length; i++) {
                            array.push(binary.charCodeAt(i));
                        }
                        return new Blob([new Uint8Array(array)], {
                            type: dataURL.split(',')[0].split(':')[1].split(';')[0]
                        });
                    }
                </script>
                <button type="button" onclick="submit_quality_control()" class="submit_btn">SAVE</button>
                <br>
                <button type="button" onclick="close_quality_control()" class="submit_btn">CLOSE</button>
            </div>
            <script>
                signaturePad = new SignaturePad(document.getElementById('qa_signature_pad'));

                function submit_quality_control() {
                    event.preventDefault();
                    // Use the existing signaturePad instance (do not reinitialize)
                    var canvas = document.getElementById('qa_signature_pad');

                    var formData = new FormData();
                    var inputs = document.querySelectorAll("#quality_process_control_table input, #quality_process_control_table select");

                    inputs.forEach(function (input) {
                        formData.append(input.name, input.value);
                    });

                    if (signaturePad.isEmpty()) {
                        alert("Please provide signature first.");
                        return;
                    }

                    var dataURL = signaturePad.toDataURL('image/png');
                    var blob = dataURLToBlob(dataURL);
                    formData.append('signature', blob, 'signature.png');
                    formData.append('type', 'quality_control');

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "add_quality_control.php", true);
                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            if (xhr.responseText.trim() === "1") {
                                alert("Successfully saved quality control.");
                                window.location.reload();
                            } else {
                                alert("Failed to save quality control.");
                                console.log(xhr.responseText);
                            }
                        } else {
                            alert("Server error: " + xhr.status);
                        }
                    };
                    xhr.send(formData);
                }
            </script>
        </div>

        <input type="button" value="QUALITY CONTROL" class="submit_btn" onclick="open_quality_control()">

        <div style="display: flex; flex-direction: column;">
            <?php
            $date_jobcard_closed_label = new label();
            $date_jobcard_closed_label->for("date_jobcard_closed");
            $date_jobcard_closed_label->value("Date Jobcard Closed");
            $date_jobcard_closed_label->add();

            $date_jobcard_closed = new input();
            $date_jobcard_closed->type("datetime-local");
            $date_jobcard_closed->id("jobcard_closed");
            $date_jobcard_closed->name("jobcard_closed");
            $date_jobcard_closed->value($lop['jobcard_date_closed']);
            $date_jobcard_closed->add();
            ?>
        </div>

        <div style="display: flex; flex-direction: row; justify-content: space-around; width: 90%;">
            <!-- Production Supervisor -->
            <div style="display: flex; flex-direction: column; align-items: center;">
                <label for="product_supervisor">Product Supervisor</label>
                <input type="text" id="product_supervisor" name="product_supervisor" class="inputs"
                    placeholder="Product Supervisor" style="width: 30vw;"
                    value="<?php echo $lop['product_supervisor']; ?>">
                <?php if ($lop['supervisor_signature'] != null) { ?>
                    <img src="<?php echo $lop['supervisor_signature']; ?>" width="400" height="200">
                <?php } else { ?>
                    <canvas id="ps_signature_pad" class="signature-pad" width="400" height="200"
                        style="background-color:white;border-radius:20px;"></canvas>
                    <br>
                    <div style="display: flex; flex-direction: row; width: 50%; justify-content: center;">
                        <button type="button" id="clear_ps_signature" class="submit_btn">CLEAR</button>
                    </div>
                    <script>
                        // Initialize both signature pads

                        const psPad = new SignaturePad(document.getElementById('ps_signature_pad'));
                        document.getElementById('clear_ps_signature').addEventListener('click', () => psPad.clear());

                    </script>
                <?php } ?>

            </div>

            <!-- Quality Control -->
            <div style="display: flex; flex-direction: column; align-items: center;">
                <label for="quality_control">Quality Control Person</label>
                <input type="text" id="quality_control" name="quality_control" class="inputs"
                    placeholder="Quality Control" style="width: 30vw;" value="<?php echo $lop['quality_control']; ?>">
                <?php if ($lop['quality_controller_signature'] != null) { ?>
                    <img src="<?php echo $lop['quality_controller_signature']; ?>" width="400" height="200">
                <?php } else { ?>
                    <canvas id="qc_signature_pad" class="signature-pad" width="400" height="200"
                        style="background-color:white;border-radius:20px;"></canvas>
                    <br>
                    <div style="display: flex; flex-direction: row; width: 50%; justify-content: center;">
                        <button type="button" id="clear_qc_signature" class="submit_btn">CLEAR</button>
                    </div>
                    <script>
                        const qcPad = new SignaturePad(document.getElementById('qc_signature_pad'));
                        // Clear buttons
                        document.getElementById('clear_qc_signature').addEventListener('click', () => qcPad.clear());

                    </script>
                <?php } ?>

            </div>
        </div>

        <br>
        <div style="display: flex; justify-content: center;">
            <button type="button" id="submit_form_btn" class="submit_btn" style="width: 100%;">UPDATE</button>
        </div>
    </div>
    </div>


    </div>

    <script>

        function equipment_comment(answer, comment) {
            var equipment_answer = document.getElementById(answer);
            var equipment_comment = document.getElementById(comment);

            if (equipment_answer.value === "NO") {
                equipment_comment.required = true;
                equipment_comment.readOnly = false;
                equipment_comment.style.border = "3px solid red";
            } else if (equipment_answer.value === "N/A") {
                equipment_comment.required = false;
                equipment_comment.readOnly = true;
                equipment_comment.style.border = "3px solid grey";
            } else {
                equipment_comment.required = false;
                equipment_comment.style.border = "3px solid #004aad";
            }
        }

        // Convert DataURL to Blob
        function dataURLToBlob(dataURL) {
            const binary = atob(dataURL.split(',')[1]);
            const array = [];
            for (let i = 0; i < binary.length; i++) {
                array.push(binary.charCodeAt(i));
            }
            return new Blob([new Uint8Array(array)], {
                type: dataURL.split(',')[0].split(':')[1].split(';')[0]
            });
        }

        document.getElementById('submit_form_btn').addEventListener('click', function () {
            const form = document.getElementById('lop_jobcard');
            try {
                if (qcPad.isEmpty()) {

                } else {


                    // Remove previous hidden inputs if any
                    document.querySelectorAll('.signature_hidden_input').forEach(e => e.remove());


                    const qcData = qcPad.toDataURL('image/png');

                    const qcInput = document.createElement('input');
                    qcInput.type = 'hidden';
                    qcInput.name = 'qc_signature';
                    qcInput.value = qcData;
                    qcInput.classList.add('signature_hidden_input');

                    form.appendChild(qcInput);
                }
            } catch (e) { }
            try {
                if (psPad.isEmpty()) {

                } else {


                    // Remove previous hidden inputs if any
                    document.querySelectorAll('.signature_hidden_input').forEach(e => e.remove());

                    // Create hidden fields for each signature
                    const psData = psPad.toDataURL('image/png');

                    const psInput = document.createElement('input');
                    psInput.type = 'hidden';
                    psInput.name = 'ps_signature';
                    psInput.value = psData;
                    psInput.classList.add('signature_hidden_input');

                    form.appendChild(psInput);
                }
            } catch (e) { }

            // Submit the form
            form.submit();
        });

        function halfway_save() {
            const form = document.getElementById('lop_jobcard');

            const psInput = document.createElement('input');
            psInput.type = 'hidden';
            psInput.name = 'save_halfway';
            psInput.value = '1';

            form.appendChild(psInput);

            // Submit the form
            form.submit();
        }

        function equipmentCleaned() {
            var select = document.getElementById("equipment_cleaned");
            var commentInput = document.getElementById("equipment_cleaned_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function lopRoomCleaned() {
            var select = document.getElementById("lop_room_cleaned");
            var commentInput = document.getElementById("lop_room_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function pestActivityNoted() {
            var select = document.getElementById("pest_activity_noted");
            var commentInput = document.getElementById("pest_activity_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function smellsTaintsSigns() {
            var select = document.getElementById("smells_taints_signs");
            var commentInput = document.getElementById("smells_taints_signs_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function airDustOperational() {
            var select = document.getElementById("air_dust_operational");
            var commentInput = document.getElementById("air_dust_operational_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function visualContaminationRisks() {
            var select = document.getElementById("visual_contamination_risks");
            var commentInput = document.getElementById("visual_contamination_risks_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function cheeseCratesClean() {
            var select = document.getElementById("cheese_crates_clean");
            var commentInput = document.getElementById("cheese_crates_clean_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function trolleyTraceabilityAvailable() {
            var select = document.getElementById("trolley_traceability_available");
            var commentInput = document.getElementById("trolley_traceability_available_comment");

            if (select.value === "NO") {
                commentInput.required = true;
                commentInput.style.border = "3px solid red";
            } else {
                commentInput.required = false;
                commentInput.style.border = "3px solid #004aad";
            }
        }

        function open_quality_control() {
            document.getElementById("quality_process_control_table").style.display = "block";
        }

        function close_quality_control() {
            document.getElementById("quality_process_control_table").style.display = "none";
        }

        function open_equipment() {
            document.getElementById("equipment_popup").style.display = "block";
        }

        function close_equipment() {
            document.getElementById("equipment_popup").style.display = "none";
        }


        document.getElementById("lop_jobcard").addEventListener("keydown", function (event) {
            if (event.key === "Enter") {
                event.preventDefault(); // stops the form submission
            }
        });

        function addEquipmentRow() {
            // Use the number of children already inside #equipment_row to get a unique index
            var i = document.getElementById("equipment_counter").value;

            // Create wrapper div for this row
            var newDiv = document.createElement("div");
            newDiv.style.display = "flex";
            newDiv.style.flexDirection = "row";
            newDiv.style.borderBottom = "4px solid black";
            newDiv.style.width = "100%";

            // First Column: Equipment Input
            var row1 = document.createElement("div");
            row1.style.width = "25%";
            var select1 = document.createElement("input");
            select1.name = "equipment_" + i;
            select1.id = "equipment_" + i;
            select1.className = "inputs";
            select1.placeholder = "Equipment";
            select1.style.width = "90%";

            row1.appendChild(select1);
            newDiv.appendChild(row1);

            // Second Column: Verify Settings Input
            var row2 = document.createElement("div");
            row2.style.width = "50%";
            row2.style.borderLeft = "2px solid black";
            row2.style.borderRight = "2px solid black";

            var input2 = document.createElement("input");
            input2.type = "text";
            input2.name = "verify_settings_" + i;
            input2.id = "verify_settings_" + i;
            input2.className = "inputs";
            input2.placeholder = "List of settings to be verified before start-up";
            input2.style.width = "90%";
            row2.appendChild(input2);
            newDiv.appendChild(row2);

            // Third Column: Accuracy Select
            var row3 = document.createElement("div");
            row3.style.width = "25%";

            var select = document.createElement("select");
            select.name = "accurate_" + i;
            select.id = "accurate_" + i;
            select.className = "inputs";
            select.style.width = "90%";

            var options = ["", "YES", "NO"];
            options.forEach(function (val) {
                var option = document.createElement("option");
                option.value = val;
                option.text = val === "" ? "SELECT ACCURACY" : val;
                select.appendChild(option);
            });

            row3.appendChild(select);
            newDiv.appendChild(row3);

            // Append the whole row
            document.getElementById("equipment_row").appendChild(newDiv);

            // Increment the counter
            document.getElementById("equipment_counter").value = parseInt(document.getElementById("equipment_counter").value) + 1;
        }
    </script>
</form>