<?php
require('../../fpdf.php');
include "../../root.class.php";

$db = new db_safeguard();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(25, 10, "EQUIPMENT", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(50, 8, "EQUIPMENT", 1, 0, 'L');
$pdf->Cell(50, 8, "SETTINGS", 1, 0, 'L');
$pdf->Cell(50, 8, "ACCURATE", 1, 1, 'L');
$pdf->Cell(50, 8, "COMMENTS", 1, 1, 'L');

$res_data = $db->query("cracking_equipment", "SELECT * FROM cracking_equipment WHERE cracking_jobcard_id = {$_GET['record_id']}");
while ($equipment = $res_data->fetch_assoc()) {
    $pdf->Cell(50, 8, $equipment['equipment'], 1, 0, 'L');
    $pdf->Cell(50, 8, $equipment['verify_settings'], 1, 0, 'L');
    $pdf->Cell(50, 8, $equipment['accurate'], 1, 1, 'L');
    $pdf->Cell(50, 8, $equipment['comments'], 1, 1, 'L');
}

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(60, 10, "FOOD SAFETY INSPECTIONS", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(78, 8, "Food safety Inspection criteria/ points:", 1, 0, 'L');
$pdf->Cell(70, 8, "Select/ Complete:", 1, 0, 'L');
$pdf->Cell(50, 8, "Comment:", 1, 1, 'L');

$res_da = $db->query("cracking_food_safety_inspections", "SELECT * FROM cracking_food_safety_inspections WHERE cracking_jobcard_id = {$_GET['record_id']}");
while ($instructions = $res_da->fetch_assoc()) {

    $food_comments_res = $db->query("cracking_food_safety_comments", "SELECT * FROM cracking_food_safety_comments WHERE food_safety_id = {$instructions['record_id']}");

    while ($food_comments = $food_comments_res->fetch_assoc()) {

        $pdf->Cell(78, 8, "Equipment Clean & sanitized", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['equipment_cleaned'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['equipment_cleaned_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Magnet 1 (" . $instructions['magnet_1_name'] . ") (Initial) Clean?", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['magnet_1_cleaned'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['magnet_1_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Magnet 2 (" . $instructions['magnet_2_name'] . ") (Initial) Clean?", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['magnet_2_cleaned'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['magnet_2_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Oxyacid Concentration verification: ", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['oxyacid_concentration_verification	'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['creaking_equipment_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "No signs of rust, oil leaks, or foreign objects", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['oil_rust_signs'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['oil_rust_signs_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Shell separator & sieves clean", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['shell_sieves_clean'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['shell_sieves_clean_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Air filtration/dust control working properly", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['filter_dust_control_working'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['filter_dust_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Personal hygiene(hands,gloves,PPE) checked?", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['personal_hygiene'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['personal_hygiene_comment'], 1, 1, 'L');

        $pdf->Cell(78, 8, "Tools sanitized and labelled? ", 1, 0, 'L');
        $pdf->Cell(70, 8, $instructions['tools_sanitized_labelled'], 1, 0, 'L');
        $pdf->Cell(50, 8, $food_comments['tools_sanitized_comment'], 1, 1, 'L');

    }
}

$pdf->AddPage('p');
$pdf->Cell(10, 10, '', 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 13);
$pdf->Cell(65, 10, "FOOD SAFETY INSPECTIONS", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(33, 8, "Date & Time", 1, 0, 'L');
$pdf->Cell(19, 8, "Shift (D/N)", 1, 0, 'L');
$pdf->Cell(30, 8, "Sample Size(kg)", 1, 0, 'L');
$pdf->Cell(35, 8, "Product sample point", 1, 0, 'L');
$pdf->Cell(15, 8, "Wholes", 1, 0, 'L');
$pdf->Cell(15, 8, "Halves", 1, 0, 'L');
$pdf->Cell(13, 8, "Dust", 1, 0, 'L');
$pdf->Cell(15, 8, "Shells", 1, 0, 'L');
$pdf->Cell(27, 8, "Broken/Chipped", 1, 0, 'L');
$pdf->Cell(25, 8, "Shell in Kernal", 1, 1, 'L');

$res_dat = $db->query("cracking_quality_process_control", "SELECT * FROM cracking_quality_process_control WHERE record_id = {$_GET['record_id']}");
while ($checks = $res_dat->fetch_assoc()) {

    $pdf->Cell(33, 8, $checks['date_time'], 1, 0, 'L');
    $pdf->Cell(19, 8, $checks['shift'], 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['sample_size'], 1, 0, 'L');
    $pdf->Cell(35, 8, $checks['product_sample_point'], 1, 0, 'L');
    $pdf->Cell(15, 8, $checks['wholes'] . " kg", 1, 0, 'L');
    $pdf->Cell(15, 8, $checks['halves'] . " kg", 1, 0, 'L');
    $pdf->Cell(13, 8, $checks['dust'] . " kg", 1, 0, 'L');
    $pdf->Cell(15, 8, $checks['shells'] . " kg", 1, 0, 'L');
    $pdf->Cell(27, 8, $checks['broken_chipped'] . " kg", 1, 0, 'L');
    $pdf->Cell(25, 8, $checks['shell_in_kernal'] . " kg", 1, 1, 'L');
}

$pdf->Cell(10, 10, '', 0, 1, 'L');

$pdf->Cell(30, 8, "Un-cracked Nuts", 1, 0, 'L');
$pdf->Cell(40, 8, "Crushed/ Missing Kernal", 1, 0, 'L');
$pdf->Cell(20, 8, "Moisure %", 1, 0, 'L');
$pdf->Cell(30, 8, "Env. Temperature", 1, 0, 'L');
$pdf->Cell(30, 8, "Env. Humidity", 1, 0, 'L');
$pdf->Cell(30, 8, "Magnet inspection", 1, 1, 'L');

$res_dat = $db->query("cracking_quality_process_control", "SELECT * FROM cracking_quality_process_control WHERE record_id = {$_GET['record_id']}");
while ($checks = $res_dat->fetch_assoc()) {

    $pdf->Cell(30, 8, $checks['uncracked_missing_kernal'], 1, 0, 'L');
    $pdf->Cell(40, 8, $checks['shell_in_kernal'] . " kg", 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['moisture'] . " %", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['env_temperature'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['env_humidity'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['magnet_inspection'], 1, 0, 'L');

    $pdf->Cell(10, 20, '', 0, 1, 'L');

    $pdf->Cell(50, 10, "Person Inspecting : ", 0, 0, 'L');
    $pdf->Cell(40, 10, $checks['person_inspection'], 0, 1, 'L');

    $pdf->Image("../cracking/signatures/" . $checks['cracking_signature'], 50, 100, 30);
    $pdf->Cell(30, 15, "Signature : ", 0, 1, 'L');

    // person_inspection
}


$pdf->Cell(10, 5, '', 0, 1, 'L');

$pdf->Output("I");
