<?php
$dir = "pages/";
$files = glob($dir . "*.jpg");
sort($files); // Ensure order
?>

<!DOCTYPE html>
<html>
<head>
  <title>Slideshow</title>
  <style>
    body { text-align: center; font-family: Arial; }
    img { max-width: 90%; height: auto; }
    .controls { margin-top: 20px; }
    button { padding: 10px 20px; margin: 0 10px; }
  </style>
</head>
<body>
  <h2>Slideshow</h2>
  <div>
    <img id="slide" src="<?php echo $files[0]; ?>" alt="Slide">
  </div>
  <div class="controls">
    <button onclick="prevSlide()">⬅ Prev</button>
    <button onclick="nextSlide()">Next ➡</button>
  </div>

  <script>
    var slides = <?php echo json_encode($files); ?>;
    var index = 0;
    var img = document.getElementById("slide");

    function showSlide(i) {
      if (i >= 0 && i < slides.length) {
        index = i;
        img.src = slides[index];
      }
    }

    function nextSlide() {
      if (index < slides.length - 1) showSlide(index + 1);
    }

    function prevSlide() {
      if (index > 0) showSlide(index - 1);
    }
  </script>
</body>
</html>
