<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$gm_date = new input();
$gm_date->type("datetime-local");
$gm_date->name("gm_date");
$gm_date->id("gm_date");

$om_date = new input();
$om_date->type("datetime-local");
$om_date->name("om_date");
$om_date->id("om_date");

$fstl_date = new input();
$fstl_date->type("datetime-local");
$fstl_date->name("fstl_date");
$fstl_date->id("fstl_date");

$gm_name_surname = new input();
$gm_name_surname->type("text");
$gm_name_surname->name("gm_name_surname");
$gm_name_surname->id("gm_name_surname");
$gm_name_surname->placeholder("Name & Surname");

$om_name_surname = new input();
$om_name_surname->type("text");
$om_name_surname->name("om_name_surname");
$om_name_surname->id("om_name_surname");
$om_name_surname->placeholder("Name & Surname");

$fstl_name_surname = new input();
$fstl_name_surname->type("text");
$fstl_name_surname->name("fstl_name_surname");
$fstl_name_surname->id("fstl_name_surname");
$fstl_name_surname->placeholder("Name & Surname");

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->onclick("allergen_management()");

?>
<style>
    table,
    th,
    td {
        border: 2px solid black;
        border-collapse: collapse;
        padding: 5px;
    }
</style>
<form action="save_allergen.php" method="post">
    <div class="form_down">
        <h1>Allergen Management</h1>

        <div style="text-align: justify; width: 80%;">
            <p>The Management and Employees of Lowveld Nuts (Pty) Ltd are committed to providing products that meet all
                our
                customer’s dietary requirements.
                Lowveld Nuts understands the increasing prevalence of life-threatening allergies among the population
                and
                recognizing that the risk of accidental exposure to allergens can be reduced.
            </p>
            <p>Allergens identified on the manufacturing site for Lowveld Nuts: Tree nuts (Macadamia Nuts)</p>
            <p>Lowveld Nuts is committed to working in cooperation with customers, suppliers, and staff, to minimize
                risks
                and provide safe products for all its consumers. </p>
            <p>The focus of allergy management shall be on prevention, education, awareness and communication. </p>
            <p>The goals for allergy management include:</p>
            <ul>
                <li>To define a formal process for identifying, managing, and ensuring continuity of processing of all
                    products. These procedures shall be outlined in detail and form part of the food safety management
                    system.</li>
                <li>To ensure all product development will actively remove or avoid the use of allergens and other
                    products
                    that are a concern to our customer’s.</li>
                <li>To ensure the minimal risk of cross contamination, suitable controls and standards will be in place.
                </li>
            </ul>

            <p>To achieve this, we require everyone to strive constantly to improve the quality of the nuts and services
                we
                supply.</p>
            <p> We will maintain a close monitoring procedure made up of daily and weekly checks, overseen by an
                internal
                monthly audit system. </p>
            <p>It is the aim of the company to strive for continuous improvement across all areas in everything we do.
                This
                will be done by providing adequate resources and training a periodical review of the Allergen Management
                System to determine continued adequacy, suitability and effectiveness.</p>
        </div>

        <br><br>

        <table style="width:90%">
            <tr>
                <th>Designation</th>
                <th>Name & Surname</th>
                <th>Signature</th>
                <th>Date</th>
            </tr>
            <tr>
                <td>General Manager</td>
                <td>
                    <?php
                    $gm_name_surname->add();
                    ?>
                </td>
                <td>
                    <canvas id="general_manager_signature" name="general_manager_signature" class="signature-pad"
                        width=550 height=100 style='background-color:lightgrey;border-radius:20px;'></canvas>
                </td>
                <td>
                    <?php
                    $gm_date->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>Operations Manager</td>
                <td>
                    <?php
                    $om_name_surname->add();
                    ?>
                </td>
                <td>
                    <canvas id="operations_manager_signature" name="operations_manager_signature" class="signature-pad"
                        width=550 height=100 style='background-color:lightgrey;border-radius:20px;'></canvas>
                </td>
                <td>
                    <?php
                    $om_date->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>Food Safety Team Leader</td>
                <td>
                    <?php
                    $fstl_name_surname->add();
                    ?>
                </td>
                <td>
                    <canvas id="food_safety_team_leader_signature" name="food_safety_team_leader_signature"
                        class="signature-pad" width=550 height=100
                        style='background-color:lightgrey;border-radius:20px;'></canvas>
                </td>
                <td>
                    <?php
                    $fstl_date->add();
                    ?>
                </td>
            </tr>
        </table>
        <br>
        <?php
        $submit_btn->add();
        ?>
    </div>
</form>


<script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>

<script>
    var operations_manager_canvas = document.getElementById('operations_manager_signature');
    var operations_manager_pad = new SignaturePad(operations_manager_canvas);

    var general_manager_canvas = document.getElementById('general_manager_signature');
    var general_manager_pad = new SignaturePad(general_manager_canvas);

    var food_safety_team_leader_canvas = document.getElementById('food_safety_team_leader_signature');
    var food_safety_team_leader_pad = new SignaturePad(food_safety_team_leader_canvas);

    document.getElementById('save_signature').addEventListener('click', function () {
        if (food_safety_team_leader_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = food_safety_team_leader_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'food_safety_team_leader');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../policy/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    document.getElementById('save_signature').addEventListener('click', function () {
        if (operations_manager_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = operations_manager_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'operations_manager');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../policy/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    document.getElementById('save_signature').addEventListener('click', function () {
        if (general_manager_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = general_manager_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'general_manager');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../policy/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    function dataURLToBlob(dataURL) {
        var binary = atob(dataURL.split(',')[1]);
        var array = [];
        for (var i = 0; i < binary.length; i++) {
            array.push(binary.charCodeAt(i));
        }
        return new Blob([new Uint8Array(array)], {
            type: dataURL.split(',')[0].split(':')[1].split(';')[0]
        });
    }
</script>

<?php

$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

$ajax = new js_ajax();
$ajax->function_name("allergen_management");
$ajax->insert("documents_signed");
$ajax->add_column_and_value("date_time={$current_date}");
$ajax->redirect("allergen_management.pdf.php?record_id={$_GET['record_id']}");
$ajax->on_success("Allergen Management documentation saved");