<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
// $html->check_user_type("ADMIN");

$doc_number = new input();
$doc_number->type("text");
$doc_number->name("doc_number");
$doc_number->id("doc_number");
$doc_number->class("inputs");
$doc_number->placeholder("Document Number");
$doc_number->required();
$doc_number->addAttribute("style", "margin: 1vw auto;");

$revision_date = new input();
$revision_date->type("date");
$revision_date->name("revision_date");
$revision_date->id("revision_date");
$revision_date->class("inputs");
$revision_date->placeholder("DD/MM/YYYY");
$revision_date->required();
$revision_date->addAttribute("style", "margin: 1vw auto;");

$approve_date = new input();
$approve_date->type("date");
$approve_date->name("approve_date");
$approve_date->id("approve_date");
$approve_date->class("inputs");
$approve_date->placeholder("DD/MM/YYYY");
$approve_date->required();
$approve_date->addAttribute("style", "margin: 1vw auto;");

$date_label = new label();
$date_label->for("date");
$date_label->value("Date & Time");
$date_label->addAttribute("style", "margin: 1vw auto;");

$date = new input();
$date->type("datetime-local");
$date->name("date");
$date->id("date");
$date->class("inputs");
$date->addAttribute("style", "margin: 1vw auto;");

$trainer_label = new label();
$trainer_label->for("trainer");
$trainer_label->value("Trainer");
$trainer_label->addAttribute("style", "margin: 1vw auto;");

$trainer = new input();
$trainer->type("text");
$trainer->name("trainer");
$trainer->id("trainer");
$trainer->class("inputs");
$trainer->placeholder("Trainer");
$trainer->required();
$trainer->addAttribute("style", "margin: 1vw auto;");

$position_label = new label();
$position_label->for("position");
$position_label->value("Position");
$position_label->addAttribute("style", "margin: 1vw auto;");

$position = new input();
$position->type("text");
$position->name("position");
$position->id("position");
$position->class("inputs");
$position->placeholder("Position");
$position->required();
$position->addAttribute("style", "margin: 1vw auto;");

$category_label = new label();
$category_label->for("category");
$category_label->value("Category: ");
$category_label->addAttribute("style", "margin: 1vw auto;");

$category = new select();
$category->name("category");
$category->id("category");
$category->class("inputs");
$category->required();
$category->addAttribute("style", "margin: 1vw auto;");
$category->add_option("", "Select");
$category->add_option("", "Category 1");
$category->add_option("", "Category 2");
$category->add_option("", "Category 3");

$duration_label = new label();
$duration_label->for("duration");
$duration_label->value("Duration: ");
$duration_label->addAttribute("style", "margin: 1vw auto;");

$duration = new input();
$duration->type("text");
$duration->name("duration");
$duration->id("duration");
$duration->class("inputs");
$duration->placeholder("Duration");
$duration->required();
$duration->addAttribute("style", "margin: 1vw auto;");

$description_label = new label();
$description_label->for("description");
$description_label->value("Description: ");
$description_label->addAttribute("style", "margin: 1vw auto;");

$description = new input();
$description->name("description");
$description->id("description");
$description->class("inputs");
$description->placeholder("Description");
$description->required();
$description->addAttribute("style", "margin: 1vw auto; width: 100%;");

$doc_name_label = new label();
$doc_name_label->for("doc_name");
$doc_name_label->value("Doc Name: ");
$doc_name_label->addAttribute("style", "margin: 1vw auto;");

$doc_name = new input();
$doc_name->type("text");
$doc_name->name("doc_name");
$doc_name->id("doc_name");
$doc_name->class("inputs");
$doc_name->placeholder("Doc Name");
$doc_name->required();
$doc_name->addAttribute("style", "margin: 1vw auto;");

$target_group_label = new label();
$target_group_label->for("target_group");
$target_group_label->value("Target Group: ");
$target_group_label->addAttribute("style", "margin: 1vw auto;");

$target_group = new input();
$target_group->type("text");
$target_group->name("target_group");
$target_group->id("target_group");
$target_group->class("inputs");
$target_group->placeholder("Target Group");
$target_group->required();
$target_group->addAttribute("style", "margin: 1vw auto;");

$trainee_no = new input();
$trainee_no->type("hidden");
$trainee_no->name("trainee_no");
$trainee_no->id("trainee_no");
$trainee_no->class("inputs");
$trainee_no->placeholder("Trainee No");
$trainee_no->addAttribute("style", "margin: 1vw auto;");
$trainee_no->value(1);

$new_trainee = new button();
$new_trainee->value("New Trainee");
$new_trainee->addAttribute("style", "margin: 1vw auto;");
$new_trainee->onclick("addTraineeRow()");

$submit_btn = new button();
$submit_btn->value("Submit");
$submit_btn->addAttribute("style", "margin: 1vw auto;");
$submit_btn->id("submit_btn");

?>
<form action="">
    <div class="form_down">

        <h1>INTERNAL TRAINING REGISTER</h1>

        <br>
        <div style="display:flex;flex-direction:row;width: 95%;justify-content: space-around;">
            <div style="display:flex;flex-direction:column;width: 100%;justify-content: space-evenly;">
                <div style="display:flex;flex-direction:column;">
                    <?php
                    $date_label->add();
                    $date->add();
                    ?>
                </div>
                <div style="display:flex;flex-direction:column;">
                    <?php
                    $trainer_label->add();
                    $trainer->add();
                    ?>
                </div>
                <div style="display:flex;flex-direction:column;">
                    <?php
                    $position_label->add();
                    $position->add();
                    ?>
                </div>
            </div>
            <div style="width: 100%;">
                <div style="display: flex; justify-content: space-between;">
                    <div style="display:flex;flex-direction:column;">
                        <?php
                        $category_label->add();
                        $category->add();
                        ?>
                    </div>
                    <div style="display:flex;flex-direction:column;">
                        <?php
                        $duration_label->add();
                        $duration->add();
                        ?>
                    </div>
                </div>


                <div style="display:flex;flex-direction:column;">
                    <?php
                    $description_label->add();
                    $description->add();
                    ?>
                </div>

                <div style="display: flex; justify-content: space-between;">
                    <div style="display:flex;flex-direction:column;">
                        <?php
                        $doc_name_label->add();
                        $doc_name->add();
                        ?>
                    </div>

                    <div style="display:flex;flex-direction:column;">
                        <?php
                        $target_group_label->add();
                        $target_group->add();
                        ?>
                    </div>
                </div>
            </div>

            <?php
            $trainee_no->add();
            ?>
        </div>

        <br><br>

        <div style="display: flex; flex-direction: column; width: 95%; border: 2px solid black;">
            <div
                style="display:flex; flex-direction: row; width: 100%; border-bottom: 2px solid black;align-items: center;background-color: #004aad87;">
                <div style="width: 25%; font-size: 1.5vw;">
                    Name & Surname
                </div>
                <div style="width: 15%;font-size: 1.5vw;">
                    Trainee Signature
                </div>
                <div style="width: 25%;font-size: 1.5vw;">
                    Position
                </div>
                <div style="width: 15%;font-size: 1.5vw;">
                    Clock No/ Employee Code
                </div>
                <div style="width: 10%;font-size: 1.5vw;">
                    Gender (M/F)
                </div>
                <div style="width: 10%;font-size: 1.5vw;">
                    Trainee Rate
                </div>
            </div>
            <div
                style="display:flex; flex-direction: row; width: 100%;align-items: center;border-bottom: 2px solid black;">
                <div style="width: 25%;">
                    <input type="text" name="name_1" id="name_1" class="inputs" style="width: 90%;" required>
                </div>
                <div
                    style="display: flex; flex-direction: row;border-left:2px solid black;width: 15%;justify-content: space-around;">
                    <canvas id="trainee_signature_1" class="signature-pad" width=150 height=80
                        style='background-color:lightgrey;border-radius:20px;'></canvas>
                </div>
                <div
                    style="display: flex; flex-direction: row;border-left:2px solid black;width: 25%;justify-content: space-around;">
                    <input type="text" name="position_1" id="position_1" class="inputs" style="width: 90%;" required>
                </div>
                <div
                    style="display: flex; flex-direction: row;border-left:2px solid black;width: 15%;justify-content: space-around;">
                    <input type="text" name="emp_code_1" id="emp_code_1" class="inputs" style="width: 90%;" required>
                </div>
                <div
                    style="display: flex; flex-direction: row;border-left:2px solid black;width: 10%;justify-content: space-around;">
                    <select name="option_1" id="option_1" class="inputs" style="width: 90%;">
                        <option value=""></option>
                        <option value="M">M</option>
                        <option value="F">F</option>
                    </select>
                </div>
                <div
                    style="display: flex; flex-direction: row;border-left:2px solid black;width: 10%;justify-content: space-around;">
                    <input type="text" name="trainee_rate_1" id="trainee_rate_1" class="inputs" style="width: 90%;">
                </div>
            </div>
            <div id="trainees"></div>
        </div>
        <br>
        <?php
        $new_trainee->add();
        $submit_btn->add();
        ?>
    </div>
</form>


<script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>

<script>
    var trainee_no = document.getElementById("trainee_no").value;

    var trainee_canvas = document.getElementById('trainee_signature_1');
    var trainee_pad = new SignaturePad(trainee_canvas);


    document.getElementById('submit_btn').addEventListener('click', function () {
        var trainee_canvas = document.getElementById('trainee_signature_' + trainee_no);
        var trainee_pad = new SignaturePad(trainee_canvas);
    });

    document.getElementById('submit_btn').addEventListener('click', function () {
        if (trainee_pad.isEmpty()) {
            alert("Please provide signature first.");
        } else {
            var dataURL = client_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'trainee');
            formData.append('trainee_no', trainee_no);

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../capture/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // console.log("Signature saved successfully.");
                        // repload page
                        location.reload();

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    function dataURLToBlob(dataURL) {
        var binary = atob(dataURL.split(',')[1]);
        var array = [];
        for (var i = 0; i < binary.length; i++) {
            array.push(binary.charCodeAt(i));
        }
        return new Blob([new Uint8Array(array)], {
            type: dataURL.split(',')[0].split(':')[1].split(';')[0]
        });
    }
</script>

<script>
    var i = 2; // define this outside the function if you plan to call it multiple times

    function addTraineeRow() {
        var newdiv = document.createElement('div');

        newdiv.innerHTML =
            '<div style="display:flex; flex-direction: row; width: 100%;align-items: center;border-bottom: 2px solid black;">' +
            '<div style="width: 25%;">' +
            '<input type="text" name="name_' + i + '" id="name_' + i + '" class="inputs" style="width: 90%;" required>' +
            '</div>' +
            '<div style="display: flex; flex-direction: row;border-left:2px solid black;width: 15%;justify-content: space-around;">' +
            '<canvas id="trainee_signature_' + i + '" class="signature-pad" width=150 height=80' +
            ' style="background-color:lightgrey;border-radius:20px;"></canvas>' +
            '</div>' +
            '<div style="display: flex; flex-direction: row;border-left:2px solid black;width: 25%;justify-content: space-around;">' +
            '<input type="text" name="position_' + i + '" id="position_' + i + '" class="inputs" style="width: 90%;" required>' +
            '</div>' +
            '<div style="display: flex; flex-direction: row;border-left:2px solid black;width: 15%;justify-content: space-around;">' +
            '<input type="text" name="emp_code_' + i + '" id="emp_code_' + i + '" class="inputs" style="width: 90%;" required>' +
            '</div>' +
            '<div style="display: flex; flex-direction: row;border-left:2px solid black;width: 10%;justify-content: space-around;">' +
            '<select name="option_' + i + '" id="option_' + i + '" class="inputs" style="width: 90%;">' +
            '<option value=""></option>' +
            '<option value="M">M</option>' +
            '<option value="F">F</option>' +
            '</select>' +
            '</div>' +
            '<div style="display: flex; flex-direction: row;border-left:2px solid black;width: 10%;justify-content: space-around;">' +
            '<input type="text" name="trainee_rate_' + i + '" id="trainee_rate_' + i + '" class="inputs" style="width: 90%;">' +
            '</div>' +
            '</div>';

        document.getElementById("trainees").appendChild(newdiv);
        i++; // increment after each row

        var trainee_no = document.getElementById("trainee_no");
        trainee_no.value = i;

        var trainee_canvas = document.getElementById('trainee_signature_' + i);
        var trainee_pad = new SignaturePad(trainee_canvas);

        // console.log(document.getElementById('trainee_signature_' + i));
    }

</script>