<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
session_start();

$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

// Make sure user is logged in and file is uploaded
if (!isset($_SESSION['user_id'])) {
    echo "User not logged in.";
    exit;
}

if (!isset($_FILES['file'])) {
    echo "No file uploaded.";
    exit;
}

try {

    if ($type == "security") {
        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    if ($type == "visitor") {

        $visitor_no = $_POST['visitor_no'];
        $target_file = "../capture/signatures/visitor{$visitor_no}-training-{$current_date}.png";

        if (file_exists($target_file)) {
            $visitor_no++;
            $target_file = "../capture/signatures/visitor{$visitor_no}-training.png";
        } else {
            $target_file = "../capture/signatures/visitor{$visitor_no}-training.png";
        }

        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    if ($type == "general_manager") {

        $general_manager = $_POST['general_manager'];
        $target_file = "../capture/signatures/visitor{$general_manager}-training-{$current_date}.png";

        if (file_exists($target_file)) {
            $general_manager++;
            $target_file = "../policy/signatures/general_manager{$general_manager}-training.png";
        } else {
            $target_file = "../policy/signatures/general_manager{$general_manager}-training.png";
        }

        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    if ($type == "operations_manager") {

        $operations_manager = $_POST['operations_manager'];
        $target_file = "../capture/signatures/visitor{$operations_manager}-training-{$current_date}.png";

        if (file_exists($target_file)) {
            $operations_manager_no++;
            $target_file = "../policy/signatures/operations_manager{$operations_manager}-training.png";
        } else {
            $target_file = "../policy/signatures/operations_manager{$operations_manager}-training.png";
        }

        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    if ($type == "food_safety_team_leader") {

        $food_safety_team_leader_no = $_POST['food_safety_team_leader'];
        $target_file = "../capture/signatures/food_safety_team_leader{$food_safety_team_leader}-training-{$current_date}.png";

        if (file_exists($target_file)) {
            $food_safety_team_leader_no++;
            $target_file = "../capture/signatures/visitor{$food_safety_team_leader_no}-training.png";
        } else {
            $target_file = "../capture/signatures/visitor{$food_safety_team_leader_no}-training.png";
        }

        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    return 1;

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}