<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$receiving_batch_no = new input();
$receiving_batch_no->type("hidden");
$receiving_batch_no->name("receiving_batch_no");
$receiving_batch_no->id("receiving_batch_no");
$receiving_batch_no->value($_GET['receiving_batch_no']);
$receiving_batch_no->style("width: 100%; margin: 1vw auto;");

$total_wnis_sample_mass = new input();
$total_wnis_sample_mass->type("number");
$total_wnis_sample_mass->name("total_wnis_sample_mass");
$total_wnis_sample_mass->id("total_wnis_sample_mass");
$total_wnis_sample_mass->style("width: 100%; margin: 1vw auto;");
$total_wnis_sample_mass->onchange("calcNIS()");

$total_dnis_sample_mass = new input();
$total_dnis_sample_mass->type("number");
$total_dnis_sample_mass->name("total_dnis_sample_mass");
$total_dnis_sample_mass->id("total_dnis_sample_mass");
$total_dnis_sample_mass->style("width: 100%; margin: 1vw auto;");
$total_dnis_sample_mass->onchange("calcNIS(), calcTotalKernelRecovery()");

$shell_mass = new input();
$shell_mass->type("number");
$shell_mass->name("shell_mass");
$shell_mass->id("shell_mass");
$shell_mass->style("width: 100%; margin: 1vw auto;");

$kernal_m_c = new input();
$kernal_m_c->type("number");
$kernal_m_c->name("kernal_m_c");
$kernal_m_c->id("kernal_m_c");
$kernal_m_c->style("width: 100%; margin: 1vw auto;");

$nis_moisture_loss = new input();
$nis_moisture_loss->type("number");
$nis_moisture_loss->name("nis_moisture_loss");
$nis_moisture_loss->id("nis_moisture_loss");
$nis_moisture_loss->style("width: 100%; margin: 1vw auto;");
$nis_moisture_loss->onchange("calcNIS()");
$nis_moisture_loss->readonly();

$sound_kernel_mass = new input();
$sound_kernel_mass->type("number");
$sound_kernel_mass->name("sound_kernel_mass");
$sound_kernel_mass->id("sound_kernel_mass");
$sound_kernel_mass->style("width: 100%; margin: 1vw auto;");
$sound_kernel_mass->onchange("calcMassOFKernal(), calcSoundKernel()");

$mould = new input();
$mould->type("number");
$mould->name("mould");
$mould->id("mould");
$mould->style("width: 100%; margin: 1vw auto;");

$spot_791 = new input;
$spot_791->type("number");
$spot_791->name("791_spot");
$spot_791->id("791_spot");
$spot_791->style("width: 100%; margin: 1vw auto;");

$onion_ring = new input();
$onion_ring->type("number");
$onion_ring->name("onion_ring");
$onion_ring->id("onion_ring");
$onion_ring->style("width: 100%; margin: 1vw auto;");
$onion_ring->onchange("calcMassOFKernal(), calcSoundKernel()");

$immature = new input();
$immature->type("number");
$immature->name("immature");
$immature->id("immature");
$immature->style("width: 100%; margin: 1vw auto;");
$immature->onchange("calcImmature_percent()");

$open_micropyl = new input();
$open_micropyl->type("number");
$open_micropyl->name("open_micropyl");
$open_micropyl->id("open_micropyl");
$open_micropyl->style("width: 100%; margin: 1vw auto;");

$unsound_kernel_mass = new input();
$unsound_kernel_mass->type("number");
$unsound_kernel_mass->name("unsound_kernel_mass");
$unsound_kernel_mass->id("unsound_kernel_mass");
$unsound_kernel_mass->style("width: 100%; margin: 1vw auto;");
$unsound_kernel_mass->onchange("calcMassOFKernal(), calcUSK(), calcNIS_USK()");

$shell_mark = new input();
$shell_mark->type("number");
$shell_mark->name("shell_mark");
$shell_mark->id("shell_mark");
$shell_mark->style("width: 100%; margin: 1vw auto;");

$brown_center = new input();
$brown_center->type("number");
$brown_center->name("brown_center");
$brown_center->id("brown_center");
$brown_center->style("width: 100%; margin: 1vw auto;");

$total_kernel_mass = new input();
$total_kernel_mass->type("number");
$total_kernel_mass->name("total_kernel_mass");
$total_kernel_mass->id("total_kernel_mass");
$total_kernel_mass->style("width: 100%; margin: 1vw auto;");
$total_kernel_mass->onchange("calcTotalKernelRecovery()");
$total_kernel_mass->readonly();

$pit_center = new input();
$pit_center->type("number");
$pit_center->name("pit_center");
$pit_center->id("pit_center");
$pit_center->style("width: 100%; margin: 1vw auto;");

$late_sting_bug = new input();
$late_sting_bug->type("number");
$late_sting_bug->name("late_sting_bug");
$late_sting_bug->id("late_sting_bug");
$late_sting_bug->style("width: 100%; margin: 1vw auto;");

$usk_recovery = new input();
$usk_recovery->type("number");
$usk_recovery->name("usk_recovery");
$usk_recovery->id("usk_recovery");
$usk_recovery->style("width: 100%; margin: 1vw auto;");
$usk_recovery->onchange("calcUSK()");
$usk_recovery->readonly();

$early_sting_bug = new input();
$early_sting_bug->type("number");
$early_sting_bug->name("early_sting_bug");
$early_sting_bug->id("early_sting_bug");
$early_sting_bug->style("width: 100%; margin: 1vw auto;");

$nis_usk_recovery = new input();
$nis_usk_recovery->type("number");
$nis_usk_recovery->name("nis_usk_recovery");
$nis_usk_recovery->id("nis_usk_recovery");
$nis_usk_recovery->style("width: 100%; margin: 1vw auto;");
$nis_usk_recovery->onchange("calcNIS_USK()");
$nis_usk_recovery->readonly();

$nutborer = new input();
$nutborer->type("number");
$nutborer->name("nutborer");
$nutborer->id("nutborer");
$nutborer->style("width: 100%; margin: 1vw auto;");

$sound_kernel_recovery = new input();
$sound_kernel_recovery->type("number");
$sound_kernel_recovery->name("sound_kernel_recovery");
$sound_kernel_recovery->id("sound_kernel_recovery");
$sound_kernel_recovery->style("width: 100%; margin: 1vw auto;");
$sound_kernel_recovery->onchange("calcSoundKernel()");
$sound_kernel_recovery->readonly();

$germination = new input();
$germination->type("number");
$germination->name("germination");
$germination->id("germination");
$germination->style("width: 100%; margin: 1vw auto;");

$immature_percent = new input();
$immature_percent->type("number");
$immature_percent->name("immature_percent");
$immature_percent->id("immature_percent");
$immature_percent->style("width: 100%; margin: 1vw auto;");
$immature_percent->onchange("calcImmature_percent()");
$immature_percent->readonly();

$adhered_skin = new input();
$adhered_skin->type("number");
$adhered_skin->name("adhered_skin");
$adhered_skin->id("adhered_skin");
$adhered_skin->style("width: 100%; margin: 1vw auto;");

$total_kernel_recovery = new input();
$total_kernel_recovery->type("number");
$total_kernel_recovery->name("total_kernel_recovery");
$total_kernel_recovery->id("total_kernel_recovery");
$total_kernel_recovery->style("width: 100%; margin: 1vw auto;");
// $total_kernel_recovery->onchange("calcTotalKernelRecovery()");
$total_kernel_recovery->readonly();

$pink_staining = new input();
$pink_staining->type("number");
$pink_staining->name("pink_staining");
$pink_staining->id("pink_staining");
$pink_staining->style("width: 100%; margin: 1vw auto;");

$total = new input();
$total->type("number");
$total->name("total");
$total->id("total");
$total->style("width: 100%; margin: 1vw auto;");

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("SUBMIT");

?>

<form action="save_kernal.php" method="post">
    <div class="form_down">
        <h1>KERNAL ANALYSIS</h1>
        <style>
            table,
            th,
            td {
                border: 2px solid black;
                border-collapse: collapse;
                padding: 5px;
            }
        </style>
        <?php
        $receiving_batch_no->add();
        ?>
        <table style="width: 90%">
            <tr>
                <th colspan="6" style="background-color: #004aad80;">KERNEL PRE-CRACK ANALYSIS</th>
            </tr>
            <tr>
                <td>
                    A. TOTAL MASS OF SAMPLE WNIS (g):
                </td>
                <td colspan="5">
                    <?php
                    $total_wnis_sample_mass->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>
                    B. TOTAL MASS OF SAMPLE DNIS (DATE) (g):
                </td>
                <td colspan="5">
                    <?php
                    $total_dnis_sample_mass->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>
                    MASS OF SHELL (g)
                </td>
                <td>
                    <?php
                    $shell_mass->add();
                    ?>
                </td>
                <td colspan="2">
                    KERNAL M/C (%)
                </td>
                <td colspan="2">
                    <?php
                    $kernal_m_c->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>
                    NIS MOISTURE LOSS (A - B ÷ A x 100) (g)
                </td>
                <td>
                    <?php
                    $nis_moisture_loss->add();
                    ?>
                </td>
                <td colspan="4">
                    UNSOUND ANALYSIS
                </td>
            </tr>
            <tr>
                <td>C. MASS OF SOUND KERNEL (%)</td>
                <td>
                    <?php
                    $sound_kernel_mass->add();
                    ?>
                </td>
                <td>MOULD (g)</td>
                <td>
                    <?php
                    $mould->add();
                    ?>
                </td>
                <td> 791 SPOT</td>
                <td>
                    <?php
                    $spot_791->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>ONION RING / DISCOLOURATION (g)</td>
                <td>
                    <?php
                    $onion_ring->add();
                    ?>
                </td>
                <td>IMMATURE (g)</td>
                <td>
                    <?php
                    $immature->add();
                    ?>
                </td>
                <td>OPEN MICROPYL (g)</td>
                <td>
                    <?php
                    $open_micropyl->add();
                    ?>
                </td>

            </tr>
            <tr>
                <td>D. MASS OF UNSOUND KERNEL (g)</td>
                <td>
                    <?php
                    $unsound_kernel_mass->add();
                    ?>
                </td>
                <td>SHELL MARK (g)</td>
                <td>
                    <?php
                    $shell_mark->add();
                    ?>
                </td>
                <td>BROWN CENTER (g)</td>
                <td>
                    <?php
                    $brown_center->add();
                    ?>
                </td>

            </tr>
            <tr>
                <td>E. TOTAL MASS OF KERNEL (C + ONION RING/DISC + D) (g)</td>
                <td>
                    <?php
                    $total_kernel_mass->add();
                    ?>
                </td>
                <td>PIT CENTER (g)</td>
                <td>
                    <?php
                    $pit_center->add();
                    ?>
                </td>
                <td>LATE STING BUG (g)</td>
                <td>
                    <?php
                    $late_sting_bug->add();
                    ?>
                </td>

            </tr>
            <tr>
                <td>USK RECOVERY % (D ÷ E) X 100 (%)</td>
                <td>
                    <?php
                    $usk_recovery->add();
                    ?>
                </td>
                <td>EARLY STING BUG (g)</td>
                <td>
                    <?php
                    $early_sting_bug->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>NIS USK RECOVERY (D ÷ B) X 100 (%)</td>
                <td>
                    <?php
                    $nis_usk_recovery->add();
                    ?>
                </td>
                <td>NUTBORER</td>
                <td>
                    <?php
                    $nutborer->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>SOUND KERNEL RECOVERY % (C + ONION RING/DISC ÷ B X 100) (%)</td>
                <td>
                    <?php
                    $sound_kernel_recovery->add();
                    ?>
                </td>
                <td>GERMINATION</td>
                <td>
                    <?php
                    $germination->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>IMMATURE % (IMM ÷ E) X 100 (%)</td>
                <td>
                    <?php
                    $immature_percent->add();
                    ?>
                </td>
                <td>ADHERDED SKIN</td>
                <td>
                    <?php
                    $adhered_skin->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td>TOTAL KERNEL RECOVERY % (E ÷ B) X 100 (%)</td>
                <td>
                    <?php
                    $total_kernel_recovery->add();
                    ?>
                </td>
                <td>PINK STAINING</td>
                <td>
                    <?php
                    $pink_staining->add();
                    ?>
                </td>
            </tr>
            <tr>
                <td colspan="4">TOTAL (g)</td>
                <td colspan="2">
                    <?php
                    $total->add();
                    ?>
                </td>
            </tr>
        </table>
        <br>
        <?php
        $submit_btn->add();
        ?>
    </div>
</form>

<script>

    function calcNIS() {
        var wnisInput = document.getElementById('total_wnis_sample_mass').value;
        var dnisInput = document.getElementById('total_dnis_sample_mass').value;

        if (wnisInput === "" || dnisInput === "") {
            document.getElementById('nis_moisture_loss').value = "";
            return; // exit if one of the fields is empty
        }

        var total_wnis = parseFloat(wnisInput);
        var total_dnis = parseFloat(dnisInput);

        if (isNaN(total_wnis) || isNaN(total_dnis) || total_wnis === 0) {
            document.getElementById('nis_moisture_loss').value = "";
            return; // exit if invalid number or divide by zero risk
        }

        var total_nis = ((total_wnis - total_dnis) / total_wnis * 100).toFixed(2);
        document.getElementById('nis_moisture_loss').value = total_nis;
    }

    function calcMassOFKernal() {
        var sound_kernel_mass = parseFloat(document.getElementById('sound_kernel_mass').value);
        var onion_ring = parseFloat(document.getElementById('onion_ring').value);
        var unsound_kernel_mass = parseFloat(document.getElementById('unsound_kernel_mass').value);

        if (isNaN(sound_kernel_mass)) sound_kernel_mass = 0;
        if (isNaN(onion_ring)) onion_ring = 0;
        if (isNaN(unsound_kernel_mass)) unsound_kernel_mass = 0;

        var total_kernel_mass = (sound_kernel_mass + onion_ring + unsound_kernel_mass).toFixed(2);
        document.getElementById('total_kernel_mass').value = total_kernel_mass;
    }

    function calcUSK() {
        var unsound_kernel_mass = parseFloat(document.getElementById('unsound_kernel_mass').value);
        var total_kernel_mass = parseFloat(document.getElementById('total_kernel_mass').value);

        if (isNaN(unsound_kernel_mass) || isNaN(total_kernel_mass) || total_kernel_mass === 0) {
            document.getElementById('usk_recovery').value = "";
            return;
        }

        var usk = ((unsound_kernel_mass / total_kernel_mass) * 100).toFixed(2);
        document.getElementById('usk_recovery').value = usk;
    }

    function calcNIS_USK() {
        var unsound_kernel_mass = parseFloat(document.getElementById('unsound_kernel_mass').value);
        var total_dnis = parseFloat(document.getElementById('total_dnis_sample_mass').value);

        if (isNaN(unsound_kernel_mass) || isNaN(total_dnis) || total_dnis === 0) {
            document.getElementById('nis_usk_recovery').value = "";
            return;
        }

        var nis_usk = ((unsound_kernel_mass / total_dnis) * 100).toFixed(2);
        document.getElementById('nis_usk_recovery').value = nis_usk;
    }

    function calcSoundKernel() {
        var sound_kernel_mass = parseFloat(document.getElementById('sound_kernel_mass').value);
        var onion_ring = parseFloat(document.getElementById('onion_ring').value);
        var total_dnis = parseFloat(document.getElementById('total_dnis_sample_mass').value);

        if (isNaN(sound_kernel_mass)) sound_kernel_mass = 0;
        if (isNaN(onion_ring)) onion_ring = 0;

        if (isNaN(total_dnis) || total_dnis === 0) {
            document.getElementById('sound_kernel_recovery').value = "";
            return;
        }

        var sound_kernel = ((sound_kernel_mass + onion_ring) / total_dnis * 100).toFixed(2);
        document.getElementById('sound_kernel_recovery').value = sound_kernel;
    }

    function calcImmature_percent() {
        var immature = parseFloat(document.getElementById('immature').value);
        var total_kernel_mass = parseFloat(document.getElementById('total_kernel_mass').value);

        if (isNaN(immature) || isNaN(total_kernel_mass) || total_kernel_mass === 0) {
            document.getElementById('immature_percent').value = "";
            return;
        }

        var immature_percent = ((immature / total_kernel_mass) * 100).toFixed(2);
        document.getElementById('immature_percent').value = immature_percent;
    }

    function calcTotalKernelRecovery() {
        var total_kernel_mass = parseFloat(document.getElementById('total_kernel_mass').value);
        var total_dnis = parseFloat(document.getElementById('total_dnis_sample_mass').value);

        if (isNaN(total_kernel_mass) || isNaN(total_dnis) || total_dnis === 0) {
            document.getElementById('total_kernel_recovery').value = "";
            return;
        }

        var total_kernel_recovery = ((total_kernel_mass / total_dnis) * 100).toFixed(2);
        document.getElementById('total_kernel_recovery').value = total_kernel_recovery;
    }
</script>