<?php include "../../root.class.php";
$html = new html();
$db = new db_safeguard();
$html->add_styles_page();

function createInput($name)
{
    $input = new input();
    $input->type("text");
    $input->name($name);
    $input->id($name);
    $input->style("width: 95%;margin:1vw auto;");
    return $input;
}

// Row generator
function createRowInputs($base_name)
{
    return [
        "coa" => createInput($base_name . "_coa"),
        "inspection" => createInput($base_name . "_intake_inspection"),
        "comment" => createInput($base_name . "_comment")
    ];
}
// "free_fatty_acids" => ["Free Fatty Acids", "<0.5%"],
// "peroxide_value" => ["Peroxide Value", "<3 meq/kg OIL"],
// Array: key => [spec name, limit/specification]
// "aflatoxin" => ["<b>Aflatoxin</b> (refer to COA)(B1, B2, G1, G2)", "<10 ppb total aflatoxins <br> (>10 ppb → Reject or quarantine)"],
    // "smell_or_odour" => ["Smell / Odour", "No sour, rancid, or mouldy smell"],

// color - onion ring
$rows = [

    "moisture_content" => ["Moisture Content", "≤20% <br> (>13.5% → Reject or Dry Immediately)"],
    "nut_count_and_kernel_recovery" => ["<b>Nut Count & Kernel Recovery</b> (Cracking & sieving)(Premium Kernel Delivered)", "Min 25% Kernel Recovery <br> (Alert <20%)"],
    "immature_nuts" => ["<b>Immature Nuts</b> (Manual crack-out)", "≤5% <br> (>10% → Reject or Downgrade)"],
    "mould_internal_or_old" => ["<b>Mould (internal)/Old</b> (Crack-out & visual exam)", "≤1% kernels with internal mould <br> (>2% → Reject or hold)"],
    "early_stinkbug" => ["<b>Early Stinkbug </b>(Small pale spot or brown lesion on the kernel surface; Surface texture might be slightly roughened or wrinkled)", "≤2% by weight or ≤3 kernels"],
    "late_stinkbug" => ["<b>Late Stinkbug</b> (Large black or dark brown patches on the kernel; Visible feeding scars or discoloured streaks can appear across the kernel)", "0% — Not permitted"],
    "germination" => ["<b>Germination</b> (Radicle emergence; split kernel [open at the hilum or base]; discolouration [dull white/ translucent]; texture change [rubbery, soft, chalky]; Smell [Musky, fermentation-like, grassy].)", "0 germinated kernels"],
    "nut_borer_on_shell" => ["<b>Nut Borer – On Shell</b> (Small entry hole; frass deposits [fine powdery material close to entry points]; presence of larvae [emerging from shell or inside])", "≤2% damaged <br> (>5% → Reject/hold)"],
    "nut_borer_on_kernel" => ["<b>Nut Borer – On Kernel</b> (Discolouration [Brown, black, or mouldy patches] ; tunnels [Chewed cavities or boreholes]; frass [Brown, gritty insect excrement]; larvae [White to light pink caterpillar]; deformed kernels)", "≤2% damaged <br>(>5% → Reject/hold)"],
    "pest_or_insect_damage" => ["<b>Pest / Insect Damage </b>(Visual)", "≤2% damaged (>5% → Reject/hold)"],
    "presence_of_floaters" => ["Presence of Floaters", "<2–3%"],
    "colour" => ["<b>Colour (shell & kernel)</b> (Discolouration)(Dark kernel Delivery)", "Shell: Brown to greyish-brown; Kernel: Creamy white to light yellow"],
    "nut_size_or_uniformity" => ["Nut Size / Uniformity", "Buyer specification, e.g. 18–22mm"],
    "style_0" => ["Style 0", "Not applicable"],
    "style_1" => ["Style 1", "20mm round hole"],
    "style_1s" => ["Style 1S", "16mm round hole"],
    "style_2" => ["Style 2", "Blend of a minimum of 50% Wholes and the remainder being mainly Halves"],
    "style_3" => ["Style 3", "Blend of a minimum of 15% Wholes and the remainder being mainly Halves"],
    "style_4" => ["Style 4", "14mm round hole"],
    "style_4l" => ["Style 4L", "Not applicable"],
    "style_5" => ["Style 5", "12mm round hole"],
    "style_6" => ["Style 6", "8mm round hole"],
    "style_7" => ["Style 7", "6mm round hole"],
    "dust %" => ["Dust weight", "Not applicable"],
];

// Generate inputs
$inputs = [];
foreach ($rows as $key => $arr) {
    $inputs[$key] = createRowInputs($key);
}

$shell_specs = new input();
$shell_specs->type("text");
$shell_specs->name("shell_specifications");
$shell_specs->id("shell_specifications");
// $shell_specs->placeholder("SPECIFICATIONS");
$shell_specs->style("width: 95%;margin:1vw auto;");

$shell_coa = new input();
$shell_coa->type("text");
$shell_coa->name("shell_coa");
$shell_coa->id("shell_coa");
// $shell_coa->placeholder("COA");
$shell_coa->style("width: 95%;margin:1vw auto;");

$shell_intake_inspection = new input();
$shell_intake_inspection->type("text");
$shell_intake_inspection->name("shell_intake_inspection");
$shell_intake_inspection->id("shell_intake_inspection");
// $shell_intake_inspection->placeholder("INTAKE INSPECTION");
$shell_intake_inspection->style("width: 95%;margin:1vw auto;");

$shell_comment = new input();
$shell_comment->type("text");
$shell_comment->name("shell_comment");
$shell_comment->id("shell_comment");
// $shell_comment->placeholder("COMMENT");
$shell_comment->style("width: 95%;margin:1vw auto;");

$weight_before_drying = new input();
$weight_before_drying->type("text");
$weight_before_drying->name("weight_before_drying");
$weight_before_drying->id("weight_before_drying");
$weight_before_drying->placeholder("WEIGHT BEFORE DRYING (Kg)");
$weight_before_drying->style("width: 95%;margin:1vw auto;");

$weight_after_drying = new input();
$weight_after_drying->type("text");
$weight_after_drying->name("weight_after_drying");
$weight_after_drying->id("weight_after_drying");
$weight_after_drying->placeholder("WEIGHT AFTER DRYING (Kg)");
$weight_after_drying->style("width: 95%;margin:1vw auto;");

$total_moisture_loss = new input();
$total_moisture_loss->type("text");
$total_moisture_loss->name("total_moisture_loss");
$total_moisture_loss->id("total_moisture_loss");
$total_moisture_loss->placeholder("TOTAL MOISTURE LOSS (Kg)");
$total_moisture_loss->style("width: 95%;margin:1vw auto;");

$moisture_loss_percentage = new input();
$moisture_loss_percentage->type("text");
$moisture_loss_percentage->name("total_moisture_loss_percentage");
$moisture_loss_percentage->id("total_moisture_loss_percentage");
$moisture_loss_percentage->placeholder("MOISTURE LOSS %");
$moisture_loss_percentage->style("width: 95%;margin:1vw auto;");

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->onclick("vehicle_check()");

?>

<div class="form_down">
    <h1>Pre Crack Analysis</h1><br>
    <style>
        table,
        th,
        td {
            border: 2px solid black;
            border-collapse: collapse;
            padding: 5px;
        }
    </style>
    <table id="intake_analysis_table" style="width: 90%;">
        <tr style="background-color: #004aad80;">
            <th style="width: 25%;"></th>
            <th style="width: 15%;">Specification</th>
            <th>COA</th>
            <th>INTAKE INSPECTION</th>
            <th>comment</th>
        </tr>
        <tr>
            <td>Weight of product before drying</td>
            <td>
                <?php

                ?>
            </td>
            <td></td>
            <td></td>
            <td>
                <?php
                $weight_before_drying->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Weight of product after drying</td>
            <td>
                <?php

                ?>
            </td>
            <td>
                <?php
                $weight_after_drying->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Total Moisture loss </td>
            <td colspan="2">
                <?php
                $total_moisture_loss->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $moisture_loss_percentage->add();
                ?>
            </td>
        </tr>
        <?php foreach ($rows as $key => $arr) { ?>
            <tr>
                <td><?php echo $arr[0]; ?></td>
                <td><?php echo $arr[1]; ?></td>
                <td><?php $inputs[$key]['coa']->add(); ?></td>
                <td><?php $inputs[$key]['inspection']->add(); ?></td>
                <td><?php $inputs[$key]['comment']->add(); ?></td>
            </tr>
        <?php } ?>
        <tr>
            <td>Shell</td>
            <td>
                <?php
                $shell_specs->add();
                ?>
            </td>
            <td>
                <?php
                $shell_coa->add();
                ?>
            </td>
            <td>
                <?php
                $shell_intake_inspection->add();
                ?>
            </td>
            <td>
                <?php
                $shell_comment->add();
                ?>
            </td>
        </tr>
    </table>

    <?php
    $submit_btn->add();
    ?>
</div>

<?

$intake_analysis_ajax = new js_ajax();
$intake_analysis_ajax->function_name("intake_analysis");
$intake_analysis_ajax->insert("intake_analysis");
$intake_analysis_ajax->on_success("VEHICLE CHECKED");
$intake_analysis_ajax->redirect("");