<?php include "../../root.class.php";
$html = new html();
$db = new db_safeguard();
$html->add_styles_page();
// $html->check_user_type("ADMIN");

//get today's date and add 2 hours to the time
$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

$date_created = new input();
$date_created->type("hidden");
$date_created->name("date_created");
$date_created->id("date_created");
$date_created->placeholder("DATE CREATED");
$date_created->value($current_date);

$product_name_label = new label();
$product_name_label->for("product_name");
$product_name_label->value("PRODUCT NAME");

$product_name = new input();
$product_name->type("text");
$product_name->name("product_name");
$product_name->id("product_name");
$product_name->placeholder("PRODUCT NAME");
$product_name->style("width: 80%;margin:1vw auto;");

$cultivar_label = new label();
$cultivar_label->for("cultivar");
$cultivar_label->value("CULTIVAR");

$cultivar = new input();
$cultivar->type("text");
$cultivar->name("cultivar");
$cultivar->id("cultivar");
$cultivar->placeholder("CULTIVAR");
$cultivar->style("width: 80%;margin:1vw auto;");

$supplier_name_label = new label();
$supplier_name_label->for("supplier_name");
$supplier_name_label->value("SUPPLIER NAME");

$supplier_name = new input();
$supplier_name->type("text");
$supplier_name->name("supplier_name");
$supplier_name->id("supplier_name");
$supplier_name->placeholder("SUPPLIER NAME");
$supplier_name->onchange("createsupplierID()");
$supplier_name->style("width: 80%;margin:1vw auto;");

$supplier_batch_id_label = new label();
$supplier_batch_id_label->for("supplier_batch_id_label");
$supplier_batch_id_label->value("SUPPLIER BATCH ID");

$supplier_batch_no = new input();
$supplier_batch_no->type("text");
$supplier_batch_no->name("supplier_batch_no");
$supplier_batch_no->id("supplier_batch_no");
$supplier_batch_no->placeholder("SUPPLIER BATCH ID");
$supplier_batch_no->style("width: 80%;margin:1vw auto;");
$supplier_batch_no->readonly();


$farm_name = new input();
$farm_name->type("text");
$farm_name->name("farm_name");
$farm_name->id("farm_name");
$farm_name->placeholder("FARM NAME");
$farm_name->style("width: 80%;margin:1vw auto;");

$farm_name_label = new label();
$farm_name_label->for("farm_name");
$farm_name_label->value("FARM NAME");


$crop_year_label = new label();
$crop_year_label->for("crop_year");
$crop_year_label->value("CROP YEAR");

$crop_year = new input();
$crop_year->type("text");
$crop_year->name("crop_year");
$crop_year->id("crop_year");
$crop_year->placeholder("CROP YEAR");
$crop_year->style("width: 80%;margin:1vw auto;");

$delivery_date_label = new label();
$delivery_date_label->for("delivery_date");
$delivery_date_label->value("DELIVERY DATE");

$delivery_date = new input();
$delivery_date->type("datetime-local");
$delivery_date->name("delivery_date");
$delivery_date->id("delivery_date");
$delivery_date->placeholder("DELIVERY DATE");
$delivery_date->style("width: 80%;margin:1vw auto;");

$country_of_origin_label = new label();
$country_of_origin_label->for("country_of_origin");
$country_of_origin_label->value("COUNTRY OF ORIGIN");

$country_of_origin = new input();
$country_of_origin->type("text");
$country_of_origin->name("country_of_origin");
$country_of_origin->id("country_of_origin");
$country_of_origin->placeholder("COUNTRY OF ORIGIN");
$country_of_origin->style("width: 80%;margin:1vw auto;");

$purchase_order_no_label = new label();
$purchase_order_no_label->for("purchase_order_no");
$purchase_order_no_label->value("PURCHASE ORDER NO");

$purchase_order_no = new input();
$purchase_order_no->type("text");
$purchase_order_no->name("purchase_order_no");
$purchase_order_no->id("purchase_order_no");
$purchase_order_no->placeholder("PURCHASE ORDER NO");
$purchase_order_no->style("width: 80%;margin:1vw auto;");

$description_of_package_label = new label();
$description_of_package_label->for("description_of_package");
$description_of_package_label->value("DESCRIPTION OF PACKAGING");

$description_of_package = new input();
$description_of_package->type("text");
$description_of_package->name("description_of_package");
$description_of_package->id("description_of_package");
$description_of_package->placeholder("DESCRIPTION OF PACKAGING");
$description_of_package->style("width: 80%;margin:1vw auto;");

$box_no_label = new label();
$box_no_label->for("box_no");
$box_no_label->value("NUMBER OF BOXES/CONTAINERS");

$box_no = new input();
$box_no->type("number");
$box_no->name("boxes_no");
$box_no->id("boxes_no");
$box_no->placeholder("NUMBER OF BOXES/CONTAINERS");
$box_no->style("width: 80%;margin:1vw auto;");

$box_tracking_no_label = new label();
$box_tracking_no_label->for("box_tracking_no");
$box_tracking_no_label->value("BOX/CONTAINER TRACKING NO");

$box_tracking_no = new input();
$box_tracking_no->type("text");
$box_tracking_no->name("box_tracking_no");
$box_tracking_no->id("box_tracking_no");
$box_tracking_no->placeholder("BOX/CONTAINER TRACKING NO");
$box_tracking_no->style("width: 80%;margin:1vw auto;");

$sampled_box_no_label = new label();
$sampled_box_no_label->for("sampled_box_no");
$sampled_box_no_label->value("NUMBER OF SAMPLED BOXES/CONTAINERS");

$sampled_box_no = new input();
$sampled_box_no->type("number");
$sampled_box_no->name("sampled_box_no");
$sampled_box_no->id("sampled_box_no");
$sampled_box_no->placeholder("NUMBER OF SAMPLED BOXES/CONTAINERS");
$sampled_box_no->style("width: 80%;margin:1vw auto;");

$total_weight_label = new label();
$total_weight_label->for("total_weight");
$total_weight_label->value("TOTAL WEIGHT(Kg)");

$total_weight = new input();
$total_weight->type("number");
$total_weight->name("total_weight");
$total_weight->id("total_weight");
$total_weight->placeholder("TOTAL WEIGHT(Kg)");
$total_weight->style("width: 80%;margin:1vw auto;");

$total_dnis_delivered_label = new label();
$total_dnis_delivered_label->for("total_dnis_delivered");
$total_dnis_delivered_label->value("TOTAL DNIS DELIVERED @ 1.5% k.m (kg)");

$total_dnis_delivered = new input();
$total_dnis_delivered->type("number");
$total_dnis_delivered->name("total_dnis_delivered");
$total_dnis_delivered->id("total_dnis_delivered");
$total_dnis_delivered->placeholder("TOTAL DNIS DELIVERED (Kg)");
$total_dnis_delivered->style("width:80%");

$total_wnis_delivered_label = new label();
$total_wnis_delivered_label->for("total_wnis_delivered");
$total_wnis_delivered_label->value("TOTAL WINS DELIVERED EXCLUDING SMALLS (kg)");

$total_wnis_delivered = new input();
$total_wnis_delivered->type("number");
$total_wnis_delivered->name("total_wnis_delivered");
$total_wnis_delivered->id("total_wnis_delivered");
$total_wnis_delivered->placeholder("TOTAL WINS DELIVERED (Kg)");
$total_wnis_delivered->style("width:80%");

$damaged_boxes_label = new label();
$damaged_boxes_label->for("damaged_boxes");
$damaged_boxes_label->value("NUMBER OF DAMAGED BOXES/SPILLAGE");

$damaged_boxes = new select();
$damaged_boxes->name("damaged_boxes");
$damaged_boxes->id("damaged_boxes");
$damaged_boxes->class("inputs");
$damaged_boxes->add_option("", "damaged_boxes");
$damaged_boxes->add_option("Yes", "Yes");
$damaged_boxes->add_option("No", "No");

$damages_no = new input();
$damages_no->type("number");
$damages_no->name("damages_no");
$damages_no->id("damages_no");
$damages_no->placeholder("NUMBER OF DAMAGED BOXES");
$damages_no->style("width: 80%;margin:1vw auto;");

$comments_label = new label();
$comments_label->for("comments");
$comments_label->value("COMMENTS");

$damages_comment = new input();
$damages_comment->type("text");
$damages_comment->name("comments");
$damages_comment->id("comments");
$damages_comment->placeholder("COMMENTS");
$damages_comment->style("width: 90%;");

$documents_received_confimation_label = new label();
$documents_received_confimation_label->for("documents_received_confimation");
$documents_received_confimation_label->value("DOCUMENTS CONFIRMED TO GOODS RECEIVED");

$documents_received_confimation = new select();
$documents_received_confimation->name("documents_received_confimation");
$documents_received_confimation->id("documents_received_confimation");
$documents_received_confimation->class("inputs");
$documents_received_confimation->add_option("", "documents received confimation");
$documents_received_confimation->add_option("Yes", "Yes");
$documents_received_confimation->add_option("No", "No");

$documents_comment_label = new label();
$documents_comment_label->for("documents_comment");
$documents_comment_label->value("COMMENTS");

$documents_comment = new input();
$documents_comment->type("text");
$documents_comment->name("documents_comment");
$documents_comment->id("documents_comment");
$documents_comment->placeholder("COMMENTS");
$documents_comment->style("width: 90%;");

$purchase_order_option = new select();
$purchase_order_option->name("purchase_order_option");
$purchase_order_option->id("purchase_order_option");
$purchase_order_option->class("inputs");
$purchase_order_option->add_option("", "purchase order");
$purchase_order_option->add_option("Yes", "Yes");
$purchase_order_option->add_option("No", "No");

$supplier_invoice = new select();
$supplier_invoice->name("supplier_invoice");
$supplier_invoice->id("supplier_invoice");
$supplier_invoice->class("inputs");
$supplier_invoice->add_option("", "supplier invoice");
$supplier_invoice->add_option("Yes", "Yes");
$supplier_invoice->add_option("No", "No");

$si_comments = new input();
$si_comments->name('si_comments');
$si_comments->id('si_comments');
$si_comments->placeholder("COMMENTS");
$si_comments->style("width: 90%;");

// vehicle checks

$vehicle_registration_no = new input();
$vehicle_registration_no->type("text");
$vehicle_registration_no->name("vehicle_registration_no");
$vehicle_registration_no->id("vehicle_registration_no");
$vehicle_registration_no->placeholder("VEHICLE REGISTRATION NO");
$vehicle_registration_no->style("width: 80%;margin:1vw auto;");

$vehicle_cleaness = new select();
$vehicle_cleaness->name("vehicle_cleaness");
$vehicle_cleaness->id("vehicle_cleaness");
$vehicle_cleaness->class("inputs");
$vehicle_cleaness->add_option("", "Vehicle State");
$vehicle_cleaness->add_option("Clean", "Clean");
$vehicle_cleaness->add_option("Dirty", "Dirty");
$vehicle_cleaness->style("width: 80%;margin:1vw auto;");

$vehicle_cleaness_comment = new input();
$vehicle_cleaness_comment->name('vehicle_cleaness_comment');
$vehicle_cleaness_comment->id('vehicle_cleaness_comment');
$vehicle_cleaness_comment->placeholder("COMMENT");
$vehicle_cleaness_comment->style("width: 95%;margin:1vw auto;");

$weather_proof = new select();
$weather_proof->name("enclosed_weather_proof");
$weather_proof->id("enclosed_weather_proof");
$weather_proof->class("inputs");
$weather_proof->add_option("", "Enclosed and Weather proof");
$weather_proof->add_option("Yes", "Yes");
$weather_proof->add_option("No", "No");
$weather_proof->style("width: 80%;margin:1vw auto;");

$weather_proof_comment = new input();
$weather_proof_comment->name('weather_proof_comment');
$weather_proof_comment->id('weather_proof_comment');
$weather_proof_comment->placeholder("COMMENT");
$weather_proof_comment->style("width: 95%;margin:1vw auto;");

$seal_state = new select();
$seal_state->name("seal_state");
$seal_state->id("seal_state");
$seal_state->class("inputs");
$seal_state->add_option("", "Seal Unbroken");
$seal_state->add_option("Yes", "Yes");
$seal_state->add_option("No", "No");
$seal_state->style("width: 80%;margin:1vw auto;");

$seal_state_comment = new input();
$seal_state_comment->name('seal_state_comment');
$seal_state_comment->id('seal_state_comment');
$seal_state_comment->placeholder("COMMENT");
$seal_state_comment->style("width: 95%;margin:1vw auto;");

$other_products_present = new select();
$other_products_present->name("other_products_present");
$other_products_present->id("other_products_present");
$other_products_present->class("inputs");
$other_products_present->add_option("", "Other non-food Products in truck");
$other_products_present->add_option("Yes", "Yes");
$other_products_present->add_option("No", "No");
$other_products_present->style("width: 80%;margin:1vw auto;");

$other_products_present_comment = new input();
$other_products_present_comment->name('other_products_present_comment');
$other_products_present_comment->id('other_products_present_comment');
$other_products_present_comment->placeholder("COMMENT");
$other_products_present_comment->style("width: 95%;margin:1vw auto;");

$pallet_condition = new select();
$pallet_condition->name("pallet_condition");
$pallet_condition->id("pallet_condition");
$pallet_condition->class("inputs");
$pallet_condition->add_option("", "Pallet in Clean and in good condition");
$pallet_condition->add_option("Good", "Good");
$pallet_condition->add_option("Bad", "Bad");
$pallet_condition->style("width: 80%;margin:1vw auto;");

$pallet_condition_comment = new input();
$pallet_condition_comment->name('pallet_condition_comment');
$pallet_condition_comment->id('pallet_condition_comment');
$pallet_condition_comment->placeholder("COMMENT");
$pallet_condition_comment->style("width: 95%;margin:1vw auto;");

$infestation_pests = new select();
$infestation_pests->name("infestation_pests_present");
$infestation_pests->id("infestation_pests_present");
$infestation_pests->class("inputs");
$infestation_pests->add_option("", "Signs of Infestation and Pests");
$infestation_pests->add_option("Yes", "Yes");
$infestation_pests->add_option("No", "No");
$infestation_pests->style("width: 80%;margin:1vw auto;");

$infestation_pests_comment = new input();
$infestation_pests_comment->name('infestation_pests_comment');
$infestation_pests_comment->id('infestation_pests_comment');
$infestation_pests_comment->placeholder("COMMENT");
$infestation_pests_comment->style("width: 95%;margin:1vw auto;");

$foreign_objects = new select();
$foreign_objects->name("foreign_objects_present");
$foreign_objects->id("foreign_objects_present");
$foreign_objects->class("inputs");
$foreign_objects->add_option("", "Free from Foreign Objects");
$foreign_objects->add_option("Yes", "Yes");
$foreign_objects->add_option("No", "No");
$foreign_objects->style("width: 80%;margin:1vw auto;");

$foreign_objects_comment = new input();
$foreign_objects_comment->name('foreign_objects_comment');
$foreign_objects_comment->id('foreign_objects_comment');
$foreign_objects_comment->placeholder("COMMENT");
$foreign_objects_comment->style("width: 95%;margin:1vw auto;");

$odours_present = new select();
$odours_present->name("odours_present");
$odours_present->id("odours_present");
$odours_present->class("inputs");
$odours_present->add_option("", "Free from Odours");
$odours_present->add_option("Yes", "Yes");
$odours_present->add_option("No", "No");
$odours_present->style("width: 80%;margin:1vw auto;");

$purchase_order_received = new select();
$purchase_order_received->name("purchase_order_received");
$purchase_order_received->id("purchase_order_received");
$purchase_order_received->class("inputs");
$purchase_order_received->add_option("", "Purchase Order Received");
$purchase_order_received->add_option("Yes", "Yes");
$purchase_order_received->add_option("No", "No");
$purchase_order_received->style("width: 80%;margin:1vw auto;");

$purchase_order_received_comment = new input();
$purchase_order_received_comment->name('purchase_order_received_comment');
$purchase_order_received_comment->id('purchase_order_received_comment');
$purchase_order_received_comment->placeholder("COMMENT");
$purchase_order_received_comment->style("width: 95%;margin:1vw auto;");

$supplier_invoice_received = new select();
$supplier_invoice_received->name("supplier_invoice_received");
$supplier_invoice_received->id("supplier_invoice_received");
$supplier_invoice_received->class("inputs");
$supplier_invoice_received->add_option("", "Supplier Invoice Received");
$supplier_invoice_received->add_option("Yes", "Yes");
$supplier_invoice_received->add_option("No", "No");
$supplier_invoice_received->style("width: 80%;margin:1vw auto;");

$supplier_invoice_received_comment = new input();
$supplier_invoice_received_comment->name('supplier_invoice_received_comment');
$supplier_invoice_received_comment->id('supplier_invoice_received_comment');
$supplier_invoice_received_comment->placeholder("COMMENT");
$supplier_invoice_received_comment->style("width: 95%;margin:1vw auto;");

$coa_received = new select();
$coa_received->name("coa_received");
$coa_received->id("coa_received");
$coa_received->class("inputs");
$coa_received->add_option("", "COA Received");
$coa_received->add_option("Yes", "Yes");
$coa_received->add_option("No", "No");
$coa_received->style("width: 80%;margin:1vw auto;");

$coa_received_comment = new input();
$coa_received_comment->name('coa_received_comment');
$coa_received_comment->id('coa_received_comment');
$coa_received_comment->placeholder("COMMENT");
$coa_received_comment->style("width: 95%;margin:1vw auto;");

$truck_clearance_certificate = new select();
$truck_clearance_certificate->name("truck_clearance_certificate");
$truck_clearance_certificate->id("truck_clearance_certificate");
$truck_clearance_certificate->class("inputs");
$truck_clearance_certificate->add_option("", "Truck Clearance Certificate Received");
$truck_clearance_certificate->add_option("Yes", "Yes");
$truck_clearance_certificate->add_option("No", "No");
$truck_clearance_certificate->style("width: 80%;margin:1vw auto;");

$truck_clearance_certificate_comment = new input();
$truck_clearance_certificate_comment->name('truck_clearance_certificate_comment');
$truck_clearance_certificate_comment->id('truck_clearance_certificate_comment');
$truck_clearance_certificate_comment->placeholder("COMMENT");
$truck_clearance_certificate_comment->style("width: 95%;margin:1vw auto;");

// initail quality inspection

$insect_infestation_coa = new input();
$insect_infestation_coa->name('insect_infestation_coa');
$insect_infestation_coa->id('insect_infestation_coa');
$insect_infestation_coa->placeholder("COA");
$insect_infestation_coa->style("margin:1vw auto;");

$insect_infestation_evaluation = new input();
$insect_infestation_evaluation->name('insect_infestation_evaluation');
$insect_infestation_evaluation->id('insect_infestation_evaluation');
$insect_infestation_evaluation->placeholder("Evaluation");
$insect_infestation_evaluation->style("margin:1vw auto;");

$insect_infestation_coa_comment = new input();
$insect_infestation_coa_comment->name('insect_infestation_coa_comment');
$insect_infestation_coa_comment->id('insect_infestation_coa_comment');
$insect_infestation_coa_comment->placeholder("COMMENT");
$insect_infestation_coa_comment->style("width: 95%;margin:1vw auto;");

$mould_rot_coa = new input();
$mould_rot_coa->name('mould_rot_coa');
$mould_rot_coa->id('mould_rot_coa');
$mould_rot_coa->placeholder(" COA");
$mould_rot_coa->style("width: 80%;margin:1vw auto;");

$mould_rot_evaluation = new input();
$mould_rot_evaluation->name('mould_rot_evaluation');
$mould_rot_evaluation->id('mould_rot_evaluation');
$mould_rot_evaluation->placeholder("Evaluation");
$mould_rot_evaluation->style("width: 80%;margin:1vw auto;");

$mould_rot_comment = new input();
$mould_rot_comment->name('mould_rot_comment');
$mould_rot_comment->id('mould_rot_comment');
$mould_rot_comment->placeholder("COMMENT");
$mould_rot_comment->style("width: 80%;margin:1vw auto;");

$foreign_matter_coa = new input();
$foreign_matter_coa->name('foreign_matter_coa');
$foreign_matter_coa->id('foreign_matter_coa');
$foreign_matter_coa->placeholder(" COA");
$foreign_matter_coa->style("width: 80%;margin:1vw auto;");

$foreign_matter_evaluation = new input();
$foreign_matter_evaluation->name('foreign_matter_evaluation');
$foreign_matter_evaluation->id('foreign_matter_evaluation');
$foreign_matter_evaluation->placeholder("Evaluation");
$foreign_matter_evaluation->style("width: 80%;margin:1vw auto;");

$foreign_matter_comment = new input();
$foreign_matter_comment->name('foreign_matter_comment');
$foreign_matter_comment->id('foreign_matter_comment');
$foreign_matter_comment->placeholder("COMMENT");
$foreign_matter_comment->style("width: 80%;margin:1vw auto;");

$moisture_coa = new input();
$moisture_coa->name('moisture_coa');
$moisture_coa->id('moisture_coa');
$moisture_coa->placeholder(" COA");
$moisture_coa->style("width: 80%;margin:1vw auto;");

$moisture_evaluation = new input();
$moisture_evaluation->name('moisture_evaluation');
$moisture_evaluation->id('moisture_evaluation');
$moisture_evaluation->placeholder("Evaluation");
$moisture_evaluation->style("width: 80%;margin:1vw auto;");

$moisture_comment = new input();
$moisture_comment->name('moisture_comment');
$moisture_comment->id('moisture_comment');
$moisture_comment->placeholder("COMMENT");
$moisture_comment->style("width: 80%;margin:1vw auto;");

$texture_specs = new input();
$texture_specs->name('texture_specifications');
$texture_specs->id('texture_specifications');
$texture_specs->placeholder("Specifications");
$texture_specs->style("width: 100%;margin:1vw auto;");

$texture_coa = new input();
$texture_coa->name('texture_coa');
$texture_coa->id('texture_coa');
$texture_coa->placeholder(" COA");
$texture_coa->style("width: 80%;margin:1vw auto;");

$texture_evaluation = new input();
$texture_evaluation->name('texture_evaluation');
$texture_evaluation->id('texture_evaluation');
$texture_evaluation->placeholder("Evaluation");
$texture_evaluation->style("width: 80%;margin:1vw auto;");

$texture_comment = new input();
$texture_comment->name('_comment');
$texture_comment->id('_comment');
$texture_comment->placeholder("COMMENT");
$texture_comment->style("width: 80%;margin:1vw auto;");

$physical_contamination_coa = new input();
$physical_contamination_coa->name('physical_contamination_coa');
$physical_contamination_coa->id('physical_contamination_coa');
$physical_contamination_coa->placeholder(" COA");
$physical_contamination_coa->style("width: 80%;margin:1vw auto;");

$physical_contamination_evaluation = new input();
$physical_contamination_evaluation->name('physical_contamination_evaluation');
$physical_contamination_evaluation->id('physical_contamination_evaluation');
$physical_contamination_evaluation->placeholder("Evaluation");
$physical_contamination_evaluation->style("width: 80%;margin:1vw auto;");

$physical_contamination_comment = new input();
$physical_contamination_comment->name('physical_contamination_comment');
$physical_contamination_comment->id('physical_contamination_comment');
$physical_contamination_comment->placeholder("COMMENT");
$physical_contamination_comment->style("width: 80%;margin:1vw auto;");

$infestation_present = new select();
$infestation_present->name("infestation_present");
$infestation_present->id("infestation_present");
$infestation_present->class("inputs");
$infestation_present->add_option("", "Infestation Present");
$infestation_present->add_option("Yes", "Yes");
$infestation_present->add_option("No", "No");
$infestation_present->style("width: 80%;margin:1vw auto;");

$infestation_comment = new input();
$infestation_comment->name('infestation_comment');
$infestation_comment->id('infestation_comment');
$infestation_comment->placeholder("COMMENT");
$infestation_comment->style("width: 95%;margin:1vw auto;");

$foreign_matter_present = new select();
$foreign_matter_present->name("foreign_matter_present");
$foreign_matter_present->id("foreign_matter_present");
$foreign_matter_present->class("inputs");
$foreign_matter_present->add_option("", "Foreign Matter Present");
$foreign_matter_present->add_option("Yes", "Yes");
$foreign_matter_present->add_option("No", "No");
$foreign_matter_present->style("width: 80%;margin:1vw auto;");

$matter_comment = new input();
$matter_comment->name('matter_comment');
$matter_comment->id('matter_comment');
$matter_comment->placeholder("COMMENT");
$matter_comment->style("width: 95%;margin:1vw auto;");

$inspector_qc_name = new input();
$inspector_qc_name->name('inspector_qc_name');
$inspector_qc_name->id('inspector_qc_name');
$inspector_qc_name->placeholder("Intake Inspector/ QC Name & Surname");
$inspector_qc_name->style("width: 95%;margin:1vw auto;");

$driver_name = new input();
$driver_name->name('driver_name');
$driver_name->id('driver_name');
$driver_name->placeholder("Delivery Vehicle Driver Name");
$driver_name->style("width: 95%;margin:1vw auto;");

//intake analysis evaluation 

function createInput($name)
{
    $input = new input();
    $input->type("text");
    $input->name($name);
    $input->id($name);
    $input->style("width: 95%;margin:1vw auto;");
    return $input;
}

// Row generator
function createRowInputs($base_name)
{
    return [
        "coa" => createInput($base_name . "_coa"),
        "inspection" => createInput($base_name . "_intake_inspection"),
        "comment" => createInput($base_name . "_comment")
    ];
}

// Array: key => [spec name, limit/specification]
$rows = [
    "free_fatty_acids" => ["Free Fatty Acids", "<0.5%"],
    "peroxide_value" => ["Peroxide Value", "<3 meq/kg OIL"],
    "moisture_content" => ["Moisture Content", "≤15% <br> (>13.5% → Reject or Dry Immediately)"],
    "nut_count_and_kernel_recovery" => ["<b>Nut Count & Kernel Recovery</b> (Cracking & sieving)(Premium Kernel Delivered)", "Min 25% Kernel Recovery <br> (Alert <20%)"],
    "immature_nuts" => ["<b>Immature Nuts</b> (Manual crack-out)", "≤5% <br> (>10% → Reject or Downgrade)"],
    "mould_internal_or_old" => ["<b>Mould (internal)/Old</b> (Crack-out & visual exam)", "≤1% kernels with internal mould <br> (>2% → Reject or hold)"],
    "early_stinkbug" => ["<b>Early Stinkbug </b>(Small pale spot or brown lesion on the kernel surface; Surface texture might be slightly roughened or wrinkled)", "≤2% by weight or ≤3 kernels"],
    "late_stinkbug" => ["<b>Late Stinkbug</b> (Large black or dark brown patches on the kernel; Visible feeding scars or discoloured streaks can appear across the kernel)", "0% — Not permitted"],
    "germination" => ["<b>Germination</b> (Radicle emergence; split kernel [open at the hilum or base]; discolouration [dull white/ translucent]; texture change [rubbery, soft, chalky]; Smell [Musky, fermentation-like, grassy].)", "0 germinated kernels"],
    "nut_borer_on_shell" => ["<b>Nut Borer – On Shell</b> (Small entry hole; frass deposits [fine powdery material close to entry points]; presence of larvae [emerging from shell or inside])", "≤2% damaged <br> (>5% → Reject/hold)"],
    "nut_borer_on_kernel" => ["<b>Nut Borer – On Kernel</b> (Discolouration [Brown, black, or mouldy patches] ; tunnels [Chewed cavities or boreholes]; frass [Brown, gritty insect excrement]; larvae [White to light pink caterpillar]; deformed kernels)", "≤2% damaged <br>(>5% → Reject/hold)"],
    "aflatoxin" => ["<b>Aflatoxin</b> (refer to COA)(B1, B2, G1, G2)", "<10 ppb total aflatoxins <br> (>10 ppb → Reject or quarantine)"],
    "pest_or_insect_damage" => ["<b>Pest / Insect Damage </b>(Visual)", "≤2% damaged (>5% → Reject/hold)"],
    "presence_of_floaters" => ["Presence of Floaters", "<2–3%"],
    "colour" => ["<b>Colour (shell & kernel)</b> (Discolouration)(Dark kernel Delivery)", "Shell: Brown to greyish-brown; Kernel: Creamy white to light yellow"],
    "smell_or_odour" => ["Smell / Odour", "No sour, rancid, or mouldy smell"],
    "nut_size_or_uniformity" => ["Nut Size / Uniformity", "Buyer specification, e.g. 18–22mm"],
    "style_0" => ["Style 0", "Not applicable"],
    "style_1" => ["Style 1", "20mm round hole"],
    "style_1s" => ["Style 1S", "16mm round hole"],
    "style_2" => ["Style 2", "Blend of a minimum of 50% Wholes and the remainder being mainly Halves"],
    "style_3" => ["Style 3", "Blend of a minimum of 15% Wholes and the remainder being mainly Halves"],
    "style_4" => ["Style 4", "14mm round hole"],
    "style_4l" => ["Style 4L", "Not applicable"],
    "style_5" => ["Style 5", "12mm round hole"],
    "style_6" => ["Style 6", "8mm round hole"],
    "style_7" => ["Style 7", "6mm round hole"],
    "dust %" => ["Dust %", "Not applicable"],
];

// Generate inputs
$inputs = [];
foreach ($rows as $key => $arr) {
    $inputs[$key] = createRowInputs($key);
}

$shell_specs = new input();
$shell_specs->type("text");
$shell_specs->name("shell_specifications");
$shell_specs->id("shell_specifications");
// $shell_specs->placeholder("SPECIFICATIONS");
$shell_specs->style("width: 95%;margin:1vw auto;");

$shell_coa = new input();
$shell_coa->type("text");
$shell_coa->name("shell_coa");
$shell_coa->id("shell_coa");
// $shell_coa->placeholder("COA");
$shell_coa->style("width: 95%;margin:1vw auto;");

$shell_intake_inspection = new input();
$shell_intake_inspection->type("text");
$shell_intake_inspection->name("shell_intake_inspection");
$shell_intake_inspection->id("shell_intake_inspection");
// $shell_intake_inspection->placeholder("INTAKE INSPECTION");
$shell_intake_inspection->style("width: 95%;margin:1vw auto;");

$shell_comment = new input();
$shell_comment->type("text");
$shell_comment->name("shell_comment");
$shell_comment->id("shell_comment");
// $shell_comment->placeholder("COMMENT");
$shell_comment->style("width: 95%;margin:1vw auto;");

$weight_before_drying = new input();
$weight_before_drying->type("text");
$weight_before_drying->name("weight_before_drying");
$weight_before_drying->id("weight_before_drying");
$weight_before_drying->placeholder("WEIGHT BEFORE DRYING (Kg)");
$weight_before_drying->style("width: 95%;margin:1vw auto;");

$weight_after_drying = new input();
$weight_after_drying->type("text");
$weight_after_drying->name("weight_after_drying");
$weight_after_drying->id("weight_after_drying");
$weight_after_drying->placeholder("WEIGHT AFTER DRYING (Kg)");
$weight_after_drying->style("width: 95%;margin:1vw auto;");

$total_moisture_loss = new input();
$total_moisture_loss->type("text");
$total_moisture_loss->name("total_moisture_loss");
$total_moisture_loss->id("total_moisture_loss");
$total_moisture_loss->placeholder("TOTAL MOISTURE LOSS (Kg)");
$total_moisture_loss->style("width: 95%;margin:1vw auto;");

$moisture_loss_percentage = new input();
$moisture_loss_percentage->type("text");
$moisture_loss_percentage->name("total_moisture_loss_percentage");
$moisture_loss_percentage->id("total_moisture_loss_percentage");
$moisture_loss_percentage->placeholder("MOISTURE LOSS %");
$moisture_loss_percentage->style("width: 95%;margin:1vw auto;");

// submit button

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->onclick("pre_intake_inspection");

?>

<div class="form_down">
    <h1>PRE-INTAKE INSPECTION</h1>
    <br>

    <style>
        table,
        th,
        td {
            border: 2px solid black;
            border-collapse: collapse;
            padding: 5px;
        }
    </style>

    <table id="order_details_table" style="width: 90%;">
        <tr style="background-color:#004aad80;">
            <th colspan="3">
                <h3>ORDER DETAILS</h3>
            </th>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $product_name_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $product_name->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $cultivar_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $cultivar->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $supplier_name_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $supplier_name->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $supplier_batch_id_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $supplier_batch_no->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $farm_name_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $farm_name->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $crop_year_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $crop_year->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $delivery_date_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $delivery_date->add();
                ?>
            </td>
        </tr>
        <tr>
            <td width="50%">
                <?php
                $country_of_origin_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $country_of_origin->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $purchase_order_no_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $purchase_order_no->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $description_of_package_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $description_of_package->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $box_no_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $box_no->add()
                    ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $box_tracking_no_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $box_tracking_no->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $sampled_box_no_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $sampled_box_no->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $total_weight_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $total_weight->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $total_dnis_delivered_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $total_dnis_delivered->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $total_wnis_delivered_label->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $total_wnis_delivered->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $damaged_boxes_label->add();
                ?>
            </td>
            <td>
                <?php
                $damaged_boxes->add();
                ?>
            </td>
            <td>
                <?php
                $damages_no->add();
                $damages_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td style="width: 50%;">
                <?php
                $documents_received_confimation_label->add();
                ?>
            </td>
            <td>
                <?php
                $documents_received_confimation->add();
                ?>
            </td>
            <td>
                <?php
                $documents_comment_label->add();
                $documents_comment->add();
                ?>
            </td>
        </tr>
    </table>

    <br><br>

    <table id="vehicle_check_table" style="width: 90%;">
        <tr>
            <th colspan="4" style="background-color: #004aad80;">
                <h3>CONTAINER/ TRUCK /VEHICLE CHECKS</h3>
            </th>
        </tr>
        <tr>
            <td>Delivery Vehicle Registration number:</td>
            <td colspan="3">
                <?php
                $vehicle_registration_no->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Truck / Vehicle:</td>
            <td>
                <?php
                $vehicle_cleaness->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $vehicle_cleaness_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Fully Enclosed and weather-proof:</td>
            <td>
                <?php
                $weather_proof->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $weather_proof_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Container Seal Unbroken:</td>
            <td>
                <?php
                $seal_state->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $seal_state_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Other non-food products</td>
            <td>
                <?php
                $other_products_present->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $other_products_present_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Pallet in clean and in good condition</td>
            <td>
                <?php
                $pallet_condition->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $pallet_condition_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Signs of Infestation and pests</td>
            <td>
                <?php
                $infestation_pests->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $infestation_pests_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Free form foreign objects</td>
            <td>
                <?php
                $foreign_objects->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $foreign_objects_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Free from odours</td>
            <td>
                <?php
                $odours_present->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $other_products_present_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Docummentation received</td>
            <td>
                <div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $purchase_order_received->add();
                        ?>
                    </div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $supplier_invoice_received->add();
                        ?>
                    </div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $coa_received->add();
                        ?>
                    </div>
                    <div>
                        <?php
                        $truck_clearance_certificate->add();
                        ?>
                    </div>
                </div>
            </td>
            <td>
                <div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $purchase_order_received_comment->add();
                        ?>
                    </div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $supplier_invoice_received_comment->add();
                        ?>
                    </div>
                    <div style="border-bottom: 2px solid black;">
                        <?php
                        $coa_received_comment->add();
                        ?>
                    </div>
                    <div>
                        <?php
                        $truck_clearance_certificate_comment->add();
                        ?>
                    </div>
                </div>
            </td>
        </tr>
    </table>

    <br><br>

    <table id="quality_inspection_table" style="width: 90%;">
        <tr>
            <th colspan="5" style="background-color: #004aad80;">
                <h3>INITIAL QUALITY INSPECTION BEFORE OFF-LOAD</h3>
            </th>
        </tr>
        <tr>
            <td></td>
            <td>Specification</td>
            <td>COA</td>
            <td>Intake Evaluation</td>
            <td>Comment</td>
        </tr>
        <tr>
            <td>Visible Insect Infestation</td>
            <td>Non live insects; minimal webbing</td>
            <td>
                <?php
                $insect_infestation_coa->add();
                ?>
            </td>
            <td>
                <?php
                $insect_infestation_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $insect_infestation_coa_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Mould/ Rot</td>
            <td>≤0.5% by volume</td>
            <td>
                <?php
                $mould_rot_coa->add();
                ?>
            </td>
            <td>
                <?php
                $mould_rot_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $mould_rot_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Foreign Matter (leaves, sticks, stones)</td>
            <td>≤0.5% by volume</td>
            <td>
                <?php
                $foreign_matter_coa->add();
                ?>
            </td>
            <td>
                <?php
                $foreign_matter_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $foreign_matter_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Moisture (shell feel)</td>
            <td>Dry to touch</td>
            <td>
                <?php
                $moisture_coa->add();
                ?>
            </td>
            <td>
                <?php
                $moisture_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $moisture_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Texture</td>
            <td>
                <?php
                $texture_specs->add();
                ?>
            </td>
            <td>
                <?php
                $texture_coa->add();
                ?>
            </td>
            <td>
                <?php
                $texture_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $texture_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Physical Contamination </td>
            <td>Non-Visible</td>
            <td>
                <?php
                $physical_contamination_coa->add();
                ?>
            </td>
            <td>
                <?php
                $physical_contamination_evaluation->add();
                ?>
            </td>
            <td>
                <?php
                $physical_contamination_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>
                Infestation
            </td>
            <td colspan="2">
                <?php
                $infestation_present->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $infestation_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>
                Foreign matter
            </td>
            <td colspan="2">
                <?php
                $foreign_matter_present->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $matter_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>
                Intake inspector/ QC Name & Signature
            </td>
            <td colspan="2">
                <?php
                $inspector_qc_name->add();
                ?>
            </td>
            <td colspan="2">
                <canvas id="inspector_qc_signature" name="inspector_qc_signature" class="signature-pad" width=400
                    height=100 style='background-color:lightgrey;border-radius:20px;'></canvas>
            </td>
        </tr>
        <tr>
            <td>
                Delivery Vehicle Driver Name & Signature
            </td>
            <td colspan="2">
                <?php
                $driver_name->add();
                ?>
            </td>
            <td colspan="2">
                <canvas id="driver_signature" name="driver_signature" class="signature-pad" width=400 height=100
                    style='background-color:lightgrey;border-radius:20px;'></canvas>
            </td>
        </tr>
    </table>

    <br><br>

    <p><b>Use an appropriate sampling tool (e.g. trier or probe) to collect representative sample (minimum 6 kg per
            load). <br>Composite sample for further testing.</b></p>
    <table id="intake_analysis_table" style="width: 90%;">
        <!-- <tr>
            <th colspan="5" style="background-color: #004aad80;">
                <h3>SECTION C: INTAKE ANALYSIS / EVALUATION</h3>
            </th>
        </tr> -->
        <tr style="background-color: #004aad80;">
            <th style="width: 25%;"></th>
            <th style="width: 15%;">Specification</th>
            <th>COA</th>
            <th>Intake Inspection</th>
            <th>Comment</th>
        </tr>
        <?php foreach ($rows as $key => $arr) { ?>
            <tr>
                <td><?php echo $arr[0]; ?></td>
                <td><?php echo $arr[1]; ?></td>
                <td><?php $inputs[$key]['coa']->add(); ?></td>
                <td><?php $inputs[$key]['inspection']->add(); ?></td>
                <td><?php $inputs[$key]['comment']->add(); ?></td>
            </tr>
        <?php } ?>
        <tr>
            <td>Shell</td>
            <td>
                <?php
                $shell_specs->add();
                ?>
            </td>
            <td>
                <?php
                $shell_coa->add();
                ?>
            </td>
            <td>
                <?php
                $shell_intake_inspection->add();
                ?>
            </td>
            <td>
                <?php
                $shell_comment->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Weight of product before drying</td>
            <td colspan="2">
                <?php

                ?>
            </td>
            <td colspan="2">
                <?php
                $weight_before_drying->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Weight of product after drying</td>
            <td colspan="2">
                <?php

                ?>
            </td>
            <td colspan="2">
                <?php
                $weight_after_drying->add();
                ?>
            </td>
        </tr>
        <tr>
            <td>Total Moisture loss </td>
            <td colspan="2">
                <?php
                $total_moisture_loss->add();
                ?>
            </td>
            <td colspan="2">
                <?php
                $moisture_loss_percentage->add();
                ?>
            </td>
        </tr>
    </table>
    <h2>NEW</h2>
    <canvas id="signature_pad" class="signature-pad" width=500 height=300
        style='background-color:lightgrey;border-radius:20px;'></canvas><br>
    <?php
    $submit_btn->add();
    ?>

    <?php

    ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>

<script>
    var inspector_qc_canvas = document.getElementById('inspector_qc_signature');
    var inspector_qc_pad = new SignaturePad(inspector_qc_canvas);

    var driver_canvas = document.getElementById('driver_signature');
    var driver_pad = new SignaturePad(driver_canvas);

    document.getElementById('save_signature').addEventListener('click', function () {
        if (inspector_qc_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = inspector_qc_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'inspector_qc');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../receive/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    document.getElementById('save_signature').addEventListener('click', function () {
        if (driver_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = driver_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'driver');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../receive/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

    function dataURLToBlob(dataURL) {
        var binary = atob(dataURL.split(',')[1]);
        var array = [];
        for (var i = 0; i < binary.length; i++) {
            array.push(binary.charCodeAt(i));
        }
        return new Blob([new Uint8Array(array)], {
            type: dataURL.split(',')[0].split(':')[1].split(';')[0]
        });
    }
</script>

<?php

$pre_take_ajax = new js_ajax();
$pre_take_ajax->function_name("pre_intake_inspection");
$pre_take_ajax->insert("");
$pre_take_ajax->on_success("");
$pre_take_ajax->redirect("");