<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$supplier_batch_id_label = new label();
$supplier_batch_id_label->for("supplier_batch_id_label");
$supplier_batch_id_label->value("SUPPLIER BATCH NO");

$supplier_batch_no = new input();
$supplier_batch_no->type('text');
$supplier_batch_no->name('supplier_batch_no');
$supplier_batch_no->id('supplier_batch_no');
$supplier_batch_no->readonly();

$sample_received_date_label = new label();
$sample_received_date_label->for('sample_received_date');
$sample_received_date_label->value('SAMPLE RECEIVED DATE');

$sample_received_date = new input();
$sample_received_date->type('datetime-local');
$sample_received_date->name('sample_received_date');
$sample_received_date->id('sample_received_date');

$quantity_of_samples_label = new label();
$quantity_of_samples_label->for('quantity_of_samples');
$quantity_of_samples_label->value('QUANTITY OF SAMPLES RECEIVED');

$quantity_of_samples = new input();
$quantity_of_samples->type('number');
$quantity_of_samples->name('quantity_of_samples');
$quantity_of_samples->id('quantity_of_samples');
$quantity_of_samples->placeholder('Quantity of Samples Received');
$quantity_of_samples->onchange("sample_weights();");

$weight_of_sample_label = new label();
$weight_of_sample_label->for('weight_of_sample');
$weight_of_sample_label->value('WEIGHT OF SAMPLE RECEIVED');

$weight_of_sample = new input();
$weight_of_sample->type('hidden');
$weight_of_sample->name('weight_of_sample');
$weight_of_sample->id('weight_of_sample');
$weight_of_sample->placeholder('Weight of Sample Received');

$sample_sent_label = new label();
$sample_sent_label->for('sample_sent');
$sample_sent_label->value('SAMPLE SENT DATE');

$sample_sent = new input();
$sample_sent->type('datetime-local');
$sample_sent->name('sample_sent');
$sample_sent->id('sample_sent');

$lab_name_label = new label();
$lab_name_label->for('lab_name');
$lab_name_label->value('LAB NAME');

$lab_name = new select();
$lab_name->name('lab_name');
$lab_name->id('lab_name');
$lab_name->add_option('', 'Select Lab');
$lab_name->add_option('Lab 1', 'Lab 1');
$lab_name->add_option('Lab 2', 'Lab 2');
$lab_name->add_option('Lab 3', 'Lab 3');
$lab_name->add_option('Lab 4', 'Lab 4');
$lab_name->add_option('Lab 5', 'Lab 5');
$lab_name->add_option('Lab 6', 'Lab 6');
$lab_name->add_option('Lab 7', 'Lab 7');

$accreditation_no_label = new label();
$accreditation_no_label->for('accreditation_no');
$accreditation_no_label->value('ACCREDITATION NO');

$accreditation_no = new input();
$accreditation_no->type('text');
$accreditation_no->name('accreditation_no');
$accreditation_no->id('accreditation_no');
$accreditation_no->readonly();

$contact_person_label = new label();
$contact_person_label->for('contact_person');
$contact_person_label->value('CONTACT PERSON');

$contact_person = new input();
$contact_person->type('text');
$contact_person->name('contact_person');
$contact_person->id('contact_person');
$contact_person->style('width: 100%;');
$contact_person->readonly();

$email_label = new label();
$email_label->for('email');
$email_label->value('EMAIL');

$email = new input();
$email->type('email');
$email->name('email');
$email->id('email');
$email->style('width: 100%;');
$email->readonly();

$phone_label = new label();
$phone_label->for('phone');
$phone_label->value('PHONE NUMBER');

$phone = new input();
$phone->type('tel');
$phone->name('phone');
$phone->id('phone');
$phone->style('width: 100%;');
$phone->readonly();

$eta_date_label = new label();
$eta_date_label->for('eta_date');
$eta_date_label->value('ETA DATE');

$eta_date = new input();
$eta_date->type('datetime-local');
$eta_date->name('eta_date');
$eta_date->id('eta_date');

$submit_btn = new button();
$submit_btn->value("ADD");
$submit_btn->onclick("submit_sample();");
?>

<div class="form_down">
    <h1>QA Sample Management</h1>
    <?php
    $supplier_batch_id_label->add();
    $supplier_batch_no->add();
    $sample_received_date_label->add();
    $sample_received_date->add();
    $quantity_of_samples_label->add();
    $quantity_of_samples->add();
    ?>

    <div id="number_of_samples"></div>

    <?php
    $weight_of_sample->add();
    ?>

    <div style="display: flex; flex-direction: row; width: 60%; justify-content: space-evenly;">
        <div style="display: flex; flex-direction: column;">
            <?php
            $sample_sent_label->add();
            $sample_sent->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $lab_name_label->add();
            $lab_name->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $accreditation_no_label->add();
            $accreditation_no->add();
            ?>
        </div>
    </div>

    <div style="display: flex; flex-direction: row; width: 60%; justify-content: space-evenly;">
        <div style="display: flex; flex-direction: column;">
            <?php
            $contact_person_label->add();
            $contact_person->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $phone_label->add();
            $phone->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $email_label->add();
            $email->add();
            ?>
        </div>
    </div>

    <?php
    $eta_date_label->add();
    $eta_date->add();

    $submit_btn->add();
    ?>
</div>

<script>
    function sample_weights() {
        var sample_no = parseInt(document.getElementById("quantity_of_samples").value);
        var samples = document.getElementById("number_of_samples");
        samples.innerHTML = "";

        var heading = document.createElement("h2");
        heading.innerHTML = "SAMPLE WEIGHTS";
        samples.appendChild(heading);

        for (var i = 0; i < sample_no; i++) {
            var div = document.createElement("div");
            div.style.display = "flex";
            div.style.flexDirection = "column";
            div.style.alignItems = "center";

            var label = document.createElement("label");
            label.setAttribute("for", "sample_weight_" + i);
            label.innerHTML = "SAMPLE WEIGHT " + (i + 1) + " (Kg)";

            var input = document.createElement("input");
            input.type = "number";
            input.className = "inputs";
            input.name = "sample_weight_" + i;
            input.id = "sample_weight_" + i;
            input.placeholder = "SAMPLE WEIGHT " + (i + 1);
            input.onchange = all_weights;

            div.appendChild(label);
            div.appendChild(input);
            samples.appendChild(div);
        }
    }

    function all_weights() {
        var sample_no = parseInt(document.getElementById("quantity_of_samples").value);
        var weightList = [];

        for (var i = 0; i < sample_no; i++) {
            var input = document.getElementsByName("sample_weight_" + i)[0];
            if (input && input.value) {
                weightList.push(input.value);
            }
        }

        document.getElementById("weight_of_sample").value = weightList.join(",");
    }
</script>

<?php

$ajax = new js_ajax();
$ajax->function_name("submit_sample");
$ajax->submit_btn_id("submit");
$ajax->insert("qa_sample_management");
$ajax->on_success("SAMPLE SUBMITTED SUCCESSFULLY");
// $ajax->redirect("delivery_request.pdf.php?supplier_batch_no=$supplier_batch_id");
