<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
// $html->check_user_type("ADMIN");

$booking_res = $db->query("bookings", "SELECT booking_no FROM bookings ORDER BY record_id DESC LIMIT 1");

if ($booking_res->num_rows > 0) {
    $row = $booking_res->fetch_assoc();
    $last_id = (int)substr($row['booking_no'], -3); // get last 3 digits
    $booking = "BT" . str_pad($last_id + 1, 3, '0', STR_PAD_LEFT);
} else {
    $booking = "BT001";
}

$booking_label = new label();
$booking_label->for("booking_no_label");
$booking_label->value("Booking No");

$booking_no = new input();
$booking_no->type("text");
$booking_no->name("booking_no");
$booking_no->id("booking_no");
$booking_no->value($booking);
$booking_no->readonly();

$date_booked_label = new label();
$date_booked_label->for("date_booked");
$date_booked_label->value("Booking Date");

$date_booked = new input();
$date_booked->type("datetime-local");
$date_booked->name("date_booked");
$date_booked->id("date_booked");

$date_done = new input();
$date_done->type("hidden");
$date_done->name("date_done");
$date_done->id("date_done");
$date_done->value(0);

$notes = new input();
$notes->type("hidden");
$notes->name("notes");
$notes->id("notes");
$notes->value(0);

$date_created = new input();
$date_created->type("hidden");
$date_created->name("date_created");
$date_created->id("date_created");
$date_created->value(0);

$assigned_to_label = new label();
$assigned_to_label->for("assigned_to");
$assigned_to_label->value("Assigned To");

$assigned_to = new input();
$assigned_to->type("text");
$assigned_to->name("assigned_to");
$assigned_to->id("assigned_to");
$assigned_to->placeholder("Assigned To");

$test_id_label = new label();
$test_id_label->for("test_id");
$test_id_label->value("Test");


$test_id = new select();
$test_id->name("test_id");
$test_id->id("test_id");
$test_id->fill_from_db("tests", "record_id", "name");

$status = new input();
$status->type("hidden");
$status->name("status");
$status->id("status");
$status->value("ATTEMPT");

$submit_btn = new button();
$submit_btn->value("ADD BOOKING");
$submit_btn->onclick("add_booking()");

?>

<div class="form_down">
    <h1>ADD BOOKING</h1>
    <?php
    $booking_label->add();
    $booking_no->add();
    $date_booked_label->add();
    $date_booked->add();
    $date_created->add();
    $date_done->add();
    $assigned_to_label->add();
    $assigned_to->add();
    $test_id_label->add();
    $test_id->add();
    $notes->add();
    $status->add();
    $submit_btn->add();
    ?>
</div>

<?php

$date = date("Y-m-d H:i", strtotime("+2 Hours"));

$ajax = new js_ajax();
$ajax->function_name("add_booking");
$ajax->submit_btn_id("submit");
$ajax->insert("bookings");
$ajax->add_column_and_value("date_created=$date");
$ajax->on_success("BOOKING ADDED SUCCESSFULLY");