<?php
include '../../fpdf.php';
include "../../root.class.php";
$call = new call_functions();


$db = new db_safeguard();
$jobcard_res = $db->query("job_cards_tech", "SELECT * FROM job_cards_tech WHERE record_id = {$_GET['record_id']}");
$jobcard = $jobcard_res->fetch_assoc();
function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$pdf->cell(35);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(120, 10, "JOB CARD", 0, 1, 'C');
$pdf->Image('../../logo.png', 10, 20, 30);
$pdf->SetFont('Arial', 'B', 6);
$pdf->cell(35);
$pdf->Cell(115, 5, "MIDRAND AIR SERVICES (PTY) LTD", 0, 0, 'L');
$pdf->Cell(35, 5, "REG NO: 2018/573291/07", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "PO BOX 915", 0, 0, 'L');
$pdf->Cell(35, 5, "VAT NO: 4860287269", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "IRENE, 0062", 0, 0, 'L');
$pdf->Cell(35, 5, "PHONE: 012 661 2211", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "", 0, 0, 'L');
$pdf->Cell(35, 5, "FAX: 012 661 2212", 0, 1, 'R');

$pdf->SetFont('Arial', '', 8);

$pdf->Cell(40, 5, "COMPANY NAME:", 1, 0, 'L');
$pdf->Cell(145, 5, $jobcard['company_name'], 1, 1, '');
// $pdf->Cell(100, 5, "ADDRESS WHERE TECHNICIAN MUST GO", 1, 1, 'L');
$pdf->Cell(40, 5, "DATE:", 1, 0, 'L');
$pdf->Cell(40, 5, $jobcard['date_time_created'], 1, 0, 'L');
$pdf->SetFont('Arial', 'b', 7);

$pdf->Cell(105, 5, $jobcard['company_address'], "R", 1, 'L');
$pdf->SetFont('Arial', '', 8);

$pdf->Cell(40, 5, "ACC NR:", 1, 0, 'L');
$pdf->Cell(40, 5, "", 1, 0, 'L');
$pdf->Cell(105, 5, "", "R", 1, 'L');
$pdf->Cell(40, 5, "JC NUMBER:", 1, 0, 'L');
$pdf->Cell(40, 5, $jobcard['jc_number'], 1, 0, 'L');
$pdf->Cell(50, 5, "ORDER NR:", 1, 0, 'L');
$pdf->Cell(55, 5, $jobcard['client_po_number'], 1, 1, 'L');
$pdf->Cell(40, 5, "QUOTE NUMBER:", 1, 0, 'L');
$pdf->Cell(40, 5, $jobcard['quote_number'], 1, 0, 'L');
$pdf->Cell(50, 5, "VAT NR:", 1, 0, 'L');
$pdf->Cell(55, 5, "", 1, 1, 'L');
$pdf->Cell(40, 5, "CONTACT NAME:", 1, 0, 'L');
$pdf->Cell(40, 5, $jobcard['contact_person'], 1, 0, 'L');
$pdf->Cell(50, 5, "CONTACT NUMBER:", 1, 0, 'L');
$pdf->Cell(55, 5, $jobcard['contact_number'], 1, 1, 'L');
$pdf->Cell(185, 8, "REASON FOR THE CALL OUT", 1, 1, 'C');
$pdf->multiCell(185, 20, remove_html_tags($jobcard['client_reported_issue']), 1, 'L');
$pdf->Cell(40, 10, "", 0, 1, 'L');


$jc_details_res = $db->query("job_card_tech_details", "SELECT * FROM job_card_tech_details WHERE job_card_tech_id = {$_GET['record_id']} ORDER BY record_id ASC");
$index = 1;
while ($jc_details = $jc_details_res->fetch_assoc()) {
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(185, 8, $jc_details['area'], "B", 1, 'L');
    $pdf->SetFont('Arial', '', 8);
    // $pdf->Cell(40, 8, "ISSUE $index", 1, 0, 'L');
    $issue = str_replace("™", " ", $jc_details['issue']);
    $pdf->multiCell(185, 8, $issue, "", 'L');
    $pdf->Cell(40, 2, "", "", 1, 'L');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(185, 8, "PARTS", "B", 1, 'L');
    $pdf->SetFont('Arial', '', 8);
    $pdf->multiCell(185, 8, $jc_details['part_number'], "", 'L');
    $pdf->Cell(40, 2, "", 0, 1, '');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(17, 4, "FINDINGS", "B", 1, 'L');
    $pdf->SetFont('Arial', '', 8);
    $jc_notes_res = $db->query("job_card_tech_detail_notes", "SELECT * FROM job_card_tech_detail_notes WHERE job_card_tech_detail_id = {$jc_details['record_id']} ORDER BY record_id ASC");
    if ($jc_notes_res->num_rows == 0) {
        $pdf->Cell(40, 8, "N/A", 0, 1, 'L');
    } else {
        while ($jc_notes = $jc_notes_res->fetch_assoc()) {
            $pdf->multiCell(140, 8, "- " . $call->get_username($jc_notes['user_id']) . " : " . $jc_notes['note'], "L", 'L');
        }
    }
    $pdf->Cell(40, 10, "", 0, 1, 'L');

    $index++;
}

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(40, 4, "GENERAL NOTES", "B", 1, 'L');
$pdf->SetFont('Arial', '', 8);
$jc_notes_res = $db->query("job_card_tech_notes", "SELECT * FROM job_card_tech_notes WHERE job_card_tech_id = {$_GET['record_id']} ORDER BY record_id ASC");
if ($jc_notes_res->num_rows == 0) {
    $pdf->Cell(40, 8, "N/A", 0, 1, 'L');
} else {
    while ($jc_notes = $jc_notes_res->fetch_assoc()) {
        $pdf->multiCell(140, 8, "- " . $call->get_username($jc_notes['user_id']) . " : " . $jc_notes['notes'], "L", 'L');
    }
}
$pdf->Cell(40, 10, "", 0, 1, 'L');

// $jobcard_time_line_res = $db->query("job_cards_tech_timeline", "SELECT * FROM job_cards_tech_timeline WHERE job_card_tech_id = {$_GET['record_id']} AND `type` = 'START' ORDER BY record_id ASC ");
// $timeline = $jobcard_time_line_res->fetch_assoc();
// $pdf->Cell(40, 5, "Started:", 1, 0, 'L');
// $pdf->Cell(40, 5, $timeline['date_time'], 1, 0, 'L');
// $jobcard_time_line_res = $db->query("job_cards_tech_timeline", "SELECT * FROM job_cards_tech_timeline WHERE job_card_tech_id = {$_GET['record_id']} AND `type` = 'STOPED' ORDER BY record_id DESC ");
// $timeline = $jobcard_time_line_res->fetch_assoc();
// $pdf->Cell(40, 5, "Stoped:", 1, 0, 'L');
// $pdf->Cell(40, 5, $timeline['date_time'], 1, 1, 'L');

$pdf->Cell(40, 5, "", 0, 1, 'L');
$pdf->Cell(40, 5, "Technician:", 1, 0, 'L');
$pdf->Cell(40, 5, $call->get_username($jobcard['user_to_do']), 1, 1, 'L');
$pdf->Cell(40, 5, "Client Name:", 1, 0, 'L');
$pdf->Cell(40, 5, $jobcard['singed_by_for_quote'], 1, 1, 'L');
if ($jobcard['signature_by_for_quote'] != "") {
    $pdf->Image('signatures/' . $jobcard['signature_by_for_quote'], 10, $pdf->GetY(), 50);
}


$pdf->Output("I");
