<?php
include '../../fpdf.php';
include "../../root.class.php";

$total_stock_value = 0.00;
$db = new db_safeguard();
$where_data = ' 1 ';
function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = {$_GET['record_id']}");
$stock = $stock_res->fetch_assoc();
$pdf->SetFont('Arial', 'B', 7);
$pdf->MultiCell(150, 5, remove_html_tags($stock['description']), "B", "L", );
$pdf->SetFont('Arial', '', 5);
$pdf->Cell(35, 5, "", 0, 1, 'L');

$pdf->Cell(35, 5, "AMOUNT", 1, 0, 'L');
$pdf->Cell(35, 5, "VALUE EACH", 1, 0, 'L');
$pdf->Cell(35, 5, "TOTAL VLAUE", 1, 0, 'L');
$pdf->Cell(35, 5, "CATEGORY", 1, 0, 'L');
$pdf->Cell(59, 5, "SUPPLIER", 1, 1, 'L');
$pdf->SetFont('Arial', 'B', 5);

$stock_amount_res = $db->query("order_trans", "SELECT SUM(amount) as total FROM order_trans WHERE stock_id = {$_GET['record_id']}");
$stock_amount = $stock_amount_res->fetch_assoc();
$pdf->Cell(35, 5, number_format($stock_amount['total'], 4, ".", ","), 1, 0, 'L');
$pdf->Cell(35, 5, "R " . number_format($stock['cost_price'], 3, ".", ","), 1, 0, 'L');
$cost_price = (empty($stock['cost_price'])) ? 0 : (float) $stock['cost_price'];
$total_value = $stock_amount['total'] * $cost_price;
$pdf->Cell(35, 5, "R " . number_format($total_value, 3, ".", ","), 1, 0, 'L');
$stock_category_res = $db->query("stock_categories", "SELECT * FROM stock_categories WHERE record_id = {$stock['category_id']}");
$stock_category = $stock_category_res->fetch_assoc();
$pdf->Cell(35, 5, remove_html_tags($stock_category['name']), 1, 0, 'L');
$stock_supplier_res = $db->query("suppliers", "SELECT * FROM suppliers WHERE record_id = {$stock['supplier_id']}");
$stock_supplier = $stock_supplier_res->fetch_assoc();
$pdf->Cell(59, 5, remove_html_tags($stock_supplier['name']), 1, 1, 'L');

$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(35, 5, "", 0, 1, 'L');

$pdf->MultiCell(150, 5, "STOCK MOVEMENT TABLE", "B", "L", );
$pdf->SetFont('Arial', '', 5);
$pdf->Cell(35, 2, "", 0, 1, 'L');

$pdf->Cell(35, 5, "ORDER NUMBER", 1, 0, 'L');
$pdf->Cell(35, 5, "JOBCARD NUMBER", 1, 0, 'L');
$pdf->Cell(35, 5, "AMOUNT", 1, 0, 'L');
$pdf->Cell(35, 5, "DATE TIME", 1, 0, 'L');
$pdf->Cell(35, 5, "USER", 1, 1, 'L');
$pdf->Cell(35, 2, "", 0, 1, 'L');

$pdf->SetFont('Arial', '', 5);
function get_username($user_id)
{
    $db = new db_safeguard();
    $user_res = $db->query("users", "SELECT * FROM users WHERE record_id = $user_id");
    if ($user_id == 0) {
        return "SYSTEM";
    } else {
        return $user_res->fetch_assoc()['username'];
    }
}

function get_order_number($order_id)
{
    $db = new db_safeguard();
    $order_res = $db->query("orders", "SELECT * FROM orders WHERE record_id = $order_id");
    if ($order_id == 0) {
        return "STOCK TAKE ADJUSTMENT";
    } else {
        return $order_res->fetch_assoc()['po_number'];
    }

}
$order_trans_res = $db->query('order_trans', "SELECT * FROM order_trans WHERE stock_id = {$_GET['record_id']} ORDER BY record_id DESC");
while ($order_trans = $order_trans_res->fetch_array()) {
    if ($order_trans['order_id'] == 0 && $order_trans['job_card_no'] != Null) {
        $pdf->Cell(35, 5, "", 1, 0, 'L');
    } else {
        $pdf->Cell(35, 5, get_order_number($order_trans['order_id']), 1, 0, 'L');

    }
    $pdf->Cell(35, 5, $order_trans['job_card_no'], 1, 0, 'L');
    $pdf->Cell(35, 5, $order_trans['amount'], 1, 0, 'L');
    $pdf->Cell(35, 5, $order_trans['date_time'], 1, 0, 'L');
    $pdf->Cell(35, 5, get_username($order_trans['user_id']), 1, 1, 'L');
    $pdf->SetFont('Arial', '', 5);

}


$pdf->Output("I");