<?php
include '../../fpdf.php';
include "../../root.class.php";
$call = new call_functions();

if (isset($_GET['record_id'])) {
    $_GET['dispatch_id'] = $_GET['record_id'];
}

$db = new db_safeguard();
function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$pdf->Image('../../logo.png', 10, 10, 30);
$pdf->SetFont('Arial', 'B', 6);
$pdf->cell(35);
$pdf->Cell(115, 5, "MIDRAND AIR SERVICES (PTY) LTD", 0, 0, 'L');
$pdf->Cell(35, 5, "REG NO: 2018/573291/07", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "PO BOX 915", 0, 0, 'L');
$pdf->Cell(35, 5, "VAT NO: 4860287269", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "IRENE, 0062", 0, 0, 'L');
$pdf->Cell(35, 5, "PHONE: 012 661 2211", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "", 0, 0, 'L');
$pdf->Cell(35, 5, "FAX: 012 661 2212", 0, 1, 'R');
$pdf->Cell(115, 5, "", 0, 1, 'L');
/// header end


$pdf->SetFont('Arial', 'B', 25);
$pdf->Cell(190, 5, "DISPATCH", 0, 1, 'C');

$dispatch_details = $db->query("dispatch_batches", "SELECT * FROM dispatch_batches WHERE record_id = '" . $_GET['dispatch_id'] . "'");
$dispatch = $dispatch_details->fetch_assoc();

// dispatch details
$pdf->SetFont('Arial', 'B', 8);
$pdf->cell(35);
$pdf->Cell(47, 5, "", 0, 1, 'L');
$pdf->Cell(47, 5, "JOB CARD", 1, 0, 'L');
$pdf->Cell(47, 5, "DISP. BY:", 1, 0, 'L');
$pdf->Cell(47, 5, "REC/Driver. BY:", 1, 0, 'L');
$pdf->Cell(47, 5, "DATE:", 1, 1, 'L');
$pdf->Cell(47, 5, $dispatch['jc_number'], 1, 0, 'L');
$pdf->Cell(47, 5, $call->get_username($dispatch['user_id']), 1, 0, 'L');
$pdf->Cell(47, 5, $dispatch['received_by'], 1, 0, 'L');
$pdf->Cell(47, 5, $dispatch['date_time'], 1, 1, 'L');


// get all dispatch items
$pdf->Cell(47 * 4, 5, "", 0, 1, '0');
$pdf->Cell(47, 5, "STOCK", "B", 0, 'L');
$pdf->Cell(47, 5, "AMOUNT", "B", 0, 'L');
$pdf->Cell(47, 5, "BARCODE", "B", 0, 'L');
$pdf->Cell(47, 5, "S/N", "B", 1, 'L');
$pdf->SetFont('Arial', '', 6);

$dispatch_items_res = $db->query("order_trans", "SELECT * FROM order_trans WHERE dispatch_batch_id = '" . $_GET['dispatch_id'] . "'");
$total_items = 0;
while ($dispatch_items = $dispatch_items_res->fetch_assoc()) {
    $pdf->Cell(47, 5, $call->get_stock_name($dispatch_items['stock_id']), "B", 0, 'L');
    $pdf->Cell(47, 5, $dispatch_items['amount'], "B", 0, 'L');
    if ($dispatch_items['units_stock_id'] != 0) {
        // get units stock item details
        $units_stock_res = $db->query("units_stock", "SELECT * FROM units_stock WHERE record_id = '" . $dispatch_items['units_stock_id'] . "'");
        $units_stock = $units_stock_res->fetch_assoc();
        $pdf->Cell(47, 5, $units_stock['serial_number'], "B", 0, 'L');
        $pdf->Cell(47, 5, $units_stock['barcode'], "B", 0, 'L');
    } else {
        $pdf->Cell(47, 5, "N/A", "B", 0, 'L');
    }
    if ($dispatch_items['non_stock_id'] != 0) {
        // get barcode for non stock item
        $non_stock_res = $db->query("non_stock", "SELECT * FROM non_stock WHERE record_id = '" . $dispatch_items['non_stock_id'] . "'");
        $non_stock = $non_stock_res->fetch_assoc();
        $pdf->Cell(47, 5, $non_stock['barcode'], "B", 1, 'L');
    } else {
        $pdf->Cell(47, 5, "N/A", "B", 1, 'L');

    }
    $signature_file = $dispatch_items['signature'];
    $total_items += abs($dispatch_items['amount']);
}
$pdf->SetFont('Arial', 'B', 8);

// Top totals rows
$pdf->Cell(47 * 2, 5, "", "", 1, 'L');
$pdf->Cell(25, 5, "TOTAL ITEMS", 1, 0, 'L');
$pdf->Cell(25, 5, number_format($total_items, 0), 1, 1, 'L');

// Signature cell (height 15)
$cellWidth = 47;
$cellHeight = 10;
$pdf->SetFont('Arial', '', 8);
$pdf->Cell($cellWidth, $cellHeight, "Singed by,  {$dispatch['received_by']}", "", 1, 'L');

// Get coordinates AFTER printing the cell
$cellX = $pdf->GetX(); // right side of cell
$cellY = $pdf->GetY(); // bottom of cell

// Image dimensions
$imgWidth = 50;
$imgHeight = 20; // adjust if needed

// Calculate X so image is inside the cell (shift left!)
$imgX = $cellX - $cellWidth + 40;

// Calculate Y so it's bottom-aligned
$imgY = $cellY - $imgHeight + 20;

if ($signature_file != "") {
    // Draw signature image
    $pdf->Image('signatures/' . $signature_file, $imgX, $imgY, $imgWidth, $imgHeight);
} else {
    $pdf->Cell($cellWidth, $cellHeight, "", 1, 1, 'L');
}

$pdf->Output("I");
