<?php
include "root.class.php";
new root_styles();
$db = new db_safeguard();
$roots = new root();
// $roots->OnPageScripts();

new login_system();
new online_check();
$navbar = new navbar();



if ($_SESSION['user_type'] == "MANAGEMENT") {

    $navbar->add_logo('icons/logo.svg', "app/home.php");
    $navbar->open_group("STOCK");
    $navbar->add_button("STOCK_HOME", 'app/stock/home.php', 'stock_home_page', "Stock");
    $navbar->add_button("STOCK_HOME", 'app/stock/item_code_allocation.php', 'stock_home_page', "Item Codes");
    $navbar->add_button("STOCK_ADMIN", 'app/stock/stock_admin.php', 'stock_admin', "Stock Admin");
    $navbar->add_button("STOCK_CATEGORIES", 'app/stock_categories/home.php', 'stock_categories_home_page', "Stock Categories");
    $navbar->add_button("ORDERS", 'app/stock_take/home.php', 'stocktake_home_page', "Stock Take");
    $navbar->add_button("SUPPLIERS", 'app/suppliers/home.php', 'suppliers_home_page', "Suppliers");
    $navbar->end_group();

    $navbar->open_group("DISPATCHING");
    $navbar->add_button("STOCK_HOME", 'app/dispatching/dispatching_home.php', 'stock_home_page', "DISP. BATCHES");
    $navbar->add_button("STOCK_HOME", 'app/dispatching/receiving_home.php', 'stock_home_page', "RECV. BATCHES.");
    $navbar->add_button("stock_report", 'app/reports/dispatch_form.php', 'stock_report', "DISPATCH REPORT");
    $navbar->end_group();

    $navbar->open_group("ORDERS");
    $navbar->add_button("ORDERS", 'app/orders/home.php', 'orders_home_page', "Orders");
    $navbar->add_button("ORDERS", 'app/orders/upload_purchase_orders.php', 'upload_pos', "UPLOAD ORDERS");
    $navbar->add_button("ORDERS", 'app/orders/receiving.php', 'orders_recieving_page', "Receiving");
    $navbar->add_button("orders_admin", 'app/orders/transaction_admin.php', 'stock_admin', "Warehouse Trans.");
    $navbar->end_group();

    $navbar->open_group("COSTING");
    $navbar->add_button("ORDERS", 'app/costing/home.php', 'orders_home_page', "ADD COSTS");
    $navbar->add_heading("JOB CARDS");
    $navbar->add_button("accounts", 'app/reports/job_card_account.php', 'stock_report', "J.C. ACCOUNTS");
    $navbar->add_button("accounts", 'app/reports/job_card_project.php', 'stock_report', "J.C. PROJECT");
    $navbar->add_button("accounts", 'app/reports/job_card_tech.php', 'stock_report', "J.C. TECH");
    $navbar->end_group();

    $navbar->open_group("JOB CARDS");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_accounts_home.php', 'add_users_page', "JOB CARD ACCOUNTS");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_home.php', 'add_users_page', "JOB CARD (PROJECTS)");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_tech_home.php', 'add_users_page', "JOB CARD (TECHNICAL)");
    $navbar->end_group();
    $navbar->open_group("USERS");
    $navbar->add_button("ADD", 'app/users/add_user.php', 'add_users_page', "CREATE");
    $navbar->add_button("SEARCH", 'app/users/search_user.php', 'add_users_page', "SEARCH");
    $navbar->add_button("log", 'app/log.php', 'log', "LOG");

    $navbar->end_group();
    $navbar->open_group("REPORTS");
    $navbar->add_heading("STOCK");
    $navbar->add_button("stock_report", 'app/reports/stock_form.php', 'stock_report', "STOCK LIST");
    $navbar->add_button("stock_report", 'app/reports/stock.php', 'stock_report', "STOCK");
    $navbar->add_button("stock_report", 'app/reports/pj_report_form.php', 'stock_report', "PJ REPORT");



    $navbar->end_group();
    $navbar->add_logout_button();
    $navbar->navbar_end();
}
if ($_SESSION['user_type'] == "PROCUREMENT") {


    $navbar->add_logo('icons/logo.svg', "app/home.php");
    $navbar->open_group("STOCK");
    $navbar->add_button("STOCK_HOME", 'app/stock/home.php', 'stock_home_page', "Stock");
    $navbar->add_button("STOCK_HOME", 'app/stock/item_code_allocation.php', 'stock_home_page', "Item Codes");
    $navbar->add_button("STOCK_ADMIN", 'app/stock/stock_admin.php', 'stock_admin', "Stock Admin");
    $navbar->add_button("STOCK_CATEGORIES", 'app/stock_categories/home.php', 'stock_categories_home_page', "Stock Categories");
    $navbar->add_button("ORDERS", 'app/stock_take/home.php', 'stocktake_home_page', "Stock Take");
    $navbar->add_button("SUPPLIERS", 'app/suppliers/home.php', 'suppliers_home_page', "Suppliers");
    $navbar->end_group();

    $navbar->open_group("DISPATCHING");
    $navbar->add_button("STOCK_HOME", 'app/dispatching/dispatching_home.php', 'stock_home_page', "DISP. BATCHES");
    $navbar->add_button("STOCK_HOME", 'app/dispatching/receiving_home.php', 'stock_home_page', "RECV. BATCHES.");
    $navbar->add_button("stock_report", 'app/reports/dispatch_form.php', 'stock_report', "DISPATCH REPORT");
    $navbar->end_group();


    $navbar->open_group("ORDERS");
    $navbar->add_button("ORDERS", 'app/orders/home.php', 'orders_home_page', "Orders");
    $navbar->add_button("ORDERS", 'app/orders/upload_purchase_orders.php', 'upload_pos', "UPLOAD ORDERS");
    $navbar->add_button("ORDERS", 'app/orders/receiving.php', 'orders_recieving_page', "Receiving - PO");
    $navbar->add_button("orders_admin", 'app/orders/transaction_admin.php', 'stock_admin', "WAREHOUSE TRANS.");
    $navbar->end_group();

    $navbar->open_group("JOB CARDS");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_accounts_home.php', 'add_users_page', "JOB CARD ACCOUNTS");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_home.php', 'add_users_page', "JOB CARD (PROJECTS)");
    $navbar->add_button("ADD", 'app/jobcards/jobcard_tech_home.php', 'add_users_page', "JOB CARD (TECHNICAL)");
    $navbar->end_group();
    $navbar->open_group("USERS");
    $navbar->add_button("ADD", 'app/users/add_user.php', 'add_users_page', "CREATE");
    $navbar->add_button("SEARCH", 'app/users/search_user.php', 'add_users_page', "SEARCH");
    $navbar->add_button("log", 'app/log.php', 'log', "LOG");

    $navbar->end_group();
    $navbar->open_group("REPORTS");
    $navbar->add_heading("STOCK");
    $navbar->add_button("stock_report", 'app/reports/stock_form.php', 'stock_report', "STOCK LIST");
    $navbar->add_button("stock_report", 'app/reports/stock.php', 'stock_report', "STOCK");
    $navbar->add_button("stock_report", 'app/reports/pj_report_form.php', 'stock_report', "PJ REPORT");



    $navbar->add_heading("JOB CARDS");
    $navbar->add_button("accounts", 'app/reports/job_card_account.php', 'stock_report', "J.C. ACCOUNTS");
    $navbar->add_button("accounts", 'app/reports/job_card_project.php', 'stock_report', "J.C. PROJECT");
    $navbar->add_button("accounts", 'app/reports/job_card_tech.php', 'stock_report', "J.C. TECH");

    $navbar->end_group();
    $navbar->add_logout_button();
    $navbar->navbar_end();
}
if ($_SESSION['user_type'] == "TECHNICIANS") {

    $navbar->add_logo('icons/logo.svg', "app/home.php");

    $navbar->open_group("JOB CARDS");
    $navbar->add_button("ADD", 'app/jobcards/tech_jobcard_home.php', 'add_users_page', "CALL OUTS");
    $navbar->add_button("ADD NEW", 'app/jobcards/add_tech_jc_from_tech.php', 'add', "NEW J.C.");
    $navbar->end_group();
    $navbar->add_logout_button();
    $navbar->navbar_end();
}
if ($_SESSION['user_type'] == "WAREHOUSE") {

    $date = date("Y-m-d H:i", strtotime("+2 Hours"));
    $stock_take_res = $db->query("stock_takes", "SELECT * FROM stock_takes WHERE date_to_be_done <= '$date' AND disision != 'APPROVED'");
    $navbar->add_logo("../logo.svg", "app/stock_control/home.php");
    $navbar->open_group("ORDERS");
    $navbar->add_button("ORDERS", 'app/stock_control/stock_control.php', 'stocktake_home_page', "RECEIVE");
    $navbar->add_button("ORDERS", 'app/stock_control/dispatch.php', 'stock_take_home_page', "DISPATCH");
    $navbar->add_button("ORDERS", 'app/stock_control/dispatch_to_site.php', 'stock_take_home_page', "DISP. TO SITE");
    $navbar->add_button("ORDERS", 'app/stock_control/returns.php', 'stock_take_home_page', "returns");
    $navbar->add_button("ORDERS", 'app/stock_control/transaction_admin.php', 'stock_take_home_page', "Disp. Rece. Admin");
    $navbar->add_button("ORDERS", 'app/home.php', 'stock_take_home_page', "LATEST");
    $navbar->end_group();
    if ($stock_take_res->num_rows > 0) {
        $navbar->open_group("STOCK TAKE");
        $navbar->add_button("ORDERS", 'app/stock_control/stock_take.php?record_id=' . $stock_take_res->fetch_object()->record_id, 'stocktake_home_page', "VIEW");
        $navbar->end_group();

    }
    $navbar->add_logout_button();
    $navbar->navbar_end();

    ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Overlay -->
    <div id="overlay">
        <div class="overlay-content">
            <div class="loader"></div>
            <div class="loading-text">Please Hold, Job Cards and Stock updating....</div>
        </div>
    </div>

    <style>
        #overlay {
            display: none;
            /* Hidden by default */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.77);
            z-index: 99999;
            /* ON TOP OF EVERYTHING */
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .overlay-content {
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
        }

        .loader {
            border: 8px solid #f3f3f3;
            border-top: 8px solid #3498db;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            animation: spin 1s linear infinite;
            margin-bottom: 10px;
        }

        .loading-text {
            color: white;
            font-size: 18px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            letter-spacing: 1px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>


    <script>
        var update_timeout = null;
        start_updates();
        update_stock();
        update_job_cards();
        function update_data() {

            if (update_timeout != null) {
                clearTimeout(update_timeout);
            }
            update_timeout = setTimeout(function () {
                update_stock();
                update_job_cards();
            }, 1800000);
        }

        function start_updates() {
            update_data();
        }

        function overlay_on() {
            $("#overlay").show();
        }

        function overlay_off() {
            $("#overlay").hide();
        }

        function update_stock() {
            overlay_on();
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    if (xhr.responseText == "1") {

                    }
                }
            };
            xhr.open("GET", "ajax_background_scripts/get_latest_stock_into_session.php", true);
            xhr.send();
        }

        function update_job_cards() {
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    if (xhr.responseText == "1") {
                        overlay_off();
                        update_data();
                    }
                }
            };
            xhr.open("GET", "ajax_background_scripts/get_latest_job_cards_into_session.php", true);
            xhr.send();
        }
    </script>

    <?php
}

$roots->Main_iframe("app/home.php");




?>