<?
require('../classes/fpdf.php');

include "../classes/db.class.php";
$db = new db();
$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

// $pdf->Cell(-3);
$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(10, 10, "SCOUTING REPORT", 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(10, 10, "VALUES IS BASED ON THE HIGHEST BUG COUNT FOR THAT DAY", 0, 1, 'L');
$pdf->Cell(10, 15, '', 0, 1, 'L');


$blocks = $db->query("SELECT DISTINCT `block` FROM `scouting_temp`");

while ($block = $blocks->fetch_assoc()) {
    $block_name = $block['block'];

    $varietys = $db->query("SELECT DISTINCT `variety` FROM `scouting_temp` WHERE `block` = '$block_name'");
    while ($variety = $varietys->fetch_assoc()) {
        $varity_name = $variety['variety'];


        $target_types = $db->query("SELECT DISTINCT `target_type` FROM `scouting_temp` WHERE `block` = '$block_name' AND variety = '$varity_name'");
        while ($target = $target_types->fetch_assoc()) {
            $target_type = $target['target_type'];


            $target_names = $db->query("SELECT DISTINCT `target_name` FROM `scouting_temp` WHERE `block` = '$block_name' AND variety = '$varity_name' AND target_type = '$target_type'");
            while ($target_description = $target_names->fetch_assoc()) {
                $target_name = $target_description['target_name'];



                $target_stages = $db->query("SELECT DISTINCT `target_stage_name` FROM `scouting_temp` WHERE `block` = '$block_name' AND variety = '$varity_name' AND target_type = '$target_type' AND target_name = '$target_name'");
                while ($target_stage = $target_stages->fetch_assoc()) {
                    $target_stage_name = $target_stage['target_stage_name'];



                    $dates = $db->query("SELECT DISTINCT `date` FROM `scouting_temp` WHERE `block` = '$block_name' AND variety = '$varity_name' AND target_type = '$target_type' AND target_name = '$target_name' AND target_stage_name = '$target_stage_name' ORDER BY record_id DESC");
                    while ($date = $dates->fetch_assoc()) {


                        $events = $db->query("SELECT * FROM `scouting_temp` WHERE `block` = '$block_name' AND variety = '$varity_name' AND target_type = '$target_type' AND target_name = '$target_name' AND target_stage_name = '$target_stage_name' AND `date` = '{$date['date']}' ORDER BY record_id DESC");

                        while ($event = $events->fetch_assoc()) {
                            $averige_high[] = $event['average'];
                            $incidence_high[] = $event['incidence'];
                            $threshold = str_replace("Low:", "", $event['threshold']);
                            $threshold = str_replace("Medium:", "|", $threshold);
                            $threshold = str_replace("High:", "|", $threshold);
                            $threshold= explode('|', $threshold);
                            $low_[] = $threshold[0];
                            $med_[] = $threshold[1];
                            $lhigh_[] = $threshold[2];
                        }

                        $average_arr["{$date['date']}"] = max($averige_high);
                        $actual_arr["{$date['date']}"] = max($incidence_high);
                        $high_arr["{$date['date']}"] = floatval(str_replace(" ", "",  max($lhigh_)));
                        $medium_arr["{$date['date']}"] = floatval(str_replace(" ", "",  max($med_)));
                        $low_arr["{$date['date']}"] = floatval(str_replace(" ", "", max($low_)));
                       
                    }
                    $pdf->SetFont('Arial', 'B', 12);
                    $pdf->Cell(10, 8, $block_name, 0, 1, 'L');
                    $pdf->SetFont('Arial', '', 10);
                    $pdf->cell(10);
                    $pdf->Cell(10, 8, $varity_name, 0, 1, 'L');
                    $pdf->SetFont('Arial', '', 8);
                    $pdf->cell(10);
                    $pdf->Cell(10, 8, $target_type, 0, 1, 'L');
                    $pdf->cell(20);
                    $pdf->SetFont('Arial', '', 8);
                    $pdf->Cell(10, 8, $target_name, 0, 1, 'L');
                    $pdf->cell(30);
                    $pdf->SetFont('Arial', '', 8);
                    $pdf->Cell(10, 8, $target_stage_name, 0, 1, 'L');

                    $data_hc_att = array(
                        'AVERAGE' => $average_arr,
                        'ACTUAL' => $actual_arr,
                        'HIGH' => $high_arr,
                        'MEDIUM' => $medium_arr,
                        'LOW' => $low_arr,
                    );
                    $colors_hc_att = array(
                        'AVERAGE' => array(100, 100, 100),
                        'ACTUAL' => array(0, 0, 0),
                        'HIGH' => array(200, 0, 0),
                        'MEDIUM' => array(200, 100, 0),
                        'LOW' => array(0, 200, 0),
                    );


                    // var_dump($data_hc_att);
                    $pdf->SetXY(0, 100);

                    $pdf->LineGraph(342, 70, $data_hc_att, 'V', $colors_hc_att, 1, 2);

                    $average_arr = array();
                    $actual_arr = array();
                    $high_arr = array();
                    $medium_arr = array();
                    $low_arr = array();
                    $averige_high = array();
                    $incidence_high = array();
                    $pdf->AddPage("L");
                    $pdf->SetFont('Arial', '', 8);
                }
            }
        }
    }
}



$pdf->Output("I");


// $date_arr = explode('/', $event['date']);
// $date = $date_arr[2] . '-' . $date_arr[0] . '-' . $date_arr[1];
// echo "-------->" . $event['date'] . ' | ' . $event['incidence'] . ' | ' . $event['average'] . ' | ' . $event['threshold'] . '<br>';
