<?php
require('../../fpdf.php');
include "../../root.class.php";


$db = new db_safeguard();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('p');

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, "TEAMS", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(50, 8, "NAME", 1, 0, 'L');
$pdf->Cell(50, 8, "ASSIGNED ASSETS", 1, 0, 'L');
$pdf->Cell(40, 8, "STATUS", 1, 1, 'L');

$teams_res = $db->query("teams", "SELECT * FROM teams ORDER BY record_id ASC");
if ($teams_res->num_rows == 0) {
    $error = 1;
} else {
    while ($teams = $teams_res->fetch_assoc()) {
        $pdf->Cell(50, 8, $teams['name'], "LB", 0, 'L');
        $pdf->Cell(50, 8, $teams['assigned_assets'], "LBR", 0, 'L');
        $pdf->Cell(40, 8, $teams['status'], "LBR", 1, 'L');
    }
}

$pdf->Output("I");