<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

// generate a stock id using 3


$stock_res = $db->query("stock_control", "SELECT * FROM stock_control ORDER BY stock_no DESC LIMIT 1");

if ($stock = $stock_res->fetch_assoc()) {
    //get the last 3 digits in the stock_id
    $last_three_digits = substr($stock["stock_no"], -3);
    $next_three_digits = $last_three_digits + 1;
    $stock_no = "ST" . str_pad($next_three_digits, 3, "0", STR_PAD_LEFT);

} else {
    $stock_no = "ST001";
    // $stock_no = "ST" . str_pad($stock["stock_no"] + 1, 3, "0", STR_PAD_LEFT);
}

$stock_id_label = new label();
$stock_id_label->for("stock_no_label");
$stock_id_label->value("STOCK NO");

$stock_id = new input();
$stock_id->type("text");
$stock_id->name("stock_no");
$stock_id->id("stock_no");
$stock_id->value($stock_no);
$stock_id->readonly();

$item_name_label = new label();
$item_name_label->for("item_name_label");
$item_name_label->value("ITEM NAME");

$item_name = new input();
$item_name->type("text");
$item_name->name("item_name");
$item_name->id("item_name");
$item_name->style("width:30vw;");

$product_name_label = new label();
$product_name_label->for("product_name_label");
$product_name_label->value("PRODUCT NAME");

$product_name = new input();
$product_name->type("text");
$product_name->name("product_name");
$product_name->id("product_name");
$product_name->style("width:30vw;");

$unit_of_measure_label = new label();
$unit_of_measure_label->for("quantity_type_label");
$unit_of_measure_label->value("UNIT OF MEASURE");

$measuring_unit = new select();
$measuring_unit->name("unit_of_measure");
$measuring_unit->id("unit_of_measure");
$measuring_unit->add_option("liters", "liters");
$measuring_unit->add_option("ml", "ml");
$measuring_unit->add_option("kg", "kg");
$measuring_unit->add_option("g", "g");
$measuring_unit->add_option("inches", "inches");
$measuring_unit->add_option("meters", "meters");
$measuring_unit->add_option("cm", "cm");

$quantity_label = new label();
$quantity_label->for("quantity_label");
$quantity_label->value("QUANTITY");

$quantity = new input();
$quantity->type("number");
$quantity->name("quantity");
$quantity->id("quantity");

$weight_label = new label();
$weight_label->for("weight_label");
$weight_label->value("AMOUNT");

$weight = new input();
$weight->type("number");
$weight->name("weight");
$weight->id("weight");

$status = new input();
$status->type("hidden");
$status->name("status");
$status->id("status");
$status->value(0);

$type_label = new label();
$type_label->for("type_label");
$type_label->value("STOCK TYPE");

$type = new select();
$type->name("stock_type");
$type->id("stock_type");
$type->style("width: 20vw;");
$type->add_option("OILS", "OILS");
$type->add_option("HYDRAULICS", "HYDRAULICS");
$type->add_option("PUMPS", "PUMPS");
$type->add_option("HAMMER, BYTEL OR RIEMER", "HAMMER, BYTEL OR RIEMER");
$type->add_option("BOLTS AND NUTS", "BOLTS & NUTS");
$type->add_option("CONSUMABLES", "CONSUMABLES");
$type->onchange("change_stock_type()");

$open_balance_label = new label();
$open_balance_label->for("open_balance_label");
$open_balance_label->value("OPEN BALANCE");

$open_balance = new input();
$open_balance->type("number");
$open_balance->name("open_balance");
$open_balance->id("open_balance");

$close_balance_label = new label();
$close_balance_label->for("close_balance_label");
$close_balance_label->value("CLOSE BALANCE");

$close_balance = new input();
$close_balance->type("number");
$close_balance->name("close_balance");
$close_balance->id("close_balance");

$team_assigned_label = new label();
$team_assigned_label->for("team_assigned_label");
$team_assigned_label->value("TEAM ASSIGNED");

$team_assigned = new select();
$team_assigned->class("inputs");
$team_assigned->name("team_assigned_id");
$team_assigned->id("team_assigned_id");
$team_assigned->fill_from_db("teams", "record_id", "name", "status = 'ACTIVE'");

$vehicle_type_label = new label();
$vehicle_type_label->for("vehicle_type_label");
$vehicle_type_label->value("VEHICLE TYPE");

$vehicle_type = new select();
$vehicle_type->class("inputs");
$vehicle_type->name("vehicle_type");
$vehicle_type->id("vehicle_type");
$vehicle_type->add_option("ALL", "ALL");
$vehicle_type->add_option("T", "TRUCK");
$vehicle_type->add_option("D", "DONKIE");
$vehicle_type->add_option("C", "COMP");
$vehicle_type->add_option("CT", "COMP TRUCK");
$vehicle_type->add_option("OTHER", "OTHER");

$supplier_label = new label();
$supplier_label->for("supplier_label");
$supplier_label->value("SUPPLIER");

$supplier = new select();
$supplier->class("inputs");
$supplier->name("supplier_id");
$supplier->id("supplier_id");
$supplier->fill_from_db("suppliers", "record_id", "name");

// $

$serial_number_label = new label();
$serial_number_label->for("serial_number_label");
$serial_number_label->value("SERIAL NUMBER");

$serial_number = new input();
$serial_number->type("text");
$serial_number->name("serial_number");
$serial_number->id("serial_number");

$submit_btn = new button();
$submit_btn->value("SUBMIT");
?>

<form action="add_stock.ajax.php" method="POST">
    <div class="form_down">
        <h1>ADD STOCK</h1>
        <?php
        $status->add();

        $stock_id_label->add();
        $stock_id->add();

        $type_label->add();
        $type->add();

        $item_name_label->add();
        $item_name->add();
        ?>

        <div id="default_stock" style="display: flex; flex-direction: column; text-align: center;">

            <div id="hammer_stock" style="display: none; flex-direction: column; text-align: center;">
                <?php
                $serial_number_label->add();
                $serial_number->add();
                ?>
            </div>

            <div style="display: flex; flex-direction: row;">
                <div style="display:flex; flex-direction: column;">
                    <?php
                    $quantity_label->add();
                    $quantity->add();
                    ?>
                </div>
                <div style="display:flex; flex-direction: column;">
                    <?php
                    $unit_of_measure_label->add();
                    $measuring_unit->add();
                    ?>
                </div>
                <div style="display:flex; flex-direction: column;">
                    <?php
                    $weight_label->add();
                    $weight->add();
                    ?>
                </div>
            </div>

            <?php
            $supplier_label->add();
            $supplier->add();
            $open_balance_label->add();
            ?>

            <input type="number" name="open_balance" id="open_balance" step="0.01" class="inputs">

            <?php
            $team_assigned_label->add();
            $team_assigned->add();
            ?>

            <div id="oil_stock" style="display: none; flex-direction: column; text-align: center;">
                <?php
                $vehicle_type_label->add();
                $vehicle_type->add();
                ?>
            </div>

            <?php
            $close_balance_label->add();
            ?>

            <input type="number" name="close_balance" id="close_balance" step="0.01" class="inputs">

        </div>

        <div id="pump_stock" style="display: none; flex-direction: column; text-align: center;">
            
        </div>

        <?php
        $submit_btn->add();
        ?>

    </div>

    <script>
        function change_stock_type() {
            var stock_type = document.getElementById("stock_type").value;
            if (stock_type == "HAMMER, BYTEL OR RIEMER") {
                document.getElementById("pump_stock").style.display = "none";
                document.getElementById("hammer_stock").style.display = "flex";
                document.getElementById("oil_stock").style.display = "none";
                document.getElementById("default_stock").style.display = "flex";

            } else if (stock_type == "PUMPS") {
                document.getElementById("pump_stock").style.display = "flex";
                document.getElementById("hammer_stock").style.display = "none";
                document.getElementById("oil_stock").style.display = "none";
                document.getElementById("default_stock").style.display = "none";

            } else if (stock_type == "OILS") {
                document.getElementById("pump_stock").style.display = "none";
                document.getElementById("hammer_stock").style.display = "none";
                document.getElementById("oil_stock").style.display = "flex";
                document.getElementById("default_stock").style.display = "flex";

            } else if (stock_type == "PUMPS") {
                document.getElementById("pump_stock").style.display = "none";
                document.getElementById("hammer_stock").style.display = "none";
                document.getElementById("oil_stock").style.display = "none";
                document.getElementById("default_stock").style.display = "none";

            } else {
                document.getElementById("pump_stock").style.display = "none";
                document.getElementById("hammer_stock").style.display = "none";
                document.getElementById("oil_stock").style.display = "none";
                document.getElementById("default_stock").style.display = "flex";

            }
        }
    </script>

</form>