<?php

include "../classes/autoload.php";
$db = new db();

$html = new html("HOME");
$dashboard = new DashboardWidget();

echo $dashboard::includeAssets();

$now = new DateTime();
$now->modify('-4 weeks');
$interval = new DateInterval('P1D');
$period = new DatePeriod($now, $interval, new DateTime());

$data = array();
$dates = array();
foreach ($period as $dt) {
    $start = $dt->format('Y-m-d');
    $end = $dt->modify('+1 days')->format('Y-m-d');

    $query = "SELECT count(*) as count FROM job_cards WHERE date_time_created >= '$start 00:00' AND date_time_created < '$end 23:59'";
    $created_res = $db->query("job_cards", $query);

    $row = $created_res->fetch_assoc();
    $count = $row ? (int) $row['count'] : 0;

    $data[] = $count;
    $dates[] = $start;

    // echo $query . " → " . $count . "<br>";
}

echo $dashboard::lineGraph("JOB CARDS CREATED", $dates, $data, "J.C.", "100vw");



// get latest 50 jc and their progress

$jc_prog_res = $db->query("job_cards", "SELECT * FROM job_cards ORDER BY record_id DESC LIMIT 50");
$data = array();
while ($row = $jc_prog_res->fetch_assoc()) {
    $data[] = [$row['progress'], $row['job_card_no']];
}

echo $dashboard::columnGraph("JOB CARDS PROGRESS", $data,"100vw");

?>