<?php

include "../../classes/app.class.php";

$app = new app();
$db = new DBMain();

$jobcard_number = $db->get_new_jobcard_number();
$date = date('Y-m-d H:i', strtotime("+2 Hours"));

?>


<div class='container flex_container'>
    <h1>NEW JOBCARD</h1>
    <hr>
    <div class="container flex_container_content" style="border: 1px solid black;padding: 2%; border-radius: 5px;">
        <div class='flex_container'>
            <label>J.N.</label>
            <input type='text' name='jobcard_number' id='jobcard_number' readonly value='<?php echo $jobcard_number; ?>'>
        </div>
        <div class='flex_container'>
            <label>WHEN</label>
            <input type='date' name='date' id='date'>
        </div>
        <div class='flex_container'>
            <label>CLIENT</label>
            <select name='client' id='client_id'>
                <option></option>
                <?php echo $db->get_clients_in_dropdown(); ?>
            </select>
        </div>
        <div class='flex_container'>
            <label>QUOTE NUMBER</label>
            <input type='text' name='quote_number' id='quote_number'>
        </div>
    </div>

    <div class="container flex_container_content" style="border: 1px solid black;padding: 2%; border-radius: 5px;width:48.5%; margin-top: 1%;">
        <label> DESCRIPTION </label>
        <textarea style='width:100%;' id='description'></textarea>
    </div>
    <div class="container flex_container_content" style="border: 1px solid black;padding: 2%; border-radius: 5px;width:48.5%; margin-top: 1%;">
        <div class='flex_container'>
            <label>ARTISAN 1</label>
            <select name='jobcard_user_1' id='jobcard_user_1' onchange="check_artisan(1)">
                <option value=-1>NONE</option>
                <?php echo $db->get_artisans_in_dropdown(); ?>
            </select>
        </div>
        <div class='flex_container'>
            <label>ARTISAN 2</label>
            <select name='jobcard_user_2' onchange="check_artisan(2)" id='jobcard_user_2'>
                <option value=-1>NONE</option>
                <?php echo $db->get_artisans_in_dropdown(); ?>
            </select>
        </div>
        <div class='flex_container'>
            <label>J.C TYPE</label>
            <select name='jobcard_type' id='jobcard_type'>
                <option></option>
                <option>BREAKDOWN</option>
                <option>GENERAL</option>
            </select>
        </div>
    </div>
    <button onclick="add_user()" id='create_btn'>CREATE</button>
</div>

<script>
    function check_artisan(ind) {
        if (ind == 1) {
            if (document.getElementById('jobcard_user_1').value == document.getElementById('jobcard_user_2').value) {
                alert("CANT SELECT THE SAME ARTISON TWISE");
                document.getElementById('jobcard_user_1').value = -1;

            }
        } else {
            if (document.getElementById('jobcard_user_1').value == document.getElementById('jobcard_user_2').value) {
                alert("CANT SELECT THE SAME ARTISON TWISE");
                document.getElementById('jobcard_user_2').value = -1;

            }

        }
    }


    function add_user() {
        document.getElementById('create_btn').disabled = true;
        jobcard_number = document.getElementById('jobcard_number').value;
        date = document.getElementById('date').value;
        client_id = document.getElementById('client_id').value;
        quote_number = document.getElementById('quote_number').value;
        description = document.getElementById('description').value;
        jobcard_user_1 = document.getElementById('jobcard_user_1').value;
        jobcard_user_2 = document.getElementById('jobcard_user_2').value;
        jobcard_type = document.getElementById('jobcard_type').value;

        inputs = document.getElementsByTagName('input');
        selects = document.getElementsByTagName('select');
        error = 0;

        textarea = document.getElementById('description');
        if (textarea.value == "") {
            textarea.style.border = '2px solid red';
            error = 1;
        } else {
            textarea.style.border = '2px solid green';
        }

        for (var i = 0; i < inputs.length; i++) {
            if (inputs[i].value == "") {
                inputs[i].style.border = '2px solid red';
                error = 1;
            } else {
                inputs[i].style.border = '2px solid green';
            }
        }

        for (var i = 0; i < selects.length; i++) {
            if (selects[i].value == "") {
                selects[i].style.border = '2px solid red';
                error = 1;
            } else {
                selects[i].style.border = '2px solid green';
            }
        }


        if (error == 0) {


            var xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // alert(this.responseText);
                if (this.responseText == 1) {
                    // alert('User added successfully');
                    window.location.href = "jobcard_planning.php?artisan_id=" + document.getElementById('jobcard_user_1').value;
                }

            }
            xhttp.open("GET", '../../ajax/jobcards/create_jobcard.php?jobcard_number=' + jobcard_number + '&date=' + date + '&client_id=' + client_id + '&description=' + description + '&jobcard_user_1=' + jobcard_user_1 + '&jobcard_user_2=' + jobcard_user_2 + '&jobcard_type=' + jobcard_type + '&quote_number=' + quote_number, true);
            xhttp.send();
        } else {
            document.getElementById('create_btn').disabled = false;

        }
    }
</script>