<?php
include "../../classes/qr.class.php";
include "../../classes/app.class.php";

$app = new app();
$qr = new qrcode();
$db = new DBMain();

$find_stock_id = $db->find_stock_id($_GET['qr_code']);

?>
<div class='container flex_container'>
    <h1>STOCK CONTROL</h1>

    <input type='text' id='text_qr' style="display: none;">
    <!--  -->
    <div style='display: flex;'>
        <div style='width:100%;display:flex;flex-direction: row;flex-wrap: nowrap;align-content: center;justify-content: center;align-items: center;'>
            <?php echo $qr->scanner("text_qr", "find_stock_id()", "SCAN STOCK CODE"); ?>
        </div>
        <div class="container flex_container_content" style="border: 1px solid black;padding: 2%; border-radius: 5px; width:100%;">
            <div class='flex_container'>
                <label>STOCK_ID:</label>
                <input type='text' name='stock_id' id='stock_id' readonly>
                <label>IN STOCK:</label>
                <input type='number' name='stock_total' id='stock_total'>
            </div>
            <div class='flex_container'>
                <input type='text' value='IN' readonly style='background-color:white;' onclick="in_out(1)" id='in'>
                <input type='text' value='OUT' readonly style='background-color:white;' onclick="in_out(0)" id='out'>
                <input type='text' readonly value='N' id='in_out' style='display:none'>
            </div>
            <div class='flex_container'>
                <label>QUANTITY:</label>
                <input type='number' name='quantity' id='quantity'>
            </div>
        </div>

    </div>

    <button onclick="check_stock()" hidden disabled id='check_stock_btn'>SUBMIT</button>
</div>

<script>
    function in_out(type) {
        if (type == 1) {
            document.getElementById('in').style.backgroundColor = "Blue";
            document.getElementById('in').style.color = "white";
            document.getElementById('out').style.backgroundColor = "white";
            document.getElementById('out').style.color = "black";

            document.getElementById('in_out').value = "+";
        } else {
            document.getElementById('out').style.backgroundColor = "Blue";
            document.getElementById('out').style.color = "white";
            document.getElementById('in').style.backgroundColor = "white";
            document.getElementById('in').style.color = "black";
            document.getElementById('in_out').value = "-";
        }
    }

    function find_stock_id() {
        text_qr = document.getElementById('text_qr').value;
        var xhttp = new XMLHttpRequest();
        xhttp.onload = function() {
            console.log(this.responseText);
            if (this.responseText == 0) {
                console.log("FAILED");
            } else {
                array_text = this.responseText.split(",");
                document.getElementById('stock_id').value = array_text[0];
                document.getElementById('stock_total').value = array_text[1];
                if (array_text[1] <= 0) {
                    document.getElementById('stock_total').style.backgroundColor = "RED";
                    document.getElementById('out').disabled = true;
                }
                document.getElementById('check_stock_btn').hidden = false;
                document.getElementById('check_stock_btn').disabled = false;
            }
        }
        xhttp.open("GET", '../../ajax/stock/get_stock_id.php?qr_code=' + text_qr);
        xhttp.send();
    }

    function check_stock() {
        quantity = document.getElementById('quantity').value;
        stock_id = document.getElementById('stock_id').value;
        type = document.getElementById('in_out').value;
        if (type == "N") {
            alert("PLEASE CHOOSE A STOCK DIRECTION");
            return;
        }

        error = 0;
        if (error == 0) {

            var xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                alert(this.responseText);
                if (this.responseText == 0) {
                    console.log("FAILED");
                } else if (this.responseText == "O") {
                    alert("NOT ENOUGH IN STOCK FOR REQUIRED BOOKING");
                } else {
                    alert("STOCK BOOKED");
                    window.location.reload();
                }
            }
            xhttp.open("GET", '../../ajax/stock/stock_control.php?stock_id=' + stock_id + '&quantity=' + type + quantity);
            xhttp.send();

        } else {
            document.getElementById('check_stock_btn').disabled = false;
        }
    }
</script>