<?php

include "../../root.class.php";
$html = new html();
$html->add_styles_page();

$db = new db_safeguard();
$get_user_trans = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE user_id = {$_SESSION['user_id']} AND (`status` = 'AUTHORISED' OR `status` = 'INI')");
if ($get_user_trans->num_rows > 0) {
    $data = $get_user_trans->fetch_assoc();
    ?>

    <script>
        window.location.href = 'diesel_transaction.php?transaction_number=<?php echo $data['record_id']; ?>&order_id=<?php echo $data['order_id']; ?>';</script>

    <?php
}

$asset_id = new select();
$asset_id->id("asset_id");
$asset_id->name("asset_id");
$asset_id->required();
$asset_id->style("width: 80%;font-size:3em;");
$asset_id->class("inputs");
$asset_id->fill_from_db("assets", 'record_id', 'name', "company_id = {$_SESSION['company_id']} AND `status` = 1 ORDER BY name ASC");


$asset_barcode = new input();
$asset_barcode->id("asset_barcode");
$asset_barcode->type("text");
$asset_barcode->required();
$asset_barcode->class("inputs");


$odo = new input();
$odo->id("odo");
$odo->type("text");
$odo->required();
$odo->class("inputs");




$barcodeReader = new barcodeReader();

?>


<div class="form_down">
    <label style="font-size: 3em;">SELECT/SCAN ASSET</label>
    <?php
    $asset_id->add();
    $asset_barcode->add();
    $barcodeReader->add_js_function_to_call("check_asset()");
    $barcodeReader->add_button("asset_barcode", 1);
    ?>
    <label style="font-size: 3em;">ASSET ODO</label>
    <?php
    $odo->add();
    ?>
    <label style="font-size: 3em;">SCAN PUMP</label>
    <?php if ($_SESSION['username'] == "DEV") { ?>
        <input type="text" class='inputs' id="barcode" name="barcode">
    <?php } else { ?>
        <input type="text" class='inputs' hidden id="barcode" name="barcode">

    <?php } ?>
    <?php
    $barcodeReader->add_js_function_to_call("go_to_diesel_order()");
    $barcodeReader->add_button("barcode");
    ?>

    <?php if ($_SESSION['username'] == "DEV") { ?>
        <button onclick="go_to_diesel_order()" class="submit_btn">GO</button>
    <?php } else { ?>
        <button onclick="go_to_diesel_order()" hidden class="submit_btn">GO</button>

    <?php } ?>
</div>

<script>
    function go_to_diesel_order() {
        let asset_id = document.getElementById("asset_id").value;
        let barcode = document.getElementById("barcode").value;
        let odo = document.getElementById("odo").value;

        if (asset_id == "" || barcode == "" || odo == "") {
            if (asset_id == "") {
                document.getElementById("asset_id").style.backgroundColor = "red";
                document.getElementById("asset_id").placeholder = "Please select an asset";
            }
            if (barcode == "") {
                document.getElementById("barcode").style.backgroundColor = "red";
                document.getElementById("barcode").placeholder = "Please scan a pump";
            }
            if (odo == "") {
                document.getElementById("odo").style.backgroundColor = "red";
                document.getElementById("odo").placeholder = "Please enter the odometer reading";
            }
            return;
        }
        let formData = new FormData();
        formData.append('asset_id', asset_id);
        formData.append('barcode', barcode);
        formData.append('odo', odo);

        fetch('diesel_order.ajax.php', {
            method: 'POST',
            body: formData
        })
            .then(response => response.text())
            .then(data => {
                console.log(data);
                if (data.includes("transaction_number=")) {
                    window.location = data;
                } else {
                    // Handle error or missing transaction number
                    console.error('Transaction number not received');
                }
            })
            .catch(error => console.error('Error:', error));
    }

    function check_asset() {
        let asset_barcode = document.getElementById("asset_barcode").value;
        console.log(asset_barcode);
        let formData = new FormData();
        formData.append('asset_barcode', asset_barcode);

        fetch('asset_barcode.ajax.php', {
            method: 'POST',
            body: formData
        })
            .then(response => response.text())
            .then(data => {
                console.log(data);
                if (data == "0") {
                    window.location = data;
                    alert("ASSET NOT FOUND OR INACTIVE");
                } else {
                    // Handle error or missing transaction number

                    document.getElementById("asset_id").value = data;
                }
            })
            .catch(error => console.error('Error:', error));
    }
</script>