<?php

include '../../fpdf.php';
include "../../root.class.php";
$functions = new functions();
$total_stock_value = 0.00;
$db = new db_safeguard();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(95, 5, "DIESEL ORDER REPORT", "B", 1, 'L');
$logo_file_check = $db->query("companies", "SELECT * FROM companies WHERE record_id = {$_SESSION['company_id']} AND logo_file != ''");
if ($logo_file_check->num_rows > 0) {
    $logo_file = "../company/logos/" . $logo_file_check->fetch_assoc()['logo_file'];
} else {
    $logo_file = "../../icons/logo.png";
}
$pdf->Image($logo_file, 165, 5, 35, 21);
$pdf->Cell(50, 15, "", "", 1, 'L');

$pdf->SetFont('Arial', '', 5);

$pdf->SetFont('Arial', 'B', 5);
$pdf->Cell(20, 5, "STATUS", "BR", 0, 'L');
$pdf->Cell(11, 5, "ORDER ID", "BR", 0, 'L');
$pdf->Cell(30, 5, "CLIENT", "BR", 0, 'L');
$pdf->Cell(15, 5, "USER", "BR", 0, 'L');
$pdf->Cell(18, 5, "OPENED", "BR", 0, 'L');
$pdf->Cell(18, 5, "CLOSED", "BR", 0, 'L');
$pdf->Cell(20, 5, "AMOUNT", "BR", 0, 'L');
$pdf->Cell(20, 5, "VALUE", "BR", 0, 'L');
$pdf->Cell(12, 5, "R\L", "BR", 0, 'L');
$pdf->Cell(12, 5, "CASH TYPE", "BR", 0, 'L');

$pdf->Cell(12, 5, "TANK", "BR", 0, 'L');

$pdf->Ln();
$pdf->SetFont('Arial', '', 5);
$data = $_GET['where_data'];

$latest_orders_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE $data AND amount > 20 ORDER BY date_time_closed DESC");
$total_amount = 0;
$transactions_total = 0;
$total_value = 0;

$cash_total = 0;
$total_cash = 0;
$cash_liters = 0;

$eft_total = 0;
$total_eft = 0;
$eft_liters = 0;

$card_total = 0;
$total_card = 0;
$card_liters = 0;

$na_total = 0;
$total_na = 0;
$na_liters = 0;

while ($latest_orders = $latest_orders_res->fetch_assoc()) {
    $pdf->Cell(20, 5, $latest_orders['status'], 0, 0, 'L');
    $pdf->Cell(11, 5, $latest_orders['order_id'], 0, 0, 'L');
    $pdf->Cell(30, 5, $functions->get_client_name($latest_orders['client_id']), 0, 0, 'L');
    $pdf->Cell(15, 5, $functions->get_username($latest_orders['user_id']), 0, 0, 'L');
    $pdf->Cell(18, 5, $latest_orders['date_time_opened'], 0, 0, 'L');
    $pdf->Cell(18, 5, $latest_orders['date_time_closed'], 0, 0, 'L');
    $pdf->Cell(20, 5, ($latest_orders['amount'] / 1000) . " L", 0, 0, 'L');
    $pdf->Cell(20, 5, 'R' . ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'], 0, 0, 'L');
    $pdf->Cell(12, 5, 'R' . $latest_orders['fuel_price'], 0, 0, 'L');
    $total_amount += $latest_orders['amount'];
    $total_value += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
    $pdf->Cell(12, 5, $functions->get_cash_type($latest_orders['cash_type']), 0, 0, 'L');
    $pdf->Cell(12, 5, $functions->get_tank_name($latest_orders['tank_id']), 0, 1, 'L');
    $transactions_total++;
    if ($latest_orders['cash_type'] == 1) {
        $cash_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_cash++;
        $cash_liters += ($latest_orders['amount'] / 1000);
    } else if ($latest_orders['cash_type'] == 3) {
        $eft_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_eft++;
        $eft_liters += ($latest_orders['amount'] / 1000);
    } else if ($latest_orders['cash_type'] == 2) {
        $card_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_card++;
        $card_liters == ($latest_orders['amount'] / 1000);
    } else {
        $na_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_na++;
        $na_liters += ($latest_orders['amount'] / 1000);
    }

}
$pdf->SetFont('Arial', 'B', 7);

$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "CASH", "TR", 0, 'L');
$pdf->Cell(20, 5, number_format($cash_liters, 2) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, "R " . number_format($cash_total, 2), "TR", 0, 'L');
$pdf->Cell(20, 5, $total_cash, "TR", 1, 'L');
$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "CARD", "TR", 0, 'L');
$pdf->Cell(20, 5, number_format($card_liters, 2) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, "R " . number_format($card_total, 2), "TR", 0, 'L');
$pdf->Cell(20, 5, $total_card, "TR", 1, 'L');
$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "EFT", "TR", 0, 'L');
$pdf->Cell(20, 5, number_format($eft_liters, 2) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, "R " . number_format($eft_total, 2), "TR", 0, 'L');
$pdf->Cell(20, 5, $total_eft, "TR", 1, 'L');
$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "N/A", "TR", 0, 'L');
$pdf->Cell(20, 5, number_format($na_liters, 2) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, "R " . number_format($na_total, 2), "TR", 0, 'L');
$pdf->Cell(20, 5, $total_na, "TR", 1, 'L');

$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "TOTAL", "TR", 0, 'L');
$pdf->Cell(20, 5, number_format(($total_amount / 1000), 2) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, "R " . number_format($total_value, 2), "TR", 0, 'L');
$pdf->Cell(20, 5, $transactions_total, "TR", 1, 'L');

$pdf->Output("I");