<?php
include "db.class.php";
$db = new db();
// Check if this request is for manual override
if (isset($_GET['manual_override_json'])) {

    // Get the raw POSTed JSON data
    $json = file_get_contents('php://input');

    // Decode the JSON
    $data = json_decode($json, true);

    if ($data === null) {
        // Failed to parse JSON
        http_response_code(400); // Bad Request
        echo "INVALID_JSON";
        exit;
    }

    echo $_GET['unit_id'] . " - " . $data['timestamp'] . " - " . $data['type'] . " - " . $data['pulse'] . " - " . $data['rfid'];
    // get pump data
    $tank_res = $db->query("SELECT * FROM tanks WHERE unit_code = '" . $_GET['unit_id'] . "'");
    $tank = $tank_res->fetch_assoc();
    $company_id = $tank['company_id'];
    $tank_id = $tank['record_id'];
    // check frid tag on database
    if ($data['rfid'] != "") {
        $client_res = $db->query("SELECT * FROM clients WHERE client_rfid_tag = '" . $data['rfid'] . "' AND company_id = '" . $company_id . "'");
        $client = $client_res->fetch_assoc();
        $client_id = (int) $client['record_id'] ?: 0;
    } else {
        $client_id = 0;
    }
    
    // get liters calculated
    $tank_ml_per_pulse = $tank['flow_meter_calibration'];
    $mililiters = $data['pulse'] * $tank_ml_per_pulse;
    // get_latest_order_id from database
    $order_Num_res = $db->query("SELECT * FROM fuel_movement WHERE company_id = '" . $company_id . "' ORDER BY record_id DESC LIMIT 1");
    $order_Num = $order_Num_res->fetch_assoc();
    $order_id = $order_Num['order_id'] + 1;
    // get fuel price from company details
    $company_res = $db->query("SELECT * FROM companies WHERE record_id = '" . $company_id . "'");
    $company = $company_res->fetch_assoc();
    $price = $company['fuel_price'];
    if ($data['type'] == "DONE") {
        $record_id = $db->query("UPDATE `fuel_movement` SET `date_time_closed` = '{$data['timestamp']}', `status` = 'DONE',`pulses` = {$data['pulse']}, `amount` = '$mililiters' WHERE `tank_id` = $tank_id AND `status` = 'INI'");
        echo "ACCEPTED";

    } else {
        // check if this tran already exists

        // insert data to fuel movement
        // Respond to ESP32
        $check_duplicate = $db->query("SELECT * FROM `fuel_movement` WHERE `tank_id` = $tank_id AND `status` = '{$data['type']}' AND `date_time_closed` = '{$data['timestamp']}' AND `date_time_opened` = '{$data['timestamp']}' AND `user_id` = 0 AND `flow_rate` = 0 AND `pulses` = {$data['pulse']} AND `client_id` = $client_id AND `order_id` = $order_id AND `company_id` = $company_id AND `fuel_price` = $price");
        if ($check_duplicate->num_rows == 0) {
            $record_id = $db->query("INSERT INTO `fuel_movement`( `tank_id`, `amount`, `status`, `date_time_opened`, `date_time_closed`, `user_id`, `flow_rate`, `pulses`, `client_id`, `order_id`, `company_id`, `fuel_price`) VALUES ($tank_id,'$mililiters','{$data['type']}','{$data['timestamp']}','{$data['timestamp']}',0,0,{$data['pulse']},$client_id,$order_id,$company_id,$price)");
            if ($record_id > 0) {
                echo "ACCEPTED";
            } else {
                echo "FAILED";
            }
        }
        $check_duplicate = $db->query("SELECT * FROM `fuel_movement` WHERE `tank_id` = $tank_id AND `status` = '{$data['type']}' AND `date_time_closed` = '{$data['timestamp']}' AND `date_time_opened` = '{$data['timestamp']}' AND `user_id` = 0 AND `flow_rate` = 0 AND `pulses` = {$data['pulse']} AND `client_id` = $client_id AND `order_id` = $order_id AND `company_id` = $company_id AND `fuel_price` = $price");
        if ($check_duplicate->num_rows > 1) {
            $index = 0;
            while ($duplicate = $check_duplicate->fetch_assoc()) {
                if ($index > 0) {
                    $db->query("DELETE FROM `fuel_movement` WHERE `record_id` = {$duplicate['record_id']}");
                }
                $index++;

            }
            // delete the first record
            // $db->query("DELETE FROM `fuel_movement` WHERE `tank_id` = $tank_id AND `status` = '{$data['type']}' AND `date_time_closed` = '{$data['timestamp']}' AND `date_time_opened` = '{$data['timestamp']}' AND `user_id` = 0 AND `flow_rate` = 0 AND `pulses` = {$data['pulse']} AND `client_id` = $client_id AND `order_id` = $order_id AND `company_id` = $company_id AND `fuel_price` = $price LIMIT 1");
        }


    }

}

if (isset($_GET['authorisation'])) {
    // DATE NOW TO OPEN TRANSACTION
    $date = date('Y-m-d H:i', strtotime("+ 2 hours"));
    // INSERT INTO DEVICE LOG
    // $db->insert("INSERT INTO device_log (`device_id`,`text`,`date_time`) VALUES ('{$_GET['authorisation']}','AUTH CHECK','$date')");
    // TAKE ARDUINO ID SUPPLIED FROM THE ARDUINO AND FIND ITS TANK ID
    $tank_res = $db->exec_query("tanks", ['*'], '', '', '', '', "unit_code = '{$_GET['authorisation']}'", " ORDER BY record_id ASC LIMIT 1", false);
    $tank_info = $tank_res->fetch_assoc();

    // CHECK IF THERE IS A OPEN TRANSACITON WITH THAT TANK ID
    $check_for_authorisation = $db->exec_query("fuel_movement", ['*'], '', '', '', '', "tank_id = {$tank_info['record_id']} AND `status` = 'AUTHORISED' ", " ORDER BY record_id ASC LIMIT 1", false);
    if ($check_for_authorisation->num_rows > 0) {
        $transaction = $check_for_authorisation->fetch_assoc();
        // SEND TRAN ID AND AUTHORISED TO ARDUINO
        echo "AUTHORISED";
        // UPDATE TRANSACTION STATUS TO INITIALISED
        $res = $db->Update('fuel_movement', ['status', 'date_time_opened'], ['INI', "$date"], "record_id = {$transaction['record_id']}");
    } else {
        echo "NOTHING";
    }
}


// GET INFO FROM ARDUINO ABOUT TANK CURRENT MEASUREMNT
if (isset($_GET['tank_level'])) {
    // DATE NOW TO OPEN TRANSACTION
    $date = date('Y-m-d H:i', strtotime("+ 2 hours"));
    // INSERT INTO DEVICE LOG
    // $db->insert("INSERT INTO device_log (`device_id`,`text`,`date_time`) VALUES ('{$_GET['tank_level']}','TANK LEVEL UPDATE','$date')");
    // TAKE ARDUINO ID SUPPLIED FROM THE ARDUINO AND FIND ITS TANK ID
    $tank_res = $db->exec_query("tanks", ['*'], '', '', '', '', "unit_code = '{$_GET['tank_level']}'");
    $tank_info = $tank_res->fetch_assoc();

    // INSERT MEASUREMENT INTO TANK
    $db->insert("INSERT INTO tank_level_log (`tank_id`,`distance`,`date_time_measured`) VALUES ({$tank_info['record_id']},'{$_GET['distance']}','$date')");
    // echo "INSERT INTO tank_level_log (`tank_id`,`distance`,`date_time_measured`) VALUES ({$tank_info['record_id']},'{$_GET['distance']}','$date')";
    echo "ACCEPTED";

}


// GET INFO FROM ARDUINO ABOUT TANK CURRENT MEASUREMNT
if (isset($_GET['settings'])) {
    // DATE NOW TO OPEN TRANSACTION
    $date = date('Y-m-d H:i', strtotime("+ 2 hours"));
    // INSERT INTO DEVICE LOG
    // $db->insert("INSERT INTO device_log (`device_id`,`text`,`date_time`) VALUES ('{$_GET['settings']}','REQUEST SETTINGS','$date')");
    // TAKE ARDUINO ID SUPPLIED FROM THE ARDUINO AND FIND ITS TANK ID
    $tank_res = $db->query("SELECT * FROM tanks WHERE unit_code = '" . $_GET['settings'] . "'");
    $tank = $tank_res->fetch_assoc();
    $company_id = $tank['company_id'];
    // get company details
    $company_res = $db->query("SELECT * FROM companies WHERE record_id = $company_id");
    $company = $company_res->fetch_assoc();
    $price = $company['fuel_price'];
    // get all client tags from database
    $tags_res = $db->query("SELECT * FROM clients WHERE company_id = $company_id AND (client_rfid_tag != '0' OR client_rfid_tag != \"'0'\")");
    $tag = [];
    while ($tags = $tags_res->fetch_assoc()) {
        $tag[] = $tags['client_rfid_tag'];
    }
    $tag = implode(",", $tag);

    echo "ta:," . $tag . ",:at t:" . $tank['pump_cutoff_time'] . ":t c:" . $tank['flow_meter_calibration'] . ":c r:" . $price . ":r   AUTHORISED";
}

// if (isset($_GET['rfid_system'])) {
//     // get tank_details
//     $tank_res = $db->query("SELECT * FROM tanks WHERE unit_code = '" . $_GET['rfid_system'] . "'");
//     $tank = $tank_res->fetch_assoc();
//     $tank = $tank['record_id'];
//     // check if tag is requested
//     $tag_request_res = $db->query("SELECT * FROM client_rfid_reg_system WHERE tank_id = $tank AND `status` = 0");
//     if ($tag_request_res->num_rows > 0) {
//         echo "AUTHORISED";
//     }
// }

// if (isset($_GET['check_rfid'])) {
//     $rfid = $_GET['rfid'];
//     $tank_code = $_GET['check_rfid'];
//     // get tank details
//     $tank_res = $db->query("SELECT * FROM tanks WHERE unit_code = '" . $tank_code . "'");
//     $tank = $tank_res->fetch_assoc();
//     $tank_id = $tank['record_id'];
//     $company_id = $tank['company_id'];
//     // check if tag is requested
//     $client_res = $db->query("SELECT * FROM clients WHERE client_rfid_tag = '" . $rfid . "' AND company_id = $company_id");
//     if ($client_res->num_rows == 0) {
//         // get client_id 
//         $client_id_res = $db->query("SELECT * FROM client_rfid_reg_system WHERE tank_id = $tank_id AND `status` = '0' ");
//         $client = $client_id_res->fetch_assoc();
//         $client_id = $client['client_id'];
//         // update client to new RFID
//         $res = $db->update('clients', ['client_rfid_tag'], ["$rfid"], "record_id = $client_id");
//         $res1 = $db->update('client_rfid_reg_system', ['status'], [1], "record_id = {$client['record_id']}");

//         if ($res && $res1) {
//             echo "AUTHORISED";
//         } else {
//             echo "FAILED";
//         }
//     }
// }
?>