<?php

include "../../root.class.php";
$functions = new functions();
$total_stock_value = 0.00;
$db = new db_safeguard();

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="diesel_order_report.csv"');

$output = fopen('php://output', 'w');

// Add the header row
fputcsv($output, [
    'STATUS',
    'CLIENT',
    'USER',
    'OPENED',
    'CLOSED',
    'AMOUNT (L)',
    'VALUE (R)',
    'R\L',
    'CASH TYPE',
    'TANK'
]);

$data = $_GET['where_data'];

$latest_orders_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE $data AND amount > 50 ORDER BY date_time_closed DESC");
$total_amount = 0;
$transactions_total = 0;
$total_value = 0;


$cash_total = 0;
$total_cash = 0;
$cash_liters = 0;

$eft_total = 0;
$total_eft = 0;
$eft_liters = 0;

$card_total = 0;
$total_card = 0;
$card_liters = 0;

$na_total = 0;
$total_na = 0;
$na_liters = 0;
while ($latest_orders = $latest_orders_res->fetch_assoc()) {

    fputcsv($output, [
        $latest_orders['status'],
        $functions->get_client_name($latest_orders['client_id']),
        $functions->get_username($latest_orders['user_id']),
        $latest_orders['date_time_opened'],
        $latest_orders['date_time_closed'],
        ($latest_orders['amount'] / 1000),
        ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'],
        $latest_orders['fuel_price'],
        $functions->get_cash_type($latest_orders['cash_type']),

        $functions->get_tank_name($latest_orders['tank_id'])
    ]);
    if ($latest_orders['cash_type'] == 1) {
        $cash_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_cash++;
        $cash_liters += ($latest_orders['amount'] / 1000);
    } else if ($latest_orders['cash_type'] == 3) {
        $eft_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_eft++;
        $eft_liters += ($latest_orders['amount'] / 1000);
    } else if ($latest_orders['cash_type'] == 2) {
        $card_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_card++;
        $card_liters += ($latest_orders['amount'] / 1000);
    } else {
        $na_total += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
        $total_na++;
        $na_liters += ($latest_orders['amount'] / 1000);
    }
    $total_amount += $latest_orders['amount'];
    $total_value += ($latest_orders['amount'] / 1000) * $latest_orders['fuel_price'];
    $transactions_total++;
}

// Add the totals row
fputcsv($output, [
    '',
    '',
    '',
    '',
    '',
    ''
]);

// Add the totals row
fputcsv($output, [
    'TOTALS GROUPED BY TYPES',
    '',
    '',
    '',
    '',
    ''
]);

fputcsv($output, [
    '',
    '',
    '',
    '',
    '',
    ''
]);
fputcsv($output, [
    'TYPE',
    '',
    '',
    '',
    '',
    '',
    'Liters',
    'Value (R)',
    'Amount'
]);

// Add the totals row
fputcsv($output, [
    'CASH',
    '',
    '',
    '',
    '',
    '',
    number_format(($cash_liters), 2) . " L",
    number_format($cash_total, 2),
    $total_cash
]);


// Add the totals row
fputcsv($output, [
    'CARD',
    '',
    '',
    '',
    '',
    '',
    number_format(($card_liters), 2) . " L",
    number_format($card_total, 2),
    $total_card
]);


// Add the totals row
fputcsv($output, [
    'EFT',
    '',
    '',
    '',
    '',
    '',
    number_format(($eft_liters), 2) . " L",
    number_format($eft_total, 2),
    $total_eft
]);


// Add the totals row
fputcsv($output, [
    'N/A',
    '',
    '',
    '',
    '',
    '',
    number_format(($na_liters), 2) . " L",
    number_format($na_total, 2),
    $total_na
]);


// Add the totals row
fputcsv($output, [
    'TOTAL',
    '',
    '',
    '',
    '',
    '',
    number_format(($total_amount / 1000), 2) . " L",
    number_format($total_value, 2),
    $transactions_total
]);

fclose($output);
exit;
