<?php

include "../../root.class.php";
$functions = new functions();
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

echo DashboardWidget::includeAssets();


$sites_res = $db->query("sites", "SELECT * FROM sites WHERE company_id = {$_SESSION['company_id']}");
while ($site = $sites_res->fetch_assoc()) {
    ?>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <h1><?php echo $site['name']; ?></h1>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <?php
    $tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE site_id = {$site['record_id']}");

    while ($tank = $tank_res->fetch_assoc()) {
        ?>
        <div class="column" style="width: 100%">
            <div style="display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: space-evenly;
        align-items: center;">



                <h2><u><?php echo $tank['name']; ?></u></h2>

                <?php
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') ORDER BY record_id DESC LIMIT 10");

                $data_array = [];

                while ($fuel_movement = $fuel_movement_array_res->fetch_assoc()) {
                    $data_array[] = [$fuel_movement['amount'], $fuel_movement['date_time_closed']];
                }

                echo DashboardWidget::columnGraph('LATEST READINGS', $data_array, '90vw');


                $lastSixMonths = [];
                for ($i = 0; $i >= 5; $i++) {
                    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

                }
                $amounts_arr = [];
                foreach ($lastSixMonths as $key => $month) {
                    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31'");
                    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month.'-01'))];
                }

                // echo DashboardWidget::lineGraph(
                //     'PRODUCTION OVER TIME',
                //     $lastSixMonths,
                //     $amounts_arr,
                //     'Liters'
                // );
        
                echo DashboardWidget::columnGraph('Monthly Reports', $amounts_arr, '90vw');


                $tank_level_res = $db->query("tank_level_log", "SELECT * FROM tank_level_log WHERE tank_id = {$tank['record_id']} ORDER BY record_id DESC LIMIT 1");
                $tank_level = $tank_level_res->fetch_assoc();

                $data = $functions->calculate_horizontal_cylinder_volume($tank['radius_mm'], (($tank['radius_mm'] * 2) - $tank_level['distance']), $tank['length_mm']);

                echo DashboardWidget::circleGraph("TANK LEVEL", 0, 100, $data['percentage_filled']);
                ?>
            </div>


            <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
            <?php
    }


}
?>