<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Multi iFrame Monitor</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 20px;
        }

        h1 {
            text-align: center;
            margin-bottom: 20px;
        }

        .container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
        }

        @media(max-width: 900px) {
            .container {
                grid-template-columns: 1fr;
            }
        }

        .frame-box {
            background: #ffffff;
            padding: 12px;
            border-radius: 10px;
            box-shadow: rgba(0, 0, 0, 0.15) 0px 4px 10px;
            position: relative;
        }

        iframe {
            width: 100%;
            height: 300px;
            /* Slightly larger default */
            border: 0;
            border-radius: 6px;
            resize: both;
            /* Allow dragging in both directions */
            overflow: auto;
            /* Required for resizing */
            min-height: 150px;
            /* Don't get too tiny */
            max-height: 1000px;
            /* Control max expand size */
        }

        .controls {
            display: flex;
            gap: 6px;
            margin-bottom: 8px;
            flex-wrap: wrap;
        }

        select,
        input,
        button {
            padding: 5px;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 14px;
        }

        button {
            cursor: pointer;
            background: #007bff;
            color: white;
            border: none;
        }

        button.stop {
            background: #d9534f;
        }

        .loading {
            position: absolute;
            top: 54px;
            left: 12px;
            right: 12px;
            bottom: 12px;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 18px;
            font-weight: bold;
            border-radius: 6px;
            opacity: 0;
            pointer-events: none;
            transition: opacity .3s;
        }

        .loading.active {
            opacity: 1;
            pointer-events: auto;
        }
    </style>
</head>

<body>

    <h1>Multi iFrame Auto Monitor</h1>

    <div class="container" id="iframesContainer"></div>

    <script>
        // ⬇️ Add any URLs you want to monitor here
        const urlList = [
            "URL",
            "https://fuelsupplier.elegantwork.co.za",
            "https://jev.elegantwork.co.za",
            "https://mas.elegantwork.co.za",
            "https://muell.elegantwork.co.za",
            "https://api.elegantwork.co.za/water/app.php?vincent&reinhard"
        ];


        const container = document.getElementById("iframesContainer");

        function createFrameBox(index) {
            const frameBox = document.createElement("div");
            frameBox.className = "frame-box";

            frameBox.innerHTML = `
        <div class="controls">
            <select class="url-select"></select>
            <input type="number" min="2" value="5" class="seconds-input" style="width:70px;" title="Refresh Seconds">
            <button class="start-btn">Start</button>
            <button class="stop btn stop">Stop</button>
        </div>
        <iframe></iframe>
        <div class="loading">Loading...</div>
    `;

            const select = frameBox.querySelector(".url-select");
            const iframe = frameBox.querySelector("iframe");
            const loading = frameBox.querySelector(".loading");
            const startBtn = frameBox.querySelector(".start-btn");
            const stopBtn = frameBox.querySelector(".stop");

            // Populate dropdown
            urlList.forEach(url => {
                const opt = document.createElement("option");
                opt.value = url;
                opt.textContent = url;
                select.appendChild(opt);
            });

            let interval;

            function loadFrame() {
                loading.classList.add("active");
                iframe.src = select.value;
            }

            // When the iframe finishes loading → hide overlay
            iframe.onload = () => loading.classList.remove("active");

            // ⬇️ NEW: Load page when URL is selected
            select.onchange = () => {
                clearInterval(interval);
                loadFrame();
            };

            startBtn.onclick = () => {
                const sec = parseInt(frameBox.querySelector(".seconds-input").value);
                if (sec < 2) return alert("Min 2 seconds");
                loadFrame();
                clearInterval(interval);
                interval = setInterval(loadFrame, sec * 1000);
            };

            stopBtn.onclick = () => clearInterval(interval);

            return frameBox;
        }

        // Create 6 monitor panels
        for (let i = 0; i < 2; i++) {
            container.appendChild(createFrameBox(i));
        }
    </script>

</body>

</html>