<?php

include "../../classes/autoload.php";

$html = new html("");

$app = new inner_app();
$app->quick_bar("/app/stock/");
$app->app_start();

$categories_res = $db->query("stock", "SELECT DISTINCT stock_categories FROM stock WHERE 1 ORDER BY stock_categories ASC");
$list = "<datalist id='categories'>";
while ($categories = $categories_res->fetch_assoc()) {
    $list .= "<option value='" . $categories['stock_categories'] . "'></option>";
}
echo $list .= "</datalist>";

?>


<div class="column width_80 background_1 border_radius">

    <h1>NEW STOCK ITEM</h1>
    <div class="row width_80">
        <div class="column width_50">
            <label>CODE</label>
            <input type="text" class="width_80" id='code' name='code' />
            <label>NAME</label>
            <input type="text" class="width_80" id='name' name='name' />
            <label>COST PRICE</label>
            <input type="text" class="width_80" id='cost' name='cost' />
            <label>RETAIL PRICE</label>
            <input type="text" class="width_80" id='retail' name='retail' />
            <label>CONTRACTOR PRICE</label>
            <input type="text" class="width_80" id='contractors' name='contractors' />
            <label>SHOP PRICE</label>
            <input type="text" class="width_80" id='shops' name='shops' />
            <label>UNIT OF MEASURE</label>
            <input type="text" class="width_80" id='unit_of_measure' name='unit_of_measure' />
            <label>CATEGORY</label>
            <input type="text" list="categories" class="width_80" id='stock_categories' name='stock_categories' />
            <label>STATUS</label>
            <select name="status" id="status">
                <?php
                $function->get_status();
                ?>
            </select>
            <label>SUPPLIER</label>
            <select name="supplier_id" id="supplier_id">
                <?php
                $function->get_suppliers();
                ?>
            </select>
        </div>
    </div>
    <br>
    <button class="width_90" onclick="save('save_stock.php')">SAVE</button>
    <br>

</div>


<script>
    function save(url) {
        var elements = document.getElementsByTagName('input');
        var payload = {};
        for (var i = 0; i < elements.length; i++) {
            var element = elements[i];
            if (element.type === 'text' || element.type === 'date' || element.type === 'email') {
                payload[element.name] = element.value;
            }
        }

        var elements = document.getElementsByTagName('select');
        for (var i = 0; i < elements.length; i++) {
            var element = elements[i];

            payload[element.name] = element.value;

        }

        var form = document.createElement('form');
        form.method = 'POST';
        form.action = url;

        for (var key in payload) {
            if (payload.hasOwnProperty(key)) {
                var input = document.createElement('input');
                input.type = 'hidden';
                input.name = key;
                input.value = payload[key];

                form.appendChild(input);
            }
        }

        document.body.appendChild(form);
        form.submit();
    }
</script>