<?php

include "../../classes/autoload.php";

$html = new html("");

$app = new inner_app();
$app->quick_bar("/app/quotes/");
$app->app_start();

$quote_res = $db->query('quotes', "SELECT * FROM quotes WHERE record_id = '{$_GET['record_id']}'");
$quote = $quote_res->fetch_assoc();

$function->get_stock_datalist("stock_list");

$client_res = $db->query("clients", "SELECT * FROM clients WHERE record_id = '{$quote['client_id']}'");
$client = $client_res->fetch_assoc();

?>

<script>
    function get_unit_of_measure(input, i) {
        let xhr = new XMLHttpRequest();
        xhr.open("POST", "get_unit_of_measure.ajax.php", true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                console.log(xhr.responseText);
                document.getElementById("unit_of_measure_" + i).value = xhr.responseText.split(',')[0];
                document.getElementById("retail_price_" + i).value = xhr.responseText.split(',')[1];
                calculateRow(document.getElementById("retail_price_" + i), i);
                document.getElementById("retail_price_" + i).value =document.getElementById("retail_price_" + i).value.replace(",",".");

            }
        };
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhr.send("record_id=" + input.value);
    }

    function calculateRow(input, i) {
        let qty = parseFloat(document.querySelector(`#table #unit_of_measure_${i}`).parentNode.parentNode.querySelector("[name='qty[]']").value) || 0;
        let price = parseFloat(document.getElementById("retail_price_" + i).value) || 0;
        let total = qty * price;
        document.getElementById("total_" + i).value = total.toFixed(2);
        document.getElementById("total_" + i).value =  document.getElementById("total_" + i).value.replace(",",".");
        calculateTotals();
    }

    function calculateTotals() {
        let totals = document.querySelectorAll("[id^='total_']");
        let subtotal = 0;
        totals.forEach(t => {
            subtotal += parseFloat(t.value) || 0;
        });
        let vat = subtotal * 0.15;
        let net_total = subtotal + vat;

        document.getElementById("subtotal").value = subtotal.toFixed(2);
        document.getElementById("subtotal").value = document.getElementById("subtotal").value.replace(",",".");
        document.getElementById("vat").value = vat.toFixed(2);
        document.getElementById("vat").value = document.getElementById("vat").value.replace(",",".");
        document.getElementById("net_total").value = net_total.toFixed(2);
        document.getElementById("net_total").value = document.getElementById("net_total").value.replace(",",".");
    }
</script>

<div class="column width_90 background_1 border_radius">

    <h1>QUOTE NO. <?php echo $quote['quote_number']; ?></h1>
    <div class="row column_gap_2 width_80">
        <div class="column  width_50">
            <label>CLIENT</label>
            <?php
            $function->get_clients_datalist('clients_list');
            ?>
            <input class="width_80" id='client_id' hidden name='client_id' />
            <input class="width_80" id='client_name' required name='client_name' autocomplete="off"
                onchange="get_client_name(this)" list="clients_list" />
            <script>
                function get_client_name(el) {
                    let selected = el.value;
                    let options = document.getElementById("clients_list").options;
                    let found = false;
                    for (let i = 0; i < options.length; i++) {
                        if (options[i].value == selected) {
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        let data = selected.split(":");
                        document.getElementById("client_id").value = data[1];
                        document.getElementById("client_name").value = data[0];
                    } else {
                        alert("Please select a client from the list");
                        document.getElementById("client_id").value = '';
                        el.value = "";
                    }
                }
            </script>
            <script>
                document.getElementById("client_id").value = "<?php echo $quote['client_id']; ?>";
                document.getElementById("client_name").value = "<?php echo $client['name']; ?>";
            </script>
        </div>
        <div class="column  width_50">
            <label>ORDER TYPE</label>
            <select name="order_type" onchange="change_terms(this.value)" id="order_type">
                <option></option>
                <option>SUPPLY</option>
                <option>SUPPLY & INSTALL</option>
                <option>SUPPLY & DELIVERY</option>
            </select>
            <script>
                document.getElementById("order_type").value = "<?php echo $quote['order_type']; ?>";
            </script>
            <script>
                function change_terms(val) {
                    if (val == "SUPPLY" || val == "SUPPLY & DELIVERY") {

                        document.getElementById("additional_delivery_details").style.display = "block";
                    } else {

                        document.getElementById("additional_delivery_details").style.display = "none";

                    }
                }
            </script>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_50">
            <label>DATE CREATED</label>
            <input type="text" value="<?php echo $quote['date_time_created']; ?>" class="width_80" readonly>
            <input type="text" hidden name="record_id" value="<?php echo $quote['record_id']; ?>" class="width_80"
                readonly>
        </div>
        <div class="column  width_50">
            <label>USER CREATED</label>
            <select name="user_id" id="user_id">
                <?php
                $function->get_users();
                ?>
            </select>
            <script>
                document.getElementById("user_id").value = "<?php echo $quote['user_id']; ?>";
            </script>

        </div>
    </div>
    <div class="row column_gap_2 width_80" id="additional_delivery_details">
        <div class="column  width_100">
            <label>ADDITIONAL DELIVERY DETAILS</label>
            <textarea name="additional_delivery_details" class="width_100"
                rows="2"><?php echo $quote['additional_delivery_details']; ?></textarea>
        </div>
    </div>
    <script>
        change_terms(document.getElementById("order_type").value);
    </script>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>AREA</label>
            <textarea name="area" class="width_100" rows="2"><?php echo $quote['area']; ?></textarea>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>SUBJECT</label>
            <textarea name="subject" class="width_100" rows="4"><?php echo $quote['subject']; ?></textarea>
        </div>
    </div>
    <br>
    <button class="width_90" onclick="add_row()">ADD NEW ROW</button>
    <br>
    <table class="width_80" id="table">
        <thead>
            <tr>
                <th>Colour & Code</th>
                <th>Description</th>
                <th>U.O.M</th>
                <th>Qty</th>
                <th>Size m</th>
                <th>Panels</th>
                <th>Amount</th>
                <th>Total</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $quote_list_res = $db->query("quote_list", "SELECT * FROM quote_list WHERE quote_id = '{$_GET['record_id']}'");
            $index = 1;
            while ($quote_list = $quote_list_res->fetch_assoc()) {
                $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = '{$quote_list['stock_id']}'");
                $stock = $stock_res->fetch_assoc();
                ?>
                <tr>
                    <td>
                        <input class="background_1  padding_minmal border_1"
                            style="color:white; width: 8vw;font-size: 0.9em;" id="stock_code_<?php echo $index; ?>"
                            onchange="get_unit_of_measure(this,<?php echo $index; ?>)" list="stock_list" name="stock_id[]"
                            value="<?php echo $stock['code']; ?>">
                    </td>
                    <td>
                        <input class=" background_1 padding_minmal border_1"
                            style="color:white;font-size: 0.9em;width:20vw;" 
                            value="<?php echo $stock['name']; ?>" id="stock_<?php echo $index; ?>" list="stock_list"
                            onchange="get_unit_of_measure(this,<?php echo $index; ?>)">
                    </td>
                    <td>
                        <input class="background_1  padding_minmal border_1" readonly
                            style="color:white; width: 6vw;font-size: 0.9em;" type="text"
                            id="unit_of_measure_<?php echo $index; ?>" name="unit_of_measure[]"
                            value="<?php echo $stock['unit_of_measure']; ?>">
                    </td>
                    <td>
                        <input class="background_1 width_90 padding_minmal border_1"
                            style="color:white; width:5vw;font-size: 0.9em;" type="text" name="qty[]"
                            id="qty_<?php echo $index; ?>" oninput="calculateRow(this,<?php echo $index; ?>)"
                            value="<?php echo $quote_list['qty']; ?>">
                    </td>
                    <td>
                        <input class="background_1 width_90 padding_minmal border_1"
                            style="color:white; width:5vw;font-size: 0.9em;" type="text" name="size_m[]"
                            value="<?php echo $quote_list['size_m']; ?>">
                    </td>
                    <td>
                        <input class="background_1 width_90 padding_minmal border_1"
                            style="color:white; width:5vw;font-size: 0.9em;" type="text" name="pannels[]"
                            value="<?php echo $quote_list['pannels']; ?>">
                    </td>
                    <td>
                        <input class="background_1 padding_minmal border_1" style="color:white;width:7vw;font-size: 0.9em;"
                            type="text" id="retail_price_<?php echo $index; ?>" step="0.01" name="price[]"
                            oninput="calculateRow(this,<?php echo $index; ?>)" value="<?php echo $quote_list['price']; ?>" onchange="change_to_currency(this)">
                    </td>
                    <td>
                        <input class="background_1 padding_minmal border_1" style="color:white;width:9vw;font-size: 0.9em;"
                            type="text" id="total_<?php echo $index; ?>" readonly>
                    </td>
                    <td><button class="width_100" onclick="delete_row(this)">DELETE</button></td>

                </tr>
                <?php
                $index++;
            }

            ?>

        </tbody>
        <tfoot>
            <tr>
                <td colspan="7" style="text-align:right;color:black;">Subtotal:</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="subtotal" readonly></td>
                <td></td>
            </tr>
            <tr >
                <td colspan="7" style="text-align:right;color:black;">VAT (15%):</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="vat" readonly>
                </td>
                <td></td>
            </tr>
            <tr>
                <td colspan="7" style="text-align:right;color:black;">Net Total:</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="net_total" readonly></td>
                <td></td>
            </tr>
        </tfoot>
    </table>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>IMPORTANT NOTES</label>
            <textarea name="note" id="note" class="width_100" rows="10"><?php echo $quote['notes']; ?></textarea>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>TERMS</label>
            <textarea name="terms" class="width_100" rows="8"><?php echo $quote['terms']; ?>
            </textarea>
        </div>
    </div>
    <script>
        let index = <?php echo $index; ?>;

        function delete_row(el) {
            var row = el.parentNode.parentNode;
            row.parentNode.removeChild(row);
            calculateTotals();
        }

        function add_row() {
            var table = document.getElementById("table").getElementsByTagName('tbody')[0];
            var row = table.insertRow(-1);

            row.innerHTML = `
            <tr>
            <td>
                <input class="background_1  padding_minmal border_1"
                    style="color:white; width: 8vw;font-size: 0.9em;" id="stock_code_${index}"
                    onchange="get_unit_of_measure(this,${index})" list="stock_list" name="stock_id[]">
            </td>
            <td>
                <input class=" background_1 padding_minmal border_1"
                    style="color:white;font-size: 0.9em;width:20vw;"  id="stock_${index}"
                    list="stock_list" onchange="get_unit_of_measure(this,${index})">
            </td>
            <td> 
                <input class="background_1 width_90 padding_minmal border_1" style="color:white; width:6vw;font-size: 0.9em;" type="text" id="unit_of_measure_${index}" name="unit_of_measure[]" oninput="get_unit_of_measure(this,${index})">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0" name="qty[]" id="qty_${index}"
                    oninput="calculateRow(this,${index})">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"
                    name="size_m[]">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"    
                    name="pannels[]">
            </td>
            <td>
                <input class="background_1 padding_minmal border_1" style="color:white;width:7vw;font-size: 0.9em;"
                    type="text" min="0" value="0" id="retail_price_${index}" step="0.01" name="price[]"
                    oninput="calculateRow(this,${index})" onchange="change_to_currency(this)">
            </td>
            <td>
                <input class="background_1 padding_minmal border_1" style="color:white;width:9vw;font-size: 0.9em;"
                    type="text" id="total_${index}" readonly>
            </td>
            <td>
                <button class="width_100" onclick="delete_row(this)">DELETE</button>
            </td>
            
            </tr>
            `;
            index++;
        }

        function get_unit_of_measure(input, i) {
            data = input.value.split("~");
            document.getElementById("unit_of_measure_" + i).value = data[2];
            document.getElementById("stock_code_" + i).value = data[0];
            let price = parseFloat(data[3].replace(/ /g, "").replace(/[^\d.]/g, '.')) || 0;
            console.log(data[3]);
            console.log(price);
            document.getElementById("retail_price_" + i).value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(price);
            document.getElementById("retail_price_" + i).value = document.getElementById("retail_price_" + i).value.replace(",",".");
            document.getElementById("stock_" + i).value = data[1];

        }
        function calculateRow() {
            ind = index;
            for (let i = 1; i <= ind - 1; i++) {
                qty = parseFloat(document.getElementById("qty_" + i).value) || 0;
                console.log(qty);
                price = parseFloat(document.getElementById("retail_price_" + i).value.replace(/[^\d.-]/g, '')) || 0;

                console.log(price);
                let total = qty * price;
                console.log(total);
                document.getElementById("total_" + i).value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(total);
                document.getElementById("total_" + i).value = document.getElementById("total_" + i).value.replace(',', '.');
                calculateTotals();
            }

        }

        function change_to_currency(input) {
            let value = parseFloat(
                input.value
                    .replace(/R/g, '')
                    .replace(/\s/g, '')
                    .replace(/[^\d\.\-]/g, '') // keep digits, dot, and minus only
            );

            if (isNaN(value)) value = 0;

            // Use a simple condition to show -R for negative numbers
            if (value < 0) {
                input.value = '-R ' + new Intl.NumberFormat('en-ZA', {
                    style: 'currency',
                    currency: 'ZAR'
                }).format(Math.abs(value)).replace('R', '').trim();
            } else {
                input.value = new Intl.NumberFormat('en-ZA', {
                    style: 'currency',
                    currency: 'ZAR'
                }).format(value);
            }
            input.value = input.value.replace(',', '.');
        }


        function calculateTotals() {
            let totals = document.querySelectorAll("[id^='total_']");
            let subtotal = 0;
            totals.forEach(t => {
                let val = parseFloat(t.value.replace(/[^\d\.-]/g, ''));
                if (isNaN(val)) val = 0;
                subtotal += val;
            });
            let vat = subtotal * 0.15;
            let net_total = subtotal + vat;

            document.getElementById("subtotal").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(subtotal);
            document.getElementById("subtotal").value = document.getElementById("subtotal").value.replace(',', '.');
            document.getElementById("vat").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(vat);
            document.getElementById("vat").value = document.getElementById("vat").value.replace(',', '.');
            document.getElementById("net_total").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(net_total);
            document.getElementById("net_total").value = document.getElementById("net_total").value.replace(',', '.');
        }


        for (let i = 0; i < <?php echo $index; ?>; i++) {
            calculateRow(i);
            change_to_currency(document.getElementById("retail_price_" + i));
            document.getElementById("retail_price_" + i) = document.getElementById("retail_price_" + i).replace(',', '.');
        }

    </script>
    <br>
    <button class="width_90" onclick="save('update_quotes.php')">SAVE</button>
    <br>

</div>

<script>
    function open_pdf(url) {
        window.open(url);
    }
    function save(url) {
        let payload = {};

        // handle all inputs
        let inputs = document.querySelectorAll("input, select, textarea");
        inputs.forEach(el => {
            let name = el.name;
            if (!name) return;

            if (name.endsWith("[]")) {
                // ensure array
                if (!payload[name]) payload[name] = [];
                payload[name].push(el.value);
            } else {
                payload[name] = el.value;
            }
        });

        // create form
        let form = document.createElement("form");
        form.method = "POST";
        form.action = url;

        // add hidden inputs
        for (let key in payload) {
            if (Array.isArray(payload[key])) {
                payload[key].forEach(v => {
                    let input = document.createElement("input");
                    input.type = "hidden";
                    input.name = key;   // already has [] in name
                    input.value = v;
                    form.appendChild(input);
                });
            } else {
                let input = document.createElement("input");
                input.type = "hidden";
                input.name = key;
                input.value = payload[key];
                form.appendChild(input);
            }
        }

        document.body.appendChild(form);
        form.submit();
    }
</script>