<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

//get all batches
$batch_tot_res = $db->query("batch_data", "SELECT batch_no FROM batch_data");
$batch_tot = $batch_tot_res->num_rows;

$date = new DateTime();
$year = $date->format("y");
$month = $date->format("m");
$day = $date->format("d");

$batch_no_res = $db->query("batch_data", "SELECT batch_no FROM batch_data ORDER BY batch_no DESC LIMIT 1");
$no_batch = $batch_no_res->num_rows;

if ($no_batch > 0) {
    if ($batch_no_data = $batch_no_res->fetch_assoc()) {
        $batch_no_count = substr($batch_no_data['batch_no'], strpos($batch_no_data['batch_no'], "-") + 1);

        // echo $batch_no_count;
        $batch_no_count = $batch_no_count + 1;

        // echo $batch_no_count;

        $batch_no = $year . "-" . $batch_no_count . "-" . $month . $day . "-" . $batch_tot;
    }
} else {
    $batch_no_count = "01";

    //generate 3 random letters
    $unique_letters = chr(rand(65, 90)) . chr(rand(65, 90)) . chr(rand(65, 90));

    $batch_number = $unique_letters . "-" . $day . $month . $year . "-" . $batch_no_count;
    //convert batch_no to string
    $batch_num = strval($batch_number);
    // echo $batch_no;
}

$silo_data_res = $db->query("silos", "SELECT * FROM silos");
$silo_data = [];
$silo_data[] = " ";
if ($silo_data_res->num_rows > 0) {
    while ($silo_data_row = $silo_data_res->fetch_assoc()) {
        // echo $silo_data_row['name'];
        $silo_data[] = $silo_data_row['name'];
    }
}




$batch_no_label = new label();
$batch_no_label->for("batch_no_label");
$batch_no_label->value("BATCH NO");

$batch_no = new input();
$batch_no->class("inputs");
$batch_no->type("text");
$batch_no->name("batch_no");
$batch_no->id("batch_no");
// $batch_no->value($batch_num);

$silo_label = new label();
$silo_label->for("silo_id_label");
$silo_label->value("SILO");

$silo = new select();
$silo->name("silo_id");
$silo->class("inputs");
$silo->id("silo_id");
$silo->add_option("1", "1");
$silo->add_option("2", "2");
$silo->fill_from_db("silos", "record_id", "name");

$amount_label = new label();
$amount_label->for("amount_label");
$amount_label->value("AMOUNT");

$amount = new input();
$amount->class("inputs");
$amount->type("number");
$amount->name("amount");
$amount->id("amount");
$amount->value("");

$submit_btn = new button();
// $submit_btn->type("submit");
$submit_btn->class("submit_btn");
$submit_btn->value("SUBMIT");

?>


<form action="save_batch.php" method="post">
    <div class="form_down">
        <h1>ADD BATCH</h1>
        <?php
        $batch_no_label->add();
        $batch_no->add();
        ?>

        <div style="display: flex; flex-direction: column; align-items: center;width: 70%;">
            <div style="display: flex; flex-direction: row; align-items: center;width: 70%;">
                <?php
                $silo_label->add();
                $silo->add();
                $amount_label->add();
                $amount->add();
                ?>
            </div>
            <div style="display: flex; flex-direction: column; align-items: center;width: 90%;">
                <div id="silo_row" style="display: flex; flex-direction: column; align-items: center;width: 100%;">
                </div>
            </div>
        </div>

        <input type="number" id="silo_count" name="silo_count" value="1" hidden>
        <button type="button" onclick="add_row()" class="submit_btn">ADD</button>
        <br>

        <?php
        $submit_btn->add();
        ?>
    </div>

    <script>
        function add_row() {
            var silo_row = document.getElementById("silo_row");
            var silo_count = document.getElementById("silo_count").value;

            var divider = document.createElement("div");
            divider.style.width = "100%";
            divider.style.display = "flex";
            divider.style.flexDirection = "row";
            divider.style.alignItems = "center";
            divider.style.gap = "10px";
            divider.style.marginBottom = "5px";
            silo_row.appendChild(divider);

            var new_silo_label = document.createElement("label");
            new_silo_label.innerHTML = "SILO";
            new_silo_label.setAttribute("for", "silo_" + silo_count);
            divider.appendChild(new_silo_label);

            var new_silo = document.createElement("select");
            new_silo.setAttribute("name", "silo_" + silo_count);
            new_silo.setAttribute("class", "inputs");
            new_silo.setAttribute("id", "silo_" + silo_count);
            divider.appendChild(new_silo);

            // Example: Add select options
            var silos = <?php echo json_encode($silo_data); ?>;
            silos.forEach(function (silo) {
                var option = document.createElement("option");
                option.value = silo;
                option.textContent = silo;
                new_silo.appendChild(option);
            });

            var new_amount_label = document.createElement("label");
            new_amount_label.innerHTML = "AMOUNT";
            new_amount_label.setAttribute("for", "amount_" + silo_count);
            divider.appendChild(new_amount_label);

            var new_amount = document.createElement("input");
            new_amount.setAttribute("type", "number");
            new_amount.setAttribute("name", "amount_" + silo_count);
            new_amount.setAttribute("class", "inputs");
            new_amount.setAttribute("id", "amount_" + silo_count);
            divider.appendChild(new_amount);

            // Optional remove button
            var remove_btn = document.createElement("button");
            remove_btn.textContent = "X";
            remove_btn.type = "button";
            remove_btn.className = "submit_btn";
            remove_btn.style.border = "2px solid red";
            remove_btn.style.backgroundColor = "red";
            remove_btn.style.width = "10vw";
            //onhover effect
            remove_btn.onmouseover = function () {
                this.style.backgroundColor = "#ff000066";
                this.style.color = "white";
            };
            remove_btn.onmouseout = function () {
                this.style.backgroundColor = "red";
                this.style.color = "white";
            };
            remove_btn.onclick = function () {
                silo_row.removeChild(divider);
            };
            divider.appendChild(remove_btn);

            // Increment count
            document.getElementById("silo_count").value = parseInt(silo_count) + 1;
        }

        function remove_row() {
            var silo_row = document.getElementById("silo_row");
            var silo_count = document.getElementById("silo_count");

            // Check if there are any child rows to remove
            if (silo_row.lastChild) {
                silo_row.removeChild(silo_row.lastChild);

                // Decrease the count correctly
                var current_count = parseInt(silo_count.value);
                if (current_count > 0) {
                    silo_count.value = current_count - 1;
                }
            }
        }
    </script>
</form>