<?php

include "../root.class.php";
$functions = new functions();
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

function get_day_of_the_week($date)
{
    $date = date('w', strtotime($date));
    switch ($date) {
        case 0:
            return 'Sunday';
        case 1:
            return 'Monday';
        case 2:
            return 'Tuesday';
        case 3:
            return 'Wednesday';
        case 4:
            return 'Thursday';
        case 5:
            return 'Friday';
        case 6:
            return 'Saturday';
    }
}

echo DashboardWidget::includeAssets();

$fuel_movement_res_table = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} ORDER BY record_id DESC LIMIT 10");
$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {
    $table_data[] = [
        $functions->get_tank_name($fuel_movement['tank_id']),
        $functions->get_asset_name($fuel_movement['asset_id']),
        number_format(($fuel_movement['amount'] / 1000), 3),
        $fuel_movement['date_time_closed'],
        $functions->get_username($fuel_movement['user_id']),
        'diesel/slip.pdf.php?record_id=' . $fuel_movement['record_id']
    ];
}

echo DashboardWidget::tableBlock('Latest Activity', ['TANK', 'ASSET', 'AMOUNT', "DATE", "USER"], $table_data, '90vw');

$data_array = [];
$date = date('Y-m-d') . ' 00:00';
$date2 = date('Y-m-d') . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

echo DashboardWidget::columnGraph('TOTAL FOR 7 DAYS FOR ALL TANKS', $data_array, '90vw');

$sites_res = $db->query("sites", "SELECT * FROM sites WHERE company_id = {$_SESSION['company_id']}");
while ($site = $sites_res->fetch_assoc()) {
    ?>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <h1><?php echo $site['name']; ?></h1>
    <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
    <?php
    $tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE site_id = {$site['record_id']}");

    while ($tank = $tank_res->fetch_assoc()) {
        $tank_id = $tank['record_id'];
        ?>
        <div class="column" style="width: 100%">
            <div style="display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: space-evenly;
        align-items: center;">

                <h2><u><?php echo $tank['name']; ?></u></h2>

                <?php
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND `status` = 'DONE' ORDER BY record_id DESC LIMIT 10");

                $data_array = [];

                while ($fuel_movement = $fuel_movement_array_res->fetch_assoc()) {
                    $data_array[] = [$fuel_movement['amount'], $fuel_movement['date_time_closed']];
                }

                echo DashboardWidget::columnGraph('LATEST READINGS', $data_array, '90vw');

                $data_array = [];
                $date = date('Y-m-d') . ' 00:00';
                $date2 = date('Y-m-d') . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id = $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                $date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
                $date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
                $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE (`status` = 'DONE' OR `status` = 'MANUAL OVERRIDE') AND tank_id =  $tank_id AND date_time_closed BETWEEN '{$date}' AND '{$date2}'");
                $fuel_movement = $fuel_movement_array_res->fetch_assoc();
                $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

                echo DashboardWidget::columnGraph('TOTAL FOR 7 DAYS', $data_array, '90vw');

                $lastSixMonths = [];
                for ($i = 5; $i >= 0; $i--) {
                    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));
                    $lastSixMonths_names[] = date('F', strtotime("-$i months"));

                }
                $amounts_arr = [];
                foreach ($lastSixMonths as $key => $month) {
                    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE tank_id = {$tank['record_id']} AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31'");
                    $amounts_arr[] = $total_amount_res->fetch_assoc()['total_amount'];
                }

                echo DashboardWidget::lineGraph(
                    'PRODUCTION OVER TIME',
                    $lastSixMonths_names,
                    $amounts_arr,
                    'Liters'
                );


                $tank_level_res = $db->query("tank_level_log", "SELECT * FROM tank_level_log WHERE tank_id = {$tank['record_id']} ORDER BY record_id DESC LIMIT 1");
                $tank_level = $tank_level_res->fetch_assoc();

                $data = $functions->calculate_horizontal_cylinder_volume($tank['radius_mm'], $tank_level['distance'], $tank['length_mm']);

                echo DashboardWidget::circleGraph("TANK LEVEL", 0, 100, $data['percentage_filled']);
                ?>
            </div>


            <div style="width: 100%;height: 0px; border: 4px solid #000"></div>
            <?php
    }


}
?>