<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$stock_data_res = $db->query("stock_control", "SELECT * FROM stock_control");

while ($stock_data = $stock_data_res->fetch_assoc()) {

    $stock_items = $stock_items . "<option value='" . $stock_data["record_id"] . "'>" . $stock_data["item_name"] . "</option>";
}

$stock_no_label = new label();
$stock_no_label->for("stock_no");
$stock_no_label->value("Stock No:");

$stock_no = new select();
$stock_no->class("inputs");
$stock_no->name("stock_no");
$stock_no->id("stock_no");
$stock_no->fill_from_db("stock_control", "stock_no", "stock_no");

$jobcard_no_label = new label();
$jobcard_no_label->for("jobcard_no_label");
$jobcard_no_label->value("Jobcard No:");

$jobcard_no = new select();
$jobcard_no->class("inputs");
$jobcard_no->name("jobcard_no");
$jobcard_no->id("jobcard_no");
$jobcard_no->fill_from_db("jobcards", "jc_no", "jc_no", "status = 0");

$date_booked_label = new label();
$date_booked_label->for("date_booked_label");
$date_booked_label->value("Booking Date:");

$date_booked = new input();
$date_booked->class("inputs");
$date_booked->name("date_booked");
$date_booked->id("date_booked");
$date_booked->type("datetime-local");

$no_rows = new input();
$no_rows->type("hidden");
$no_rows->id("no_rows");
$no_rows->name("no_rows");
$no_rows->value(0);

$add_row_btn = new input();
$add_row_btn->value("ADD ROW");
$add_row_btn->id("add_row_btn");
$add_row_btn->onclick("add_row()");
$add_row_btn->type("button");
$add_row_btn->class("submit_btn");

$submit_btn = new button();
$submit_btn->value("SUBMIT");
$submit_btn->id("submit_btn");

?>

<form action="book_stock.ajax.php" method="post">
    <div class="form_down">
        <h1>ASSIGN STOCK</h1>
        <style>
            table {
                border-collapse: collapse;
                width: 90%;
                background-color: whitesmoke;
            }

            table,
            th,
            td {
                border: 2px solid black;
            }

            th {
                padding: 1vw;
            }
        </style>
        <?php
        $jobcard_no_label->add();
        $jobcard_no->add();
        $date_booked_label->add();
        $date_booked->add();
        $no_rows->add();
        ?>

        <table style="width:90%">
            <tr>
                <th style="width: 20%;">Item Name</th>
                <th style="width: 20%;">Stock No</th>
                <th style="width: 20%;">Description</th>
                <th style="width: 20%;">Current Quantity</th>
                <th style="width: 20%;">Quantity</th>
            </tr>
        </table>
        <div id="stock_table" style="width:90%;"></div>
        <br>
        <?php
        $add_row_btn->add();
        $submit_btn->add();
        ?>
    </div>
</form>

<script>

    var i = 1;

    function getItemData(input, index) {
        var i = index - 1;
        // console.log(input + i);

        var item_name = document.getElementById(input + i).value;
        if (!item_name) {
            // console.log("Element not found: " + input + "_" + i);
            return;
        }

        // Create an XMLHttpRequest object
        const xhttp = new XMLHttpRequest();
        // Define a callback function
        xhttp.onload = function () {
            // Here you can use the Data
            if (this.responseText != 1) {

                // console.log("Response received:", this.responseText);

                var data = this.responseText.split("~");
                // console.log("Split data:", data);
                if (data.length >= 3) {

                    stock_no = document.getElementById("stock_no_" + i)
                    description = document.getElementById("description_" + i)
                    current_quantity = document.getElementById("current_quantity_" + i)

                    stock_no.value = data[0];
                    description.value = data[1];
                    current_quantity.value = data[2];

                    // console.log("stock_no : ", stock_no);
                    // console.log("description : ", description);
                    // console.log("current_quantity : ", current_quantity);
                } else {
                    // console.log("Insufficient data parts. Expected 3, got:", data.length);

                    stock_no.value = "";
                    description.value = "";
                    current_quantity.value = "";
                }
            }
        }

        xhttp.open("GET", "get_stock.ajax.php?item_name=" + item_name);
        xhttp.send();
    }

    function add_row() {
        var table = document.createElement("table");
        table.id = "table_" + i;
        table.style.width = "100%";
        document.body.appendChild(table);

        var row = document.createElement("tr");
        table.appendChild(row);

        // Item Name (READONLY)
        var item_name_td = document.createElement("td");
        item_name_td.style.width = "20%";

        var item_name = document.createElement("select");
        item_name.name = "item_name_" + i;
        item_name.id = "item_name_" + i;
        item_name.className = "inputs";
        item_name.style.width = "100%";
        item_name.style.margin = "1vw auto";
        item_name.onchange = function () { getItemData('item_name_', i); };
        item_name.innerHTML = "<option value=' '>  </option>" + "<?php echo $stock_items; ?>";
        item_name.readOnly = true;
        item_name_td.appendChild(item_name);
        row.appendChild(item_name_td);

        // Stock No
        var stock_no_td = document.createElement("td");
        stock_no_td.style.width = "20%";

        var stock_no = document.createElement("input");
        stock_no.name = "stock_no_" + i;
        stock_no.id = "stock_no_" + i;
        stock_no.className = "inputs";
        stock_no.style.width = "100%";
        stock_no.style.margin = "1vw auto"
        stock_no_td.appendChild(stock_no);
        row.appendChild(stock_no_td);

        // Description (READONLY)
        var description_td = document.createElement("td");
        description_td.style.width = "20%";

        var description = document.createElement("input");
        description.name = "description_" + i;
        description.id = "description_" + i;
        description.className = "inputs";
        description.style.width = "100%";
        description.style.margin = "1vw auto"
        description.readOnly = true;
        description_td.appendChild(description);
        row.appendChild(description_td);

        // Current Quantity (READONLY)
        var current_quantity_td = document.createElement("td");
        current_quantity_td.style.width = "20%";

        var current_quantity = document.createElement("input");
        current_quantity.name = "current_quantity_" + i;
        current_quantity.id = "current_quantity_" + i;
        current_quantity.className = "inputs";
        current_quantity.style.width = "100%";
        current_quantity.style.margin = "1vw auto"
        current_quantity.readOnly = true;
        current_quantity_td.appendChild(current_quantity);
        row.appendChild(current_quantity_td);

        // Quantity (editable)
        var quantity_td = document.createElement("td");
        quantity_td.style.width = "20%";

        var quantity = document.createElement("input");
        quantity.name = "quantity_" + i;
        quantity.id = "quantity_" + i;
        quantity.className = "inputs";
        quantity.style.width = "100%";
        quantity.style.margin = "1vw auto"
        quantity.oninput = function () { maxQuantity('current_quantity_' + i, i); };
        quantity_td.appendChild(quantity);
        row.appendChild(quantity_td);

        // Add to DOM
        document.getElementById("stock_table").appendChild(table);

        document.getElementById("no_rows").value = parseInt(document.getElementById("no_rows").value) + 1;

        i++;
    }

    function maxQuantity(input, index) {
        var j = index - 1;
        var max_quantity = document.getElementById("current_quantity_" + j).value;

        var quantity = document.getElementById("quantity_" + j).value;

        if (max_quantity < quantity) {
            alert("Quantity cannot be greater than current quantity");
        } else {
            return quantity;
        }
    }

</script>