<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TankResource\Pages;
use App\Filament\Resources\TankResource\RelationManagers;
use App\Models\Tank;
use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class TankResource extends Resource
{
    protected static ?string $model = Tank::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                Select::make('site_id')
                    ->label('Site')
                    ->relationship('site', 'name')
                    ->required(),
                TextInput::make('capacity')
                    ->label('Capacity')
                    ->numeric()
                    ->required(),
                TextInput::make('name')
                    ->label('Name of Tank')
                    ->unique()
                    ->required(),
                TextInput::make('receive_arduino_serial')
                    ->label('Receive Arduino Serial')
                    ->unique()
                    ->required(),
                TextInput::make('dispense_arduino_serial')
                    ->label('Dispense Arduino Serial')
                    ->unique()
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTanks::route('/'),
            'create' => Pages\CreateTank::route('/create'),
            'edit' => Pages\EditTank::route('/{record}/edit'),
        ];
    }
}
