<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tank extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'site_id',
        'name',
        'capacity',
        'receive_arduino_serial',
        'dispense_arduino_serial',
    ];

    public function site()
    {
        return $this->belongsTo(Site::class);
    }
}
