<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FuelMovementResource\Pages;
use App\Filament\Resources\FuelMovementResource\RelationManagers;
use App\Models\FuelMovement;
use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FuelMovementResource extends Resource
{
    protected static ?string $model = FuelMovement::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
                Select::make('tank_id')
                    ->label('Tank')
                    ->relationship('tank', 'name')
                    ->required(),
                TextInput::make('amount')
                    ->label('Amount')
                    ->numeric()
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                //
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFuelMovements::route('/'),
            'create' => Pages\CreateFuelMovement::route('/create'),
            'edit' => Pages\EditFuelMovement::route('/{record}/edit'),
        ];
    }
}
