<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <script src="https://cdn.jsdelivr.net/npm/jquery"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Monsterrat", sans-serif;
            margin: 0;
            display: flex;
            min-height: 100vh;
            padding: 0;
            background-color: none;
            color: #84573e;
            flex-direction: column;
            align-content: center;
            justify-content: center;
            align-items: center;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
            padding: 20px;
            border-bottom: 1px solid #ccc;
            background-color: #f5f5f5;
        }

        section {
            max-width: 500px;
            margin: 0 auto;
            border: 5px solid #3C6E59;
            display: flex;
            padding: 20px;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            background-color: whitesmoke;
            justify-content: flex-start;
            align-items: center;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        label {
            font-weight: bold;
            margin-bottom: 5px;
        }


        input {
            width: 100%;
            font-size: 1em;
            padding: 10px;
            border: 0px;
            border-bottom: 1px solid #87553c;
            /* border-radius: 5px; */
            box-sizing: border-box;
            background-color: #fff;
        }

        button {
            background-color: #87553c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            section {
                padding: 10px;
            }

            form label {
                font-size: smaller;
            }

            input[type='date'],
            input[type='datetime-local'] {
                width: 100%;
                padding: 8px;
                margin-bottom: 10px;
            }
        }

        .hide {
            display: none;
        }

        .show {
            display: block;
        }

        #loadingPopup {
            position: fixed;
            z-index: 100;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            border: 3px solid #87553c;
            padding: 20px;
            background-color: white;
            border-radius: 8px;
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
        }

        #loadingBackground {
            top: 0;
            left: 30%;
            width: 40%;
            position: fixed;
            height: 100%;
            background-color: rgb(0 0 0 / 96%);
            z-index: 172;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            justify-content: center;
            align-items: center;
        }

        #loadingPopup.show {
            opacity: 1;
        }
    </style>
</head>

<body>

    <section>
        <h1 style="font-weight: 900;"><span style="color: #3C6E59">ADMIN LOGIN</span></h1>
        <form id="contactForm" action="login.php" method="POST" >
            <div class="form-group">
                <label for="name">Username:</label>
                <input type="text" id="username" name="username" required placeholder="" />
            </div>
            <div class="form-group">
                <label for="surname">Password:</label>
                <input type="password" id="password" name="password" required placeholder="" />
            </div>
            <button type="submit">Login</button>
        </form>
    </section>


</body>

</html>