<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <script src="https://cdn.jsdelivr.net/npm/jquery"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Monsterrat", sans-serif;
            margin: 0;
            display: flex;
            padding: 0;
            background-color: none;
            color: #3C6E59;
            flex-direction: column;
            align-content: center;
            justify-content: center;
            align-items: center;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
            padding: 20px;
            border-bottom: 1px solid #ccc;
            background-color: #f5f5f5;
        }

        section {
            max-width: 500px;
            margin: 0 auto;
            border: 5px solid #3C6E59;
            display: flex;
            padding: 20px;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            background-color: whitesmoke;
            justify-content: flex-start;
            align-items: center;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        label {
            font-weight: bold;
            margin-bottom: 5px;
        }


        input {
            width: 100%;
            font-size: 1em;
            padding: 10px;
            border: 0px;
            border-bottom: 1px solid #87553c;
            /* border-radius: 5px; */
            box-sizing: border-box;
            background-color: #fff;
        }

        button {
            background-color: #87553c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            section {
                padding: 10px;
            }

            form label {
                font-size: smaller;
            }

            input[type='date'],
            input[type='datetime-local'] {
                width: 100%;
                padding: 8px;
                margin-bottom: 10px;
            }
        }

        .hide {
            display: none;
        }

        .show {
            display: block;
        }

        #loadingPopup {
            position: fixed;
            z-index: 100;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            border: 3px solid #3C6E59;
            padding: 20px;
            background-color: white;
            border-radius: 8px;
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
        }

        #loadingBackground {
            top: 0;
            left: 0;
            width: 100%;
            position: fixed;
            height: 100%;
            background-color: rgb(0 0 0 / 96%);
            z-index: 172;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            justify-content: center;
            align-items: center;
        }

        #loadingPopup.show {
            opacity: 1;
        }
    </style>
</head>

<body>
    <section>
        <img src="logo.jpeg" alt="logo" style="width: 200px; height: 200px; margin-top: 20px; margin-bottom: 20px;">
        <h2>OTP</h2>
        <form id="contactForm_1" action="#" method="POST" onsubmit="ajaxOtpSubmission()">
            <div class="form-group">
                <input type="text" id="otp" name="otp" required placeholder="" />
            </div>
            <button type="submit">SUBMIT</button>
        </form>
        <br>
        <hr><br>
        <h2>Registar:</h2>
        <form id="contactForm" action="#" method="POST" onsubmit="ajaxFormSubmission()">
            <div class="form-group">
                <label for="name">Name:</label>
                <input type="text" id="name" name="name" required placeholder="" />
            </div>
            <div class="form-group">
                <label for="surname">Surname:</label>
                <input type="text" id="surname" name="surname" required placeholder="" />
            </div>
            <div class="form-group">
                <label for="company">Company Name:</label>
                <input type="text" id="company" name="company" required placeholder="" />
            </div>
            <div class="form-group">
                <label for="phone">Phone Number:</label>
                <input type="tel" id="phone" name="phone" required />
            </div>
            <div class="form-group">
                <label for="email">Email Address:</label>
                <input type="email" id="email" name="email" required placeholder="your@example.com" />
            </div>
   
            <button type="submit">REGISTAR</button>
            <p style="font-size: smaller; color: #3C6E59">All data is encrypted to protect your privacy.</p>
        </form>
        <div id="loadingBackground" class="hide">
            <div id="loadingPopup" class="loadingPopup">
                <p id="loadingText"></p>
                <button onclick="closeLoading()">Close</button>
            </div>
        </div>
    </section>

    <script>



        function ajaxOtpSubmission() {
            $("#loadingBackground").addClass("show");
            $("#loadingPopup").addClass("show");
            $("#loadingText").html("PLEASE WAIT...");

            const formData = new FormData(document.getElementById("contactForm_1"));
            $.ajax({
                url: "submit_otp.php",
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response == "success") {
                        $("#loadingText").html("Success! Attendance Submitted.");
                    } else {
                        $("#loadingText").html("Error: " + response);
                    }
                    // $("#loadingPopup").addClass("hide");
                    // alert(response);
                },
                error: function (err) {
                    console.log("ERROR:", err);
                }
            });
        }
        $(document).ready(function () {
            $("form").submit(function (e) {
                return e.preventDefault();
            });
        });

        function ajaxFormSubmission() {
            $("#loadingBackground").addClass("show");
            $("#loadingPopup").addClass("show");
            $("#loadingText").html("PLEASE WAIT...");

            const formData = new FormData(document.getElementById("contactForm"));
            $.ajax({
                url: "submit.php",
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response == "success") {
                        $("#loadingText").html("Success! Your form has been submitted.");
                    } else {
                        $("#loadingText").html("Error: " + response);
                    }
                    // $("#loadingPopup").addClass("hide");
                    // alert(response);
                },
                error: function (err) {
                    console.log("ERROR:", err);
                }
            });
        }
        $(document).ready(function () {
            $("form").submit(function (e) {
                return e.preventDefault();
            });
        });

        function closeLoading() {
            $("#loadingBackground").removeClass("show");
            $("#loadingBackground").addClass("hide");
            $("#loadingPopup").removeClass("show");
            $("#loadingPopup").addClass("hide");

            document.getElementById("contactForm").reset();
        }
    </script>

</body>

</html>