<?php
require('../../fpdf.php');
include "../../root.class.php";


$db = new db_safeguard();
$jobcard_res = $db->query("jobcards", "SELECT * FROM jobcards");
$jobcard = $jobcard_res->fetch_assoc();

$user_id = $jobcard['user_id'];
$client_id = $jobcard['client_id'];

function get_username($user_id)
{
    $db = new db_safeguard();
    $res = $db->query("users", "SELECT username FROM users WHERE record_id = $user_id");
    return $res->fetch_assoc()['username'];
}

function get_client($client_id)
{
    $db = new db_safeguard();
    $res = $db->query("users", "SELECT `name` FROM clients WHERE record_id = $client_id");
    return $res->fetch_assoc()['name'];
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(280, 15, "JOB CARD REPORTS", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(13, 8, "JC No", 1, 0, 'L');
$pdf->Cell(14, 8, "Slip No", 1, 0, 'L');
$pdf->Cell(30, 8, "User id", 1, 0, 'L');
$pdf->Cell(30, 8, "User Assigned", 1, 0, 'L');
$pdf->Cell(30, 8, "Client Name", 1, 0, 'L');
$pdf->Cell(30, 8, "Date Created", 1, 0, 'L');
$pdf->Cell(30, 8, "Contact Name", 1, 0, 'L');
$pdf->Cell(11, 8, "Pump", 1, 0, 'L');
$pdf->Cell(20, 8, "Water Flow", 1, 0, 'L');
$pdf->Cell(32, 8, "Compressor Hours", 1, 0, 'L');
$pdf->Cell(30, 8, "Date Finished", 1, 1, 'L');

if ($jobcard_res->num_rows == 0) {
    echo " NO JOBCARDS FOUND";
} else {
    while ($jobcard = $jobcard_res->fetch_assoc()) {
        $pdf->Cell(13, 8, $jobcard['jc_number'], "LB", 0, 'L');
        $pdf->Cell(14, 8, $jobcard['slip_no'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, get_username($jobcard['user_id']), "LBR", 0, 'L');
        $pdf->Cell(30, 8, get_username($jobcard['user_assigned']), "LB", 0, 'L');
        $pdf->Cell(30, 8, get_client($jobcard['client_id']), "LBR", 0, 'L');
        $pdf->Cell(30, 8, $jobcard['date_created'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, $jobcard['contact_name'], "LBR", 0, 'L');
        $pdf->Cell(11, 8, $jobcard['interested_in_pump'], "LB", 0, 'L');
        $pdf->Cell(20, 8, $jobcard['water_flow'], "LBR", 0, 'L');
        $pdf->Cell(32, 8, $jobcard['compressor_hours'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, $jobcard['date_time_closed'], "LBR", 1, 'L');
    }
}


$pdf->Cell(10, 5, '', 0, 1, 'L'); 

// $pdf->AddPage('L');

// $pdf->SetFont('Arial', 'B', 20);
// $pdf->Cell(280, 15, "JOB CARD REPORTS", 0, 1, 'C');
// $pdf->Cell(10, 5, '', 0, 1, 'L');
// $pdf->SetFont('Arial', '', 10);

// $pdf->Cell(45, 8, "DESCRIPTION", 1, 0, 'L');
// $pdf->Cell(55, 8, "NOTES", 1, 0, 'L');
// $pdf->Cell(35, 8, "DATE TIME", 1, 0, 'L');
// $pdf->Cell(60, 8, "IMAGE", 1, 1, 'L');

// $jobcard_id = $jobcard['record_id'];

// $notes_res = $db->query("notes", "SELECT * FROM notes WHERE jobcard_id = $jobcard_id ORDER BY record_id ASC");
// if ($notes_res->num_rows == 0) {
//     $error = 1;
// } else {
//     while ($notes = $notes_res->fetch_assoc()) {
//         $pdf->Cell(45, 8, $notes['reason'], "LB", 0, 'L');
//         $pdf->Cell(55, 8, $notes['note'], "LBR", 0, 'L');
//         $pdf->Cell(35, 8, $notes['date_time'], "LBR", 0, 'L');
//         $pdf->Cell(60, 8, $notes['image'], "LBR", 1, 'L');
//     }
// }

$pdf->Output("I");