<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
session_start();

//get the current date and time
$current_date_time = date("Y-m-d H:i", strtotime("+2 hours"));
$uploadDir = "../signature/";

// Make sure user is logged in
if (!isset($_SESSION['user_id'])) {
    echo "User not logged in.";
    exit;
}

// Check if at least one signature file is uploaded
if (!isset($_FILES['client_signature']) && !isset($_FILES['manager_signature'])) {
    echo "No signature files uploaded.";
    exit;
}

try {
    $user_id = $_SESSION['user_id'];
    $record_id = $_POST['record_id'];

    // Get jobcard number
    $get_jc_id = $db->query("jobcards", "SELECT jc_no FROM jobcards WHERE record_id = {$record_id}");
    $jobcard_data = $get_jc_id->fetch_assoc();
    $jobcard_no = $jobcard_data['jc_no']; // Fixed variable name

    // Create directory if it doesn't exist
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $signatures_saved = 0;
    $errors = array();

    // Create filename-safe timestamp
    $timestamp = date('Y-m-d_H-i-s', strtotime("+2 hours"));

    // Handle client signature
    if (isset($_FILES['client_signature'])) {
        $filename = 'client_' . $jobcard_no . '_' . $timestamp . '.png';
        echo $_FILES['client_signature'];
        $uploadPath = $uploadDir . $filename;

        if (move_uploaded_file($_FILES['client_signature']['tmp_name'], $uploadPath)) {
            $signatures_saved++;
        } else {
            $errors[] = "Error uploading client signature file";
        }
    }

    // Handle manager signature
    if (isset($_FILES['manager_signature'])) {
        $filename = 'manager_' . $jobcard_no . '_' . $timestamp . '.png';
        echo $_FILES['manager_signature'];
        $uploadPath = $uploadDir . $filename;

        if (move_uploaded_file($_FILES['manager_signature']['tmp_name'], $uploadPath)) {
            $signatures_saved++;
        } else {
            $errors[] = "Error uploading manager signature file";
        }
    }

    // Return response
    if ($signatures_saved > 0) {
        echo "OK - $signatures_saved signature(s) saved successfully";
    } else {
        echo "Error: " . (empty($errors) ? "No signatures received" : implode(", ", $errors));
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
