<?php
session_start();

// Check if table name and record_id are passed via GET
if (!isset($_GET['table']) || !isset($_GET['record_id'])) {
    die("Table name and record ID are required.");
}

$table_name = $_GET['table'];
$record_id = $_GET['record_id'];

// Database connection
$db = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

// Fetch columns of the given table
$sql = "DESCRIBE `$table_name`";
$result = $db->query($sql);

if (!$result) {
    die("Error fetching table structure: " . $db->error);
}

$columns = [];
while ($row = $result->fetch_assoc()) {
    $columns[] = $row;
}

// Handle form submission (inserting data into the table)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Prepare the column names and values for insertion
    $column_names = [];
    $column_values = [];

    foreach ($columns as $column) {
        $column_name = $column['Field'];
        if (isset($_POST[$column_name])) {
            $column_names[] = "`$column_name`";
            $column_values[] = "'" . $db->real_escape_string($_POST[$column_name]) . "'";
        }
    }

    if (count($column_names) > 0) {
        $sql_insert = "INSERT INTO `$table_name` (" . implode(", ", $column_names) . ") VALUES (" . implode(", ", $column_values) . ")";

        if ($db->query($sql_insert) === TRUE) {
            // Redirect to the db.php page after successful insertion
            header("Location: db.php?record_id=$record_id");
            exit();
        } else {
            echo "Error inserting data: " . $db->error;
        }
    } else {
        echo "No data provided to insert.";
    }
}

$db->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Data into <?php echo htmlspecialchars($table_name); ?></title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 50px auto;
            padding: 20px;
            background-color: #f4f4f4;
            border-radius: 10px;
        }

        form {
            display: flex;
            flex-direction: column;
            margin-top: 20px;
        }

        form label {
            margin-bottom: 5px;
            font-weight: bold;
        }

        form input,
        form select {
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            width: 100%;
            box-sizing: border-box;
        }

        .submit-btn {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
            box-sizing: border-box;
            font-size: 16px;
        }

        .submit-btn:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<div class="container">
    <a href="db.php?record_id=<?php echo $record_id; ?>" class="btn-action">BACK</a>
    <h1>Insert Data into <?php echo htmlspecialchars($table_name); ?></h1>
    <form action="insert.php?table=<?php echo urlencode($table_name); ?>&record_id=<?php echo urlencode($record_id); ?>" method="POST">
        <?php foreach ($columns as $column): ?>
            <div class="form-row">
                <div>
                    <label for="<?php echo $column['Field']; ?>"><?php echo ucfirst($column['Field']); ?>:</label>
                    <?php
                    // Check column type for text or number input
                    if (in_array($column['Type'], ['varchar', 'text', 'char'])) {
                        echo '<input type="text" id="' . $column['Field'] . '" name="' . $column['Field'] . '" >';
                    } elseif (in_array($column['Type'], ['int', 'decimal', 'float'])) {
                        echo '<input type="number" id="' . $column['Field'] . '" name="' . $column['Field'] . '" >';
                    } elseif (in_array($column['Type'], ['date', 'datetime'])) {
                        echo '<input type="date" id="' . $column['Field'] . '" name="' . $column['Field'] . '" >';
                    } else {
                        echo '<input type="text" id="' . $column['Field'] . '" name="' . $column['Field'] . '" >';
                    }
                    ?>
                </div>
            </div>
        <?php endforeach; ?>

        <button type="submit" class="submit-btn">Insert Data</button>
    </form>
</div>

</body>
</html>
