<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Table</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 50px auto;
            padding: 20px;
            background-color: #f4f4f4;
            border-radius: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table th,
        table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        table th {
            background-color: #4CAF50;
            color: white;
        }

        form {
            display: flex;
            flex-direction: column;
            margin-top: 20px;
        }

        form label {
            margin-bottom: 5px;
            font-weight: bold;
        }

        form input,
        form select {
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            width: 100%;
            box-sizing: border-box;
        }

        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
        }

        .form-row div {
            flex: 1;
            margin-right: 10px;
        }

        .form-row div:last-child {
            margin-right: 0;
        }

        .submit-btn {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
            box-sizing: border-box;
            font-size: 16px;
        }

        .submit-btn:hover {
            background-color: #45a049;
        }

        .add-column-btn {
            background-color: #008CBA;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .add-column-btn:hover {
            background-color: #007B9F;
        }
    </style>
</head>

<body>

    <div class="container">
        <a href="db.php?record_id=<?= $_GET['record_id']; ?>" class="btn-action">BACK</a>
        <h1>Create a New Table</h1>
        <form action="create_table_action.php" method="POST" id="createTableForm">
            <label for="table_name">Table Name:</label>
            <input type="text" id="table_name" name="table_name" required>
            <input type="text" hidden id="record_id" name="record_id" value="<?php echo $_GET['record_id']; ?>"
                required><br><br>
            <div id="columnsContainer">
                <div class="form-row">
                    <div>
                        <label for="column_name">Column Name:</label>
                        <input type="text" id="column_name" name="column_name[]" required>
                    </div>
                    <div>
                        <label for="column_type">Column Type:</label>
                        <select id="column_type" name="column_type[]" required>
                            <option value="INT">INT</option>
                            <option value="VARCHAR">VARCHAR</option>
                            <option value="TEXT">TEXT</option>
                            <option value="DATE">DATE</option>
                            <option value="DATETIME">DATETIME</option>
                        </select>
                    </div>
                    <div>
                        <label for="column_length">Column Length:</label>
                        <input type="number" id="column_length" name="column_length[]" value="255" required>
                    </div>
                    <div>
                        <label for="column_null">Allow NULL:</label>
                        <input type="checkbox" id="column_null" name="column_null[]">
                    </div>
                    <div>
                        <label for="column_auto_increment">Auto Increment:</label>
                        <input type="checkbox" id="column_auto_increment" name="column_auto_increment[]">
                    </div>
                    <div>
                        <label for="column_unique">Unique Key:</label>
                        <input type="checkbox" id="column_unique" name="column_unique[]">
                    </div>
                    <div>
                        <label for="column_default_value">Default Value:</label>
                        <input type="text" id="column_default_value" name="column_default_value[]">
                    </div>
                </div>
            </div>

            <button type="button" class="add-column-btn" id="addColumnBtn">Add Column</button>
            <button type="submit" class="submit-btn">Create Table</button>
        </form>
    </div>

    <script>
        // Add column functionality
        document.getElementById('addColumnBtn').addEventListener('click', function () {
            const columnsContainer = document.getElementById('columnsContainer');

            // Create a new form row
            const newRow = document.createElement('div');
            newRow.classList.add('form-row');

            // Create each input field for the new column
            newRow.innerHTML = `
            <div>
                <label for="column_name">Column Name:</label>
                <input type="text" id="column_name" name="column_name[]" required>
            </div>
            <div>
                <label for="column_type">Column Type:</label>
                <select id="column_type" name="column_type[]" required>
                    <option value="INT">INT</option>
                    <option value="VARCHAR">VARCHAR</option>
                    <option value="TEXT">TEXT</option>
                    <option value="DATE">DATE</option>
                    <option value="DATETIME">DATETIME</option>
                </select>
            </div>
            <div>
                <label for="column_length">Column Length:</label>
                <input type="number" id="column_length" name="column_length[]" value="255" required>
            </div>
            <div>
                <label for="column_null">Allow NULL:</label>
                <input type="checkbox" id="column_null" name="column_null[]">
            </div>
            <div>
                <label for="column_auto_increment">Auto Increment:</label>
                <input type="checkbox" id="column_auto_increment" name="column_auto_increment[]">
            </div>
            <div>
                <label for="column_unique">Unique Key:</label>
                <input type="checkbox" id="column_unique" name="column_unique[]">
            </div>
            <div>
                <label for="column_default_value">Default Value:</label>
                <input type="text" id="column_default_value" name="column_default_value[]">
            </div>
        `;

            // Append the new row to the container
            columnsContainer.appendChild(newRow);
        });
    </script>

</body>

</html>