<?php
session_start();

// Fetch form data
$table_name = $_POST['table_name'];
$database_id = $_POST['record_id'];
$column_names = $_POST['column_name'];
$column_types = $_POST['column_type'];
$column_lengths = $_POST['column_length'];
$column_null = isset($_POST['column_null']) ? $_POST['column_null'] : [];
$column_auto_increment = isset($_POST['column_auto_increment']) ? $_POST['column_auto_increment'] : [];
$column_unique = isset($_POST['column_unique']) ? $_POST['column_unique'] : [];
$column_default_values = $_POST['column_default_value'];

// Database connection
$db = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

// Start building the SQL query for table creation
$sql = "CREATE TABLE `$table_name` (";

// Loop through each column and generate SQL parts
for ($i = 0; $i < count($column_names); $i++) {
    $column_name = $column_names[$i];
    $column_type = $column_types[$i];
    $column_length = $column_lengths[$i]; // Length for VARCHAR or other types
    $null = isset($column_null[$i]) ? 'NULL' : 'NOT NULL';
    $auto_increment = isset($column_auto_increment[$i]) ? 'AUTO_INCREMENT' : '';
    $unique = isset($column_unique[$i]) ? 'UNIQUE' : ''; // UNIQUE is added based on user input
    $default_value = !empty($column_default_values[$i]) ? "DEFAULT '" . $db->real_escape_string($column_default_values[$i]) . "'" : '';

    // Construct column definition
    $column_sql = "`$column_name` $column_type($column_length) $null $unique $default_value $auto_increment";

    // Append to the overall SQL query
    $sql .= $column_sql . ", ";
}

// Add primary key if the first column has auto-increment
if (isset($column_auto_increment[0])) {
    $sql .= "PRIMARY KEY(`{$column_names[0]}`)";
}

// Remove trailing comma and close the CREATE TABLE statement
$sql = rtrim($sql, ", ") . ");";

// Execute the query
if ($db->query($sql) === TRUE) {
    // Redirect to the db.php page after successful table creation
    header("Location: db.php?record_id=$database_id");
    exit(); // Ensure no further code is executed
} else {
    echo "Error creating table: " . $db->error;
}

$db->close();
?>
