<?php
include "../../root.class.php";
$db = new db_safeguard();
$authentication = new authentication();

$record_id = (int) $_GET['record_id'];
$res = $db->query("system_databases", "SELECT * FROM system_databases WHERE record_id = {$record_id}");
$data = $res->fetch_assoc();

$cpanel_res = $db->query("cpanel", "SELECT * FROM cpanel WHERE record_id = {$data['cpanel_id']}");
$cpanel_data = $cpanel_res->fetch_assoc();

$host = $cpanel_data['domain'];
$user = $data['username'];
$pass = $authentication->decrypt_password($data['password']);
$db = $data['database_name'];

$_SESSION['server'] = $host;
$_SESSION['username'] = $user;
$_SESSION['password'] = $pass;
$_SESSION['database'] = $db;
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Database Viewer</title>
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            font-family: Arial, sans-serif;
            height: 100vh;
            display: flex;
            flex-direction: column;
            background-color: #f4f4f4;
        }

        .header {
            background: #333;
            color: white;
            text-align: center;
            padding: 15px;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        .header button {
            margin: 5px;
            padding: 10px 20px;
            background-color: #5c6bc0;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .header button:hover {
            background-color: #3f4b8e;
        }

        .container {
            display: flex;
            height: calc(100vh - 60px);
            /* Adjusted for header */
        }

        .sidebar {
            width: 150px;
            background-color: #2c3e50;
            color: white;
            padding: 10px;
            overflow-y: auto;
            height: 100%;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
        }

        .sidebar button {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #34495e;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: white;
            text-align: center;
        }

        .sidebar button:hover {
            background-color: #16a085;
        }

        .main-content {
            flex: 1;
            padding: 20px;
            background-color: #fff;
            overflow-y: auto;
            position: relative;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #ecf0f1;
        }

        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #555;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
            margin-right: 10px;
        }

        #loading {
            position: absolute;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: none;
            font-weight: bold;
            background: #fff;
            padding: 10px;
            border: 1px solid #ccc;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            z-index: 10;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .action-btns {
            display: flex;
            justify-content: space-between;
            flex-direction: column;
        }

        .btn-action {
            background-color: #008CBA;
            color: white;
            font-size: 0.7em;
            width: 100px;
            margin-bottom: 5px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
        }

        .btn-action:hover {
            background-color: #007B9F;
        }

        .table-info {
            border: solid white 1px;
            border-radius: 5px;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            flex-direction: column;
            align-items: center;
            margin-bottom: 10px;
        }

        /*
        @media only screen and (max-width: 600px) {
            body {
                background-color: rgb(0, 0, 0);
            }

            .btn-action {
                background-color: #008CBA;
                color: white;
                font-size: 2em;
                width: 100px;
                margin-bottom: 5px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                text-align: center;
            }

            .sidebar button {
                display: block;
                width: 100%;
                padding: 10px;
                background-color: #34495e;
                border: none;
                cursor: pointer;
                border-radius: 5px;
                color: white;
                text-align: center;
                font-size: 2em;
            }

            .btn-action:hover {
                background-color: #007B9F;
            }

            .table-info {
                border: solid white 1px;
                border-radius: 5px;
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                flex-direction: column;
                align-items: center;
                margin-bottom: 10px;
            }

            .sidebar {
                width: 450px;
                background-color: #2c3e50;
                color: white;
                padding: 10px;
                overflow-y: auto;
                height: 100%;
                box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            }

            .sidebar button {
                display: block;
                width: 100%;
                padding: 10px;
                background-color: #34495e;
                border: none;
                cursor: pointer;
                border-radius: 5px;
                color: white;
                text-align: center;
            }

        }
        */
    </style>
</head>

<body>
    <div class="header">
        <button onclick="popup()">Query DB</button>
        <button onclick="window.location.href='create_table.php?record_id=<?= $record_id ?>'">New Table</button>
    </div>
    <div class="container">
        <div class="sidebar">
            <?php
            $conn = mysqli_connect($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);
            if (!$conn) {
                die("Connection failed: " . mysqli_connect_error());
            }

            $result = mysqli_query($conn, "SHOW TABLES");

            if ($result) {
                while ($row = mysqli_fetch_row($result)) {
                    $table_name = $row[0];
                    // Get the number of records
                    $record_count = mysqli_query($conn, "SELECT COUNT(*) FROM $table_name")->fetch_row()[0];
                    // Get table size in bytes
                    $size = mysqli_query($conn, "SHOW TABLE STATUS LIKE '$table_name'")->fetch_assoc();
                    $size_in_mb = round($size['Data_length'] / 1048576, 2); // Convert to MB
            
                    echo "<div class='table-info'>
                    <button onclick=\"openTable('$table_name')\">$table_name</button>
                    <p style='font-size: 10px;'>Records: $record_count <br> Size: $size_in_mb MB</p>
                    <div class='action-btns'>
                        <a class='btn-action' onclick='drop_table(\"$table_name\")'>Drop</a>
                        <a onclick='empty_table(\"$table_name\")' class='btn-action'>Empty</a>
                        <a href='modify_table.php?table=$table_name&record_id=$record_id' class='btn-action'>Modify</a>
                        <a href='insert.php?table=$table_name&record_id=$record_id' class='btn-action'>Insert</a>
                    </div>
                </div>";
                }
            } else {
                echo "Error: " . mysqli_error($conn);
            }
            ?>
        </div>
        <div class="main-content">
            <div id="loading"><span class="spinner"></span>Loading...</div>
            <div id="table_content">Select a table to view its contents.</div>
        </div>
    </div>

    <script>

        function drop_table(table_name) {
            const confirmation = confirm("Are you sure you want to delete this table " + table_name + "?");
            if (confirmation) {
                window.location.href = "delete_table.php?table=" + table_name + "&record_id=<?php echo $record_id; ?>";
            }
        }
        function empty_table(table_name) {
            const confirmation = confirm("Are you sure you want to empty this table " + table_name + "?");
            if (confirmation) {
                window.location.href = "empty_table.php?table=" + table_name + "&record_id=<?php echo $record_id; ?>";
            }
        }
        function openTable(tableName) {
            const loading = document.getElementById('loading');
            const content = document.getElementById('table_content');

            loading.style.display = 'block';
            content.innerHTML = '';

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function () {
                loading.style.display = 'none';
                content.innerHTML = this.responseText;
            };
            xhttp.open("GET", "get_table_data.php?table=" + encodeURIComponent(tableName), true);
            xhttp.send();
        }

        function popup() {
            let popupDiv = document.createElement("div");
            popupDiv.style.position = "fixed";
            popupDiv.style.top = "10%";
            popupDiv.style.left = "10%";
            popupDiv.style.width = "80%";
            popupDiv.style.height = "80%";
            popupDiv.style.backgroundColor = "white";
            popupDiv.style.padding = "20px";
            popupDiv.style.border = "1px solid black";
            popupDiv.style.boxShadow = "0 2px 15px rgba(0,0,0,0.1)";
            popupDiv.style.overflow = "auto";

            popupDiv.innerHTML = ` 
                <h2 style='text-align:center'>Query DB</h2>
                <label for='query'>Query:</label><br>
                <textarea id='query' rows='10' cols='50' style='width:100%'></textarea><br>
                <label for='response'>Response:</label><br>
                <textarea id='response' rows='10' cols='50' style='width:100%' readonly></textarea><br>
                <button id='submit_btn'>Submit</button>
                <button id='close_btn'>Close</button>
            `;

            document.body.appendChild(popupDiv);
            document.body.style.overflow = "hidden";

            document.getElementById('submit_btn').onclick = function () {
                const query = document.getElementById('query').value;
                const responseBox = document.getElementById('response');
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function () {
                    responseBox.value = this.responseText;
                };
                xhttp.open("GET", "query_db.php?query=" + encodeURIComponent(query), true);
                xhttp.send();
            };

            document.getElementById('close_btn').onclick = function () {
                document.body.removeChild(popupDiv);
                document.body.style.overflow = "auto";
            };
        }

        function updatedb(record_id, table_name, column_name, input, index) {
            var value = input.value;
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    if (this.responseText == 1) {
                        var el = document.getElementById("A_" + index);
                        el.style.transition = "background-color 2s";
                        el.style.backgroundColor = "green";
                        setTimeout(function () {
                            el.style.backgroundColor = "white";
                        }, 2000);
                    }
                }
            }
            xhr.open('GET', 'update_table_data.php?record_id=' + record_id + '&table_name=' + table_name + '&column_name=' + column_name + '&value=' + value);
            xhr.send();
        }

        function deleteRow(recordId, tableName) {
            const confirmation = confirm("Are you sure you want to delete this row?");
            if (confirmation) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function () {
                    if (this.responseText == "success") {
                        alert("Row deleted successfully.");
                        // Reload the table without refreshing the entire page
                        loadTable(tableName);
                    } else {
                        alert("Error deleting row.");
                    }
                };
                xhttp.open("GET", "delete_row.php?record_id=" + recordId + "&table=" + tableName, true);
                xhttp.send();
            }
        }

        // Function to reload the table content after deletion
        function loadTable(tableName) {
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function () {
                document.getElementById("table-container").innerHTML = this.responseText;
            };
            xhttp.open("GET", "get_table_data.php?table=" + tableName, true);
            xhttp.send();
        }
    </script>
</body>

</html>