<?php
session_start();
function buildTableFromDatabase($tableName)
{
    $db = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);
    if ($db->connect_error) {
        die("Connection failed: " . $db->connect_error);
    }

    $result = $db->query("SELECT * FROM $tableName ORDER BY record_id DESC");

    $html = '<div id="table-container">';  // Added a container div for the table

    $html .= '<table border="1" style="width: 100%;">';

    // Fetch the column names for the table header
    $column_arr = [];
    while ($field = $result->fetch_field()) {
        $column_arr[] = $field->name;
        $html .= '<th>' . $field->name . '</th>';
    }
    $html .= '<th>Actions</th>';  // Add Actions column for the delete button
    $html .= '</tr>';

    $html .= '<tr>';
    $html .= '<td colspan= "'.count($column_arr).'">';
    $html .= 'Total Records: ' . $result->num_rows;

    // Calculate database size
    $dbSizeResult = $db->query("SELECT table_name AS 'table', 
        SUM(data_length + index_length) / 1024 / 1024 AS 'size_mb' 
        FROM information_schema.TABLES 
        WHERE table_name = '" . $tableName . "' 
        GROUP BY table_name");
    $dbSizeRow = $dbSizeResult->fetch_assoc();

    $html .= ', Database Size: ' . $dbSizeRow['size_mb'] . ' MB';
    $html .= '</td>';
    $html .= '</tr>';

    // Fetch the data rows
    $id_index = 0;
    while ($row = $result->fetch_assoc()) {
        $record_id = $row['record_id'];
        $html .= '<tr>';
        $index = 0;

        foreach ($row as $cell) {
            $html .= '<td><textarea type="text" class="table_input" onchange="updatedb(\'' . $record_id . '\',\'' . $tableName . '\',\'' . $column_arr[$index] . '\',this,' . $id_index . ')" id="A_' . $id_index . '">' . $cell . '</textarea></td>';
            $index++;
            $id_index++;
        }

        // Add delete button to the last column
        $html .= '<td><button onclick="deleteRow(' . $record_id . ', \'' . $tableName . '\')">Delete</button></td>';
        $html .= '</tr>';
    }
    $html .= '</table>';

    $html .= '</div>';  // Closing the container div

    return $html;
}

if (isset($_GET['table'])) {
    echo buildTableFromDatabase($_GET['table']);
}
?>
