<?php
session_start();
$tableName = $_GET['table'] ?? '';
$recordId = $_GET['record_id'] ?? '';
$conn = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$columns = [];
if ($tableName) {
    $result = $conn->query("SHOW COLUMNS FROM `$tableName`");
    while ($row = $result->fetch_assoc()) {
        $columns[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Edit Table</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        /* Uses your exact styles */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1200px;
            margin: 50px auto;
            padding: 20px;
            background-color: #f4f4f4;
            border-radius: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table th,
        table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        table th {
            background-color: #4CAF50;
            color: white;
        }

        form {
            display: flex;
            flex-direction: column;
            margin-top: 20px;
        }

        form label {
            margin-bottom: 5px;
            font-weight: bold;
        }

        form input,
        form select {
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            width: 100%;
            box-sizing: border-box;
        }

        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }

        .form-row div {
            flex: 1;
            margin-right: 10px;
        }

        .form-row div:last-child {
            margin-right: 0;
        }

        .submit-btn {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
        }

        .submit-btn:hover {
            background-color: #45a049;
        }

        .add-column-btn {
            background-color: #008CBA;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .add-column-btn:hover {
            background-color: #007B9F;
        }
    </style>
</head>

<body>

    <div class="container">
        <h1>Edit Table: <?php echo htmlspecialchars($tableName); ?></h1>
        <form action="modify_table_action.php" method="POST" id="editTableForm">
            <input type="text" hidden name="table_name" value="<?php echo htmlspecialchars($tableName); ?>" required>
            <input type="text" hidden name="record_id" value="<?php echo htmlspecialchars($recordId); ?>" required>

            <div id="columnsContainer">
                <?php foreach ($columns as $i => $col): ?>
                    <div class="form-row">
                        <div>
                            <label>Column Name:</label>
                            <input type="text" name="column_name[]" value="<?php echo $col['Field']; ?>" required>
                        </div>
                        <div>
                            <label>Column Type:</label>
                            <select name="column_type[]" required>
                                <?php
                                $type = strtoupper(preg_replace('/\(.*/', '', $col['Type']));
                                $options = ["INT", "VARCHAR", "TEXT", "DATE", "DATETIME"];
                                foreach ($options as $opt) {
                                    $selected = ($type === $opt) ? 'selected' : '';
                                    echo "<option value='$opt' $selected>$opt</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div>
                            <label>Column Length:</label>
                            <input type="number" name="column_length[]" value="<?php
                            preg_match('/\((\d+)\)/', $col['Type'], $matches);
                            echo $matches[1] ?? '';
                            ?>" >
                        </div>
                        <div>
                            <label>Allow NULL:</label>
                            <input type="checkbox" name="column_null[<?php echo $i; ?>]" <?php echo ($col['Null'] === "YES") ? "checked" : ""; ?>>
                        </div>
                        <div>
                            <label>Auto Increment:</label>
                            <input type="checkbox" name="column_auto_increment[<?php echo $i; ?>]" <?php echo (strpos($col['Extra'], "auto_increment") !== false) ? "checked" : ""; ?>>
                        </div>
                        <div>
                            <label>Unique Key:</label>
                            <input type="checkbox" name="column_unique[<?php echo $i; ?>]" <?php echo ($col['Key'] === "UNI") ? "checked" : ""; ?>>
                        </div>
                        <div>
                            <label>Default Value:</label>
                            <input type="text" name="column_default_value[]"
                                value="<?php echo htmlspecialchars($col['Default'] ?? ''); ?>">
                        </div>
                        <div>
                            <label>Delete:</label>
                            <button type="button" onclick="this.closest('.form-row').remove()"
                                style="background-color: red; color: white; border: none; padding: 8px; border-radius: 5px;">X</button>
                        </div>
                    </div>

                <?php endforeach; ?>

            </div>
            <button type="button" class="add-column-btn" onclick="addColumn()">+ Add Column</button>

            <button type="submit" class="submit-btn">Save Changes</button>

        </form>
    </div>
</body>

</html>


<script>
    function addColumn() {
        const index = document.querySelectorAll('.form-row').length;
        const container = document.getElementById('columnsContainer');

        const row = document.createElement('div');
        row.className = 'form-row';
        row.innerHTML = `
        <div>
            <label>Column Name:</label>
            <input type="text" name="column_name[]" required>
        </div>
        <div>
            <label>Column Type:</label>
            <select name="column_type[]" required>
                <option value="INT">INT</option>
                <option value="VARCHAR">VARCHAR</option>
                <option value="TEXT">TEXT</option>
                <option value="DATE">DATE</option>
                <option value="DATETIME">DATETIME</option>
            </select>
        </div>
        <div>
            <label>Column Length:</label>
            <input type="number" name="column_length[]" required>
        </div>
        <div>
            <label>Allow NULL:</label>
            <input type="checkbox" name="column_null[${index}]">
        </div>
        <div>
            <label>Auto Increment:</label>
            <input type="checkbox" name="column_auto_increment[${index}]">
        </div>
        <div>
            <label>Unique Key:</label>
            <input type="checkbox" name="column_unique[${index}]">
        </div>
        <div>
            <label>Default Value:</label>
            <input type="text" name="column_default_value[]">
        </div>
        <div>
            <label>Delete:</label>
            <button type="button" onclick="this.closest('.form-row').remove()" style="background-color: red; color: white; border: none; padding: 8px; border-radius: 5px;">X</button>
        </div>
    `;

        container.appendChild(row);
    }
</script>